/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;

public class Equalizer
implements PlugInFilter {
    ImagePlus imp;
    int[] histogram;
    int max;
    int range;
    boolean classicEqualization = IJ.altKeyDown();

    public int setup(String string, ImagePlus imagePlus) {
        if (imagePlus == null) {
            return 4096;
        }
        this.imp = imagePlus;
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        this.histogram = imageProcessor.getHistogram();
        imagePlus.killRoi();
        if (string.equals("classic")) {
            this.classicEqualization = true;
        }
        return IJ.setupDialog(imagePlus, 21);
    }

    private double getWeightedValue(int n) {
        int n2 = this.histogram[n];
        if (n2 < 2 || this.classicEqualization) {
            return n2;
        }
        return Math.sqrt(n2);
    }

    public void run(ImageProcessor imageProcessor) {
        if (this.histogram == null) {
            return;
        }
        if (imageProcessor instanceof ShortProcessor) {
            if (this.imp.getStackSize() > 1) {
                return;
            }
            this.max = 65535;
            this.range = 65535;
        } else {
            this.max = 255;
            this.range = 255;
        }
        double d = this.getWeightedValue(0);
        int n = 1;
        while (n < this.max) {
            d += 2.0 * this.getWeightedValue(n);
            ++n;
        }
        double d2 = (double)this.range / (d += this.getWeightedValue(this.max));
        int[] nArray = new int[this.range + 1];
        nArray[0] = 0;
        d = this.getWeightedValue(0);
        int n2 = 1;
        while (n2 < this.max) {
            double d3 = this.getWeightedValue(n2);
            nArray[n2] = (int)Math.round((d += d3) * d2);
            d += d3;
            ++n2;
        }
        nArray[this.max] = this.max;
        imageProcessor.applyTable(nArray);
    }
}

