/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.util.StringTokenizer;

public class Convolver
implements PlugInFilter {
    static final int BYTE = 0;
    static final int SHORT = 1;
    static final int FLOAT = 2;
    static final int RGB = 3;
    static String kernelText = ".0625  .125  .0625\n.125    .25    .125\n.0625  .125  .0625";
    static boolean normalize = true;
    static boolean createSelection = false;
    static float[] kernel;
    static int slice;
    static boolean canceled;
    static ImageWindow win;
    ImagePlus imp;
    int kw;
    int kh;
    private static /* synthetic */ Class class$Lij$plugin$filter$Convolver;

    public int setup(String string, ImagePlus imagePlus) {
        IJ.register(class$Lij$plugin$filter$Convolver != null ? class$Lij$plugin$filter$Convolver : (class$Lij$plugin$filter$Convolver = Convolver.class$("ij.plugin.filter.Convolver")));
        this.imp = imagePlus;
        slice = 0;
        canceled = false;
        return IJ.setupDialog(imagePlus, 31);
    }

    public void run(ImageProcessor imageProcessor) {
        if (canceled) {
            return;
        }
        if (++slice == 1) {
            kernel = this.getKernel();
            if (kernel == null) {
                canceled = true;
                return;
            }
            if ((this.kw & 1) == 0) {
                IJ.showMessage("Convolver", "The kernel must be square and have an\nodd width. This kernel is " + this.kw + "x" + this.kh + ".");
                canceled = true;
                return;
            }
            win = this.imp.getWindow();
            Convolver.win.running = true;
            IJ.showStatus("Convolver: convolving with " + this.kw + "x" + this.kh + " kernel");
            this.imp.startTiming();
        }
        if (!Convolver.win.running) {
            canceled = true;
            return;
        }
        this.convolve(imageProcessor, kernel, this.kw, this.kh);
        if (slice > 1) {
            IJ.showStatus(slice + "/" + this.imp.getStackSize());
        }
        if (slice == this.imp.getStackSize()) {
            imageProcessor.resetMinAndMax();
            if (createSelection) {
                this.imp.setRoi(this.kw / 2, this.kh / 2, this.imp.getWidth() - this.kw / 2 * 2, this.imp.getHeight() - this.kh / 2 * 2);
            }
        }
    }

    float[] getKernel() {
        GenericDialog genericDialog = new GenericDialog("Convolver...", IJ.getInstance());
        genericDialog.addTextAreas(kernelText, null, 10, 30);
        genericDialog.addCheckbox("Normalize Kernel", normalize);
        genericDialog.addCheckbox("Create Selection", createSelection);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            canceled = true;
            return null;
        }
        kernelText = genericDialog.getNextText();
        normalize = genericDialog.getNextBoolean();
        createSelection = genericDialog.getNextBoolean();
        StringTokenizer stringTokenizer = new StringTokenizer(kernelText);
        int n = stringTokenizer.countTokens();
        this.kh = this.kw = (int)Math.sqrt(n);
        n = this.kw * this.kh;
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = (float)this.getNum(stringTokenizer);
            ++n2;
        }
        return fArray;
    }

    double getNum(StringTokenizer stringTokenizer) {
        Double d;
        String string = stringTokenizer.nextToken();
        try {
            d = new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    public void convolve(ImageProcessor imageProcessor, float[] fArray, int n, int n2) {
        int n3 = imageProcessor instanceof ByteProcessor ? 0 : (imageProcessor instanceof ShortProcessor ? 1 : (imageProcessor instanceof FloatProcessor ? 2 : 3));
        if (n3 == 3) {
            this.convolveRGB(imageProcessor, fArray, n, n2);
            return;
        }
        ImageProcessor imageProcessor2 = imageProcessor.convertToFloat();
        this.convolveFloat(imageProcessor2, fArray, n, n2);
        switch (n3) {
            case 0: {
                imageProcessor2 = imageProcessor2.convertToByte(false);
                byte[] byArray = (byte[])imageProcessor.getPixels();
                byte[] byArray2 = (byte[])imageProcessor2.getPixels();
                System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
                break;
            }
            case 1: {
                imageProcessor2 = imageProcessor2.convertToShort(false);
                short[] sArray = (short[])imageProcessor.getPixels();
                short[] sArray2 = (short[])imageProcessor2.getPixels();
                System.arraycopy(sArray2, 0, sArray, 0, sArray.length);
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void convolveRGB(ImageProcessor imageProcessor, float[] fArray, int n, int n2) {
        int n3 = imageProcessor.getWidth();
        int n4 = imageProcessor.getHeight();
        int n5 = n3 * n4;
        byte[] byArray = new byte[n5];
        byte[] byArray2 = new byte[n5];
        byte[] byArray3 = new byte[n5];
        ((ColorProcessor)imageProcessor).getRGB(byArray, byArray2, byArray3);
        ByteProcessor byteProcessor = new ByteProcessor(n3, n4, byArray, null);
        ByteProcessor byteProcessor2 = new ByteProcessor(n3, n4, byArray2, null);
        ByteProcessor byteProcessor3 = new ByteProcessor(n3, n4, byArray3, null);
        ImageProcessor imageProcessor2 = byteProcessor.convertToFloat();
        this.convolveFloat(imageProcessor2, fArray, n, n2);
        ImageProcessor imageProcessor3 = imageProcessor2.convertToByte(false);
        imageProcessor2 = byteProcessor2.convertToFloat();
        this.convolveFloat(imageProcessor2, fArray, n, n2);
        ImageProcessor imageProcessor4 = imageProcessor2.convertToByte(false);
        imageProcessor2 = byteProcessor3.convertToFloat();
        this.convolveFloat(imageProcessor2, fArray, n, n2);
        ImageProcessor imageProcessor5 = imageProcessor2.convertToByte(false);
        ((ColorProcessor)imageProcessor).setRGB((byte[])imageProcessor3.getPixels(), (byte[])imageProcessor4.getPixels(), (byte[])imageProcessor5.getPixels());
    }

    public void convolveFloat(ImageProcessor imageProcessor, float[] fArray, int n, int n2) {
        int n3 = imageProcessor.getWidth();
        int n4 = imageProcessor.getHeight();
        int n5 = n / 2;
        int n6 = n2 / 2;
        float[] fArray2 = (float[])imageProcessor.getPixels();
        float[] fArray3 = (float[])imageProcessor.getPixelsCopy();
        int n7 = 0;
        while (n7 < n3 * n4) {
            fArray2[n7] = 0.0f;
            ++n7;
        }
        double d = 1.0;
        if (normalize) {
            double d2 = 0.0;
            int n8 = 0;
            while (n8 < fArray.length) {
                d2 += (double)fArray[n8];
                ++n8;
            }
            if (d2 != 0.0) {
                d = (float)(1.0 / d2);
            }
        }
        int n9 = Math.max(n4 / 25, 1);
        int n10 = n6;
        while (n10 < n4 - n6) {
            if (n10 % n9 == 0) {
                IJ.showProgress((double)n10 / (double)n4);
            }
            int n11 = n5;
            while (n11 < n3 - n5) {
                double d3 = 0.0;
                int n12 = 0;
                int n13 = -n6;
                while (n13 <= n6) {
                    int n14 = n11 + (n10 + n13) * n3;
                    int n15 = -n5;
                    while (n15 <= n5) {
                        d3 += (double)(fArray3[n14 + n15] * fArray[n12++]);
                        ++n15;
                    }
                    ++n13;
                }
                fArray2[n11 + n10 * n3] = (float)(d3 * d);
                ++n11;
            }
            ++n10;
        }
        IJ.showProgress(1.0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

