/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageWindow;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import java.awt.Font;

public class Benchmark
implements PlugInFilter {
    String arg;
    ImagePlus imp;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        if (string.equals("show")) {
            this.showBenchmarkResults();
            return 4096;
        }
        if (string.equals("particles")) {
            this.showParticlesResults();
            return 4096;
        }
        this.arg = string;
        if (string.equals("draw")) {
            return 31;
        }
        return 151;
    }

    public void run(ImageProcessor imageProcessor) {
        Thread.currentThread().setPriority(1);
        if (this.arg.equals("draw")) {
            ImageWindow imageWindow = this.imp.getWindow();
            imageWindow.running = true;
            int n = 200;
            long l = System.currentTimeMillis();
            int n2 = 0;
            while (n2 < n) {
                this.imp.draw();
                Thread.yield();
                if (n2 % 5 == 0) {
                    IJ.showProgress((double)n2 / (double)n);
                }
                if (!imageWindow.running) {
                    IJ.showProgress(1.0);
                    return;
                }
                ++n2;
            }
            IJ.showProgress(1.0);
            n2 = this.imp.getWidth() * this.imp.getHeight() * n;
            long l2 = System.currentTimeMillis() - l;
            double d = (double)l2 / 1000.0;
            IJ.write(IJ.d2s((double)n2 / d / 1000000.0) + " million pixels per second");
            return;
        }
        imageProcessor.setInterpolate(false);
        int n = 0;
        while (n < 4) {
            imageProcessor.invert();
            this.imp.updateAndDraw();
            ++n;
        }
        n = 0;
        while (n < 4) {
            imageProcessor.flipVertical();
            this.imp.updateAndDraw();
            ++n;
        }
        imageProcessor.flipHorizontal();
        this.imp.updateAndDraw();
        imageProcessor.flipHorizontal();
        this.imp.updateAndDraw();
        n = 0;
        while (n < 6) {
            imageProcessor.smooth();
            this.imp.updateAndDraw();
            ++n;
        }
        imageProcessor.reset();
        n = 0;
        while (n < 6) {
            imageProcessor.sharpen();
            this.imp.updateAndDraw();
            ++n;
        }
        imageProcessor.reset();
        imageProcessor.smooth();
        this.imp.updateAndDraw();
        imageProcessor.findEdges();
        this.imp.updateAndDraw();
        imageProcessor.invert();
        this.imp.updateAndDraw();
        imageProcessor.autoThreshold();
        this.imp.updateAndDraw();
        imageProcessor.reset();
        imageProcessor.medianFilter();
        this.imp.updateAndDraw();
        n = 0;
        while (n < 360) {
            imageProcessor.reset();
            imageProcessor.rotate(n);
            this.imp.updateAndDraw();
            n += 15;
        }
        double d = 1.5;
        int n3 = 0;
        while (n3 < 8) {
            imageProcessor.reset();
            imageProcessor.scale(d, d);
            this.imp.updateAndDraw();
            d *= 1.5;
            ++n3;
        }
        n3 = 0;
        while (n3 < 12) {
            imageProcessor.reset();
            imageProcessor.scale(d /= 1.5, d);
            this.imp.updateAndDraw();
            ++n3;
        }
        imageProcessor.reset();
        this.imp.updateAndDraw();
    }

    void showBenchmarkResults() {
        TextWindow textWindow = new TextWindow("ImageJ Benchmark", "", 450, 450);
        textWindow.setFont(new Font("Monospaced", 0, 12));
        textWindow.append("Time in seconds needed to perform 62 image processing");
        textWindow.append("operations on the 512x512 \"Mandrill\" image");
        textWindow.append("---------------------------------------------------------");
        textWindow.append(" 3.3   Pentium 4/1.4, Win2K  IE 5.0");
        textWindow.append(" 5.3   Pentium 3/750, Win98  IE 5.0");
        textWindow.append(" 5.6   Pentium 4/1.4, Win2K  JDK 1.3");
        textWindow.append(" 6.0   Pentium 3/750, Win98  Netscape 4.7");
        textWindow.append(" 8.6   PPC G4/400, MacOS     MRJ 2.2");
        textWindow.append(" 9.1   Pentium 2/400, Win95  JRE 1.1.8");
        textWindow.append(" 9.2   Pentium 2/400, Win95  IE 4.0");
        textWindow.append(" 9.8   Pentium 2/400, Linux  IBM JDK 1.1.8");
        textWindow.append("  11   Pentium 2/400, Win95  JDK 1.2 (24% slower)");
        textWindow.append("  11   Pentium 2/400, Win95  Netscape 4.5");
        textWindow.append("  14   PPC G3/300, MacOS     MRJ 2.1");
        textWindow.append("  21   Pentium 2/400, Win95  JDK 1.3 (>2 times slower!!)");
        textWindow.append("  38   PPC 604/132, MacOS    MRJ 2.1ea2");
        textWindow.append("  61   PPC 604/132, MacOS    MRJ 2.0");
        textWindow.append("  89   Pentium/100, Win95    JRE 1.1.6");
        textWindow.append("  96   Pentium/400, Linux    Sun JDK 1.2.2 (17 with JIT)");
        textWindow.append("");
    }

    void showParticlesResults() {
        TextWindow textWindow = new TextWindow("Particles Benchmark", "", 450, 500);
        textWindow.setFont(new Font("Monospaced", 0, 12));
        textWindow.append("These are times in seconds needed to measure the size");
        textWindow.append("and location of 5097 objects in a 2000x1000 binary image.");
        textWindow.append("Tests were run on 400Mhz Pentiums and a 400Mhz G3 Mac.");
        textWindow.append("");
        textWindow.append("24  Netscape 4.5");
        textWindow.append("24  Internet Explorer 4.0");
        textWindow.append("28  JDK 1.3");
        textWindow.append("30  JDK 1.2");
        textWindow.append("33  JDK 1.1.8");
        textWindow.append("35  MacOS Runtime for Java 2.2");
        textWindow.append("60  Sun JDK 1.2.2 for Linux");
        textWindow.append("70  IBM JDK 1.1.8 for Linux");
        textWindow.append("");
        textWindow.append("To run the benchmark:");
        textWindow.append("");
        textWindow.append("1) Open the test image using File/Open Samples/Particles.");
        textWindow.append("2) Check \"Area\" and \"Centroid\" in Analalyze/Set Measurements.");
        textWindow.append("3) Select Analyze/Analyze Particles.");
        textWindow.append("3) Check \"Display Results\" and then click \"OK\".");
    }
}

