/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.filter.RollingBall;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;

public class BackgroundSubtracter
implements PlugInFilter {
    static int radius = 50;
    private ImagePlus imp;
    private static /* synthetic */ Class class$Lij$plugin$filter$BackgroundSubtracter;

    public int setup(String string, ImagePlus imagePlus) {
        IJ.register(class$Lij$plugin$filter$BackgroundSubtracter != null ? class$Lij$plugin$filter$BackgroundSubtracter : (class$Lij$plugin$filter$BackgroundSubtracter = BackgroundSubtracter.class$("ij.plugin.filter.BackgroundSubtracter")));
        this.imp = imagePlus;
        return 17;
    }

    public void run(ImageProcessor imageProcessor) {
        GenericDialog genericDialog = new GenericDialog("Subtract Background", IJ.getInstance());
        genericDialog.addNumericField("Rolling Ball Radius:", radius, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        radius = (int)genericDialog.getNextNumber();
        if (imageProcessor instanceof ColorProcessor) {
            this.subtractRGBBackround((ColorProcessor)imageProcessor, radius);
        } else {
            this.subtractBackround(imageProcessor, radius);
        }
    }

    public void subtractRGBBackround(ColorProcessor colorProcessor, int n) {
        int n2 = colorProcessor.getWidth();
        int n3 = colorProcessor.getHeight();
        byte[] byArray = new byte[n2 * n3];
        byte[] byArray2 = new byte[n2 * n3];
        byte[] byArray3 = new byte[n2 * n3];
        colorProcessor.getHSB(byArray, byArray2, byArray3);
        ByteProcessor byteProcessor = new ByteProcessor(n2, n3, byArray3, null);
        this.subtractBackround(byteProcessor, radius);
        colorProcessor.setHSB(byArray, byArray2, (byte[])byteProcessor.getPixels());
    }

    public void subtractBackround(ImageProcessor imageProcessor, int n) {
        if (this.imp != null) {
            this.imp.killRoi();
        } else {
            imageProcessor.setRoi(null);
        }
        imageProcessor.setProgressBar(null);
        IJ.showProgress(0.0);
        RollingBall rollingBall = new RollingBall(n);
        ImageProcessor imageProcessor2 = this.shrinkImage(imageProcessor, rollingBall.shrinkfactor);
        IJ.showStatus("Rolling ball (" + rollingBall.shrinkfactor + ")...");
        ImageProcessor imageProcessor3 = this.rollBall(rollingBall, imageProcessor, imageProcessor2);
        this.interpolateBackground(imageProcessor3, rollingBall);
        this.extrapolateBackground(imageProcessor3, rollingBall);
        IJ.showProgress(0.9);
        if (IJ.altKeyDown()) {
            new ImagePlus("background", imageProcessor3).show();
        }
        imageProcessor.copyBits(imageProcessor3, 0, 0, 4);
        IJ.showProgress(1.0);
    }

    ImageProcessor rollBall(RollingBall rollingBall, ImageProcessor imageProcessor, ImageProcessor imageProcessor2) {
        byte[] byArray = (byte[])imageProcessor2.getPixels();
        byte[] byArray2 = rollingBall.data;
        int n = imageProcessor.getWidth();
        int n2 = imageProcessor.getHeight();
        int n3 = imageProcessor2.getWidth();
        int n4 = imageProcessor2.getHeight();
        ByteProcessor byteProcessor = new ByteProcessor(n, n2);
        byte[] byArray3 = (byte[])((ImageProcessor)byteProcessor).getPixels();
        int n5 = rollingBall.shrinkfactor;
        int n6 = 0;
        int n7 = n / n5 - 1;
        int n8 = 0;
        int n9 = n2 / n5 - 1;
        int n10 = 1;
        int n11 = n7 - n6 - 1;
        int n12 = 1;
        int n13 = n9 - n8 - 1;
        int n14 = n3;
        int n15 = rollingBall.patchwidth;
        int n16 = n15 / 2;
        int n17 = n5 * n;
        int n18 = 0;
        int n19 = n12;
        while (n19 <= n13 + n15) {
            int n20 = n10;
            while (n20 <= n11 + n15) {
                int n21;
                int n22;
                int n23 = 255;
                int n24 = 0;
                int n25 = n19 - n15;
                int n26 = n25 * n14 + n20 - n15;
                while (n25 <= n19) {
                    n22 = n20 - n15;
                    while (n22 <= n20) {
                        int n27;
                        int n28;
                        if (n22 >= n10 && n22 <= n11 && n25 >= n12 && n25 <= n13 && (n28 = (byArray[n27 = n26] & 0xFF) - (n18 + (byArray2[n21 = n24] & 0xFF))) < n23) {
                            n23 = n28;
                        }
                        ++n24;
                        ++n22;
                        ++n26;
                    }
                    ++n25;
                    n26 = n26 - n15 - 1 + n14;
                }
                if (n23 != 0) {
                    n18 += n23;
                }
                int n29 = n23 < 0 ? n16 : 0;
                int n30 = n19 - n15;
                n25 = 0;
                n24 = 0;
                int n31 = (n30 - n12 + 1) * n17;
                while (n25 <= n15) {
                    int n32 = n20 - n15 + n29;
                    n22 = n29;
                    n24 += n29;
                    int n33 = n31 + (n32 - n10 + 1) * n5;
                    while (n22 <= n15) {
                        if (n32 >= n10 && n32 <= n11 && n30 >= n12 && n30 <= n13) {
                            n21 = n24;
                            int n34 = n18 + (byArray2[n21] & 0xFF);
                            if (n34 > (byArray3[n21 = n33] & 0xFF)) {
                                byArray3[n21] = (byte)n34;
                            }
                        }
                        ++n24;
                        ++n32;
                        ++n22;
                        n33 += n5;
                    }
                    ++n30;
                    ++n25;
                    n31 += n17;
                }
                ++n20;
            }
            if (n19 % 20 == 0) {
                IJ.showProgress(0.2 + 0.6 * (double)n19 / (double)(n13 + n15));
            }
            ++n19;
        }
        return byteProcessor;
    }

    ImageProcessor shrinkImage(ImageProcessor imageProcessor, int n) {
        int n2 = imageProcessor.getWidth();
        int n3 = imageProcessor.getHeight();
        int n4 = n2 / n;
        int n5 = n3 / n;
        ByteProcessor byteProcessor = new ByteProcessor(n2, n3, (byte[])imageProcessor.getPixels(), imageProcessor.getColorModel());
        byteProcessor.smooth();
        IJ.showProgress(0.1);
        ByteProcessor byteProcessor2 = new ByteProcessor(n4, n5);
        byte[] byArray = (byte[])((ImageProcessor)byteProcessor).getPixels();
        byte[] byArray2 = (byte[])((ImageProcessor)byteProcessor2).getPixels();
        int n6 = 0;
        while (n6 < n4 * n5) {
            int n7 = n * (n6 % n4);
            int n8 = n * (n6 / n4);
            int n9 = 255;
            int n10 = n2 - n;
            int n11 = n8 * n2 + n7;
            int n12 = 1;
            while (n12 <= n) {
                int n13 = 1;
                while (n13 <= n) {
                    int n14;
                    if ((n14 = byArray[n11++] & 0xFF) < n9) {
                        n9 = n14;
                    }
                    ++n13;
                }
                n11 += n10;
                ++n12;
            }
            byArray2[n6] = (byte)n9;
            ++n6;
        }
        return byteProcessor2;
    }

    void interpolateBackground(ImageProcessor imageProcessor, RollingBall rollingBall) {
        int n = imageProcessor.getWidth();
        int n2 = imageProcessor.getHeight();
        int n3 = rollingBall.shrinkfactor;
        int n4 = 0;
        int n5 = n / n3 - 1;
        int n6 = 0;
        int n7 = n2 / n3 - 1;
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int n8 = 0;
        int n9 = 1;
        while (n9 <= n7 - n6 - 1) {
            int n10 = 0;
            n8 += n3;
            int n11 = 1;
            while (n11 <= n5 - n4) {
                int n12;
                int n13 = n8 * n + (n10 += n3);
                int n14 = n13 - n3;
                int n15 = byArray[n13] & 0xFF;
                int n16 = byArray[n14] & 0xFF;
                int n17 = 1;
                while (n17 <= n3 - 1) {
                    n12 = n13 - n17;
                    byArray[n12] = (byte)(n16 + (n3 - n17) * (n15 - n16) / n3);
                    ++n17;
                }
                n17 = 0;
                while (n17 <= n3 - 1) {
                    n14 = (n8 - n3) * n + n10 - n17;
                    n13 = n8 * n + n10 - n17;
                    n16 = byArray[n14] & 0xFF;
                    n15 = byArray[n13] & 0xFF;
                    int n18 = 0;
                    int n19 = 1;
                    while (n19 <= n3 - 1) {
                        n12 = n13 + (n18 -= n);
                        byArray[n12] = (byte)(n16 + (n3 - n19) * (n15 - n16) / n3);
                        ++n19;
                    }
                    ++n17;
                }
                ++n11;
            }
            ++n9;
        }
    }

    void extrapolateBackground(ImageProcessor imageProcessor, RollingBall rollingBall) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = imageProcessor.getWidth();
        int n10 = imageProcessor.getHeight();
        int n11 = rollingBall.shrinkfactor;
        int n12 = 0;
        int n13 = n9 / n11 - 1;
        int n14 = 0;
        int n15 = n10 / n11 - 1;
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int n16 = n11;
        while (n16 <= n11 * (n13 - n12) - 1) {
            n8 = n11 * n9 + n16;
            n7 = (n11 + 1) * n9 + n16;
            n6 = byArray[n8] & 0xFF;
            n5 = byArray[n7] & 0xFF;
            n4 = n5 - n6;
            n3 = n8;
            n2 = n6;
            n = 1;
            while (n <= n11) {
                byArray[n3 -= n9] = (n2 -= n4) < 0 ? 0 : (n2 > 255 ? -1 : (byte)n2);
                ++n;
            }
            n8 = (n11 * (n15 - n14 - 1) - 1) * n9 + n16;
            n7 = n11 * (n15 - n14 - 1) * n9 + n16;
            n6 = byArray[n8] & 0xFF;
            n5 = byArray[n7] & 0xFF;
            n4 = n5 - n6;
            n3 = n7;
            n2 = n5;
            n = 1;
            while (n <= n10 - 1 - n11 * (n15 - n14 - 1)) {
                byArray[n3 += n9] = (n2 += n4) < 0 ? 0 : (n2 > 255 ? -1 : (byte)n2);
                ++n;
            }
            ++n16;
        }
        n16 = 0;
        while (n16 < n10) {
            n8 = n16 * n9 + n11;
            n7 = n8 + 1;
            n6 = byArray[n8] & 0xFF;
            n5 = byArray[n7] & 0xFF;
            n4 = n5 - n6;
            n3 = n8;
            n2 = n6;
            n = 1;
            while (n <= n11) {
                byArray[--n3] = (n2 -= n4) < 0 ? 0 : (n2 > 255 ? -1 : (byte)n2);
                ++n;
            }
            n7 = n16 * n9 + n11 * (n13 - n12 - 1) - 1;
            n8 = n7 - 1;
            n6 = byArray[n8] & 0xFF;
            n5 = byArray[n7] & 0xFF;
            n4 = n5 - n6;
            n3 = n7;
            n2 = n5;
            n = 1;
            while (n <= n9 - 1 - n11 * (n13 - n12 - 1) + 1) {
                byArray[++n3] = (n2 += n4) < 0 ? 0 : (n2 > 255 ? -1 : (byte)n2);
                ++n;
            }
            ++n16;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

