/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.SaveChangesDialog;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.MeasurementsWriter;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.FloatStatistics;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.text.TextPanel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Point;
import java.util.Hashtable;
import java.util.Properties;

public class Analyzer
implements PlugInFilter,
Measurements {
    private static final int[] list = new int[]{1, 2, 4, 8, 16, 16, 32, 32, 64, 64, 128, 512, 512, 512, 512, 256, 1024};
    private static final int UNDEFINED = 0;
    private static final int AREAS = 1;
    private static final int LENGTHS = 2;
    private static final int ANGLES = 3;
    private static final int MARK_AND_COUNT = 4;
    private static int mode = 0;
    private static final String MEASUREMENTS = "measurements";
    private static final String MARK_WIDTH = "mark.width";
    private static final String PRECISION = "precision";
    private static boolean unsavedMeasurements;
    public static Color darkBlue;
    private static int systemMeasurements;
    public static int markWidth;
    public static int precision;
    private static float[] umeans;
    private static ResultsTable systemRT;
    private String arg;
    private ImagePlus imp;
    private ResultsTable rt;
    private int measurements;
    private StringBuffer min;
    private StringBuffer max;
    private StringBuffer mean;
    private StringBuffer sd;
    private static /* synthetic */ Class class$Lij$plugin$filter$Analyzer;

    public int setup(String string, ImagePlus imagePlus) {
        this.arg = string;
        this.imp = imagePlus;
        IJ.register(class$Lij$plugin$filter$Analyzer != null ? class$Lij$plugin$filter$Analyzer : (class$Lij$plugin$filter$Analyzer = Analyzer.class$("ij.plugin.filter.Analyzer")));
        if (string.equals("set")) {
            this.doSetDialog();
            return 4096;
        }
        if (string.equals("sum")) {
            this.summarize();
            return 4096;
        }
        if (string.equals("clear")) {
            this.clearWorksheet();
            return 4096;
        }
        return 159;
    }

    public void run(ImageProcessor imageProcessor) {
        this.measure();
    }

    void doSetDialog() {
        GenericDialog genericDialog = new GenericDialog("Set Measurements", IJ.getInstance());
        String[] stringArray = new String[9];
        boolean[] blArray = new boolean[9];
        stringArray[0] = "Area";
        blArray[0] = (systemMeasurements & 1) != 0;
        stringArray[1] = "Mean Gray Value";
        blArray[1] = (systemMeasurements & 2) != 0;
        stringArray[2] = "Standard Deviation";
        blArray[2] = (systemMeasurements & 4) != 0;
        stringArray[3] = "Modal Gray Value";
        blArray[3] = (systemMeasurements & 8) != 0;
        stringArray[4] = "Min & Max Gray Value";
        blArray[4] = (systemMeasurements & 0x10) != 0;
        stringArray[5] = "Centroid";
        blArray[5] = (systemMeasurements & 0x20) != 0;
        stringArray[6] = "Center of Mass";
        blArray[6] = (systemMeasurements & 0x40) != 0;
        stringArray[7] = "Perimeter";
        blArray[7] = (systemMeasurements & 0x80) != 0;
        stringArray[8] = "Bounding Rectangle";
        blArray[8] = (systemMeasurements & 0x200) != 0;
        genericDialog.addCheckboxGroup(5, 2, stringArray, blArray);
        stringArray = new String[2];
        blArray = new boolean[2];
        stringArray[0] = "Limit to Threshold";
        blArray[0] = (systemMeasurements & 0x100) != 0;
        stringArray[1] = "Display Row Labels";
        blArray[1] = (systemMeasurements & 0x400) != 0;
        genericDialog.addCheckboxGroup(1, 2, stringArray, blArray);
        genericDialog.addMessage("");
        genericDialog.addNumericField("Decimal Places:", precision, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        this.setOptions(genericDialog);
        int n = (int)genericDialog.getNextNumber();
        if (n >= 0 && n <= 8 && n != precision) {
            precision = n;
            this.rt.setPrecision(precision);
            if (mode == 1) {
                IJ.setColumnHeadings("");
                this.updateHeadings();
            }
        }
    }

    void clearWorksheet() {
        Analyzer.resetCounter();
    }

    void setOptions(GenericDialog genericDialog) {
        int n = systemMeasurements;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        while (n3 < list.length) {
            if (list[n3] != n2) {
                bl = genericDialog.getNextBoolean();
            }
            n2 = list[n3];
            systemMeasurements = bl ? (systemMeasurements |= list[n3]) : (systemMeasurements &= ~list[n3]);
            ++n3;
        }
        if ((n & 0xFFFFFEFF) != (systemMeasurements & 0xFFFFFEFF)) {
            mode = 0;
        }
        if ((systemMeasurements & 0x400) == 0) {
            systemRT.disableRowLabels();
        }
    }

    void measure() {
        if (Toolbar.getToolId() == 7) {
            this.markAndCount();
            return;
        }
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.getType() >= 5) {
            this.measureLength(roi);
            return;
        }
        if (mode != 1) {
            if (!Analyzer.resetCounter()) {
                return;
            }
            mode = 1;
        }
        ImageStatistics imageStatistics = this.imp.getStatistics(this.measurements);
        this.saveResults(imageStatistics, this.imp.getRoi());
        this.displayResults();
    }

    void markAndCount() {
        Object object;
        if (this.imp.getTitle().equals("Colors")) {
            return;
        }
        int n = -1;
        int n2 = -1;
        ImageWindow imageWindow = this.imp.getWindow();
        if (imageWindow != null) {
            object = imageWindow.getCanvas().getCursorLoc();
            n = ((Point)object).x;
            n2 = ((Point)object).y;
        }
        if (n < 0) {
            return;
        }
        this.imp.killRoi();
        if (mode != 4) {
            if (!Analyzer.resetCounter()) {
                return;
            }
            mode = 4;
        }
        this.incrementCounter();
        object = this.imp.getProcessor();
        Calibration calibration = this.imp.getCalibration();
        ((ImageProcessor)object).setCalibrationTable(calibration.getCTable());
        double d = ((ImageProcessor)object).getPixelValue(n, n2);
        if (markWidth > 0) {
            ((ImageProcessor)object).setColor(Toolbar.getForegroundColor());
            ((ImageProcessor)object).setLineWidth(markWidth);
            ((ImageProcessor)object).moveTo(n, n2);
            ((ImageProcessor)object).lineTo(n, n2);
            this.imp.updateAndDraw();
            ((ImageProcessor)object).setLineWidth(Line.getWidth());
        }
        if ((this.measurements & 0x400) != 0) {
            this.rt.addLabel("File Name", this.getFileName());
        }
        this.rt.addValue("X", calibration.getX(n));
        this.rt.addValue("Y", calibration.getY(n2));
        this.rt.addValue("Value", d);
        this.displayResults();
    }

    void measureAngle(Roi roi) {
        if (mode != 3) {
            if (!Analyzer.resetCounter()) {
                return;
            }
            IJ.setColumnHeadings(" \tangle");
            mode = 3;
        }
        this.incrementCounter();
        IJ.write(this.rt.getCounter() + "\t" + this.n(((PolygonRoi)roi).getAngle()));
    }

    void measureLength(Roi roi) {
        if (mode != 2) {
            if (!Analyzer.resetCounter()) {
                return;
            }
            if ((this.measurements & 0x400) != 0) {
                IJ.setColumnHeadings(" \tFile Name\tlength");
            } else {
                IJ.setColumnHeadings(" \tlength");
            }
            mode = 2;
        }
        this.incrementCounter();
        if ((this.measurements & 0x400) != 0) {
            this.rt.addLabel("File Name", this.getFileName());
        }
        this.rt.addValue("Length", roi.getLength());
        this.displayResults();
    }

    public void saveResults(ImageStatistics imageStatistics, Roi roi) {
        this.incrementCounter();
        int n = this.rt.getCounter();
        if (n <= 20) {
            if (umeans == null) {
                umeans = new float[20];
            }
            Analyzer.umeans[n - 1] = (float)imageStatistics.umean;
        }
        if ((this.measurements & 0x400) != 0) {
            this.rt.addLabel("File Name", this.getFileName());
        }
        if ((this.measurements & 1) != 0) {
            this.rt.addValue(0, imageStatistics.area);
        }
        if ((this.measurements & 2) != 0) {
            this.rt.addValue(1, imageStatistics.mean);
        }
        if ((this.measurements & 4) != 0) {
            this.rt.addValue(2, imageStatistics.stdDev);
        }
        if ((this.measurements & 8) != 0) {
            this.rt.addValue(3, imageStatistics.dmode);
        }
        if ((this.measurements & 0x10) != 0) {
            this.rt.addValue(4, imageStatistics.min);
            this.rt.addValue(5, imageStatistics.max);
        }
        if ((this.measurements & 0x20) != 0) {
            this.rt.addValue(6, imageStatistics.xCentroid);
            this.rt.addValue(7, imageStatistics.yCentroid);
        }
        if ((this.measurements & 0x40) != 0) {
            this.rt.addValue(8, imageStatistics.xCenterOfMass);
            this.rt.addValue(9, imageStatistics.yCenterOfMass);
        }
        if ((this.measurements & 0x80) != 0) {
            double d = roi != null ? roi.getLength() : 0.0;
            this.rt.addValue(10, d);
        }
        if ((this.measurements & 0x200) != 0) {
            this.rt.addValue(11, imageStatistics.roiX);
            this.rt.addValue(12, imageStatistics.roiY);
            this.rt.addValue(13, imageStatistics.roiWidth);
            this.rt.addValue(14, imageStatistics.roiHeight);
        }
    }

    String getFileName() {
        String string = "";
        if (this.imp != null) {
            string = this.imp.getTitle();
            if (this.imp.getStackSize() > 1) {
                int n;
                ImageStack imageStack = this.imp.getStack();
                String string2 = imageStack.getSliceLabel(n = this.imp.getCurrentSlice());
                string = string2 != null && !string2.equals("") ? string + ":" + string2 : string + ":" + n;
            }
        }
        return string;
    }

    public void displayResults() {
        int n = this.rt.getCounter();
        if (n == 1) {
            IJ.setColumnHeadings(this.rt.getColumnHeadings());
        }
        IJ.write(this.rt.getRowAsString(n - 1));
    }

    public void updateHeadings() {
        String string;
        TextPanel textPanel = IJ.getTextPanel();
        if (textPanel == null) {
            return;
        }
        String string2 = textPanel.getColumnHeadings();
        if (string2.equals(string = this.rt.getColumnHeadings())) {
            return;
        }
        IJ.setColumnHeadings(string);
        int n = this.rt.getCounter();
        if (n > 0) {
            StringBuffer stringBuffer = new StringBuffer(n * string.length());
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(this.rt.getRowAsString(n2) + "\n");
                ++n2;
            }
            textPanel.append(new String(stringBuffer));
        }
    }

    public String n(double d) {
        String string = (double)Math.round(d) == d ? IJ.d2s(d, 0) : IJ.d2s(d, precision);
        return string + "\t";
    }

    void incrementCounter() {
        if (this.rt == null) {
            this.rt = systemRT;
        }
        this.rt.incrementCounter();
        unsavedMeasurements = true;
    }

    public void summarize() {
        String string;
        this.rt = systemRT;
        if (this.rt.getCounter() == 0) {
            return;
        }
        this.measurements = systemMeasurements;
        this.min = new StringBuffer(100);
        this.max = new StringBuffer(100);
        this.mean = new StringBuffer(100);
        this.sd = new StringBuffer(100);
        this.min.append("Min\t");
        this.max.append("Max\t");
        this.mean.append("Mean\t");
        this.sd.append("SD\t");
        if ((this.measurements & 0x400) != 0) {
            this.min.append("\t");
            this.max.append("\t");
            this.mean.append("\t");
            this.sd.append("\t");
        }
        if (mode == 4) {
            this.summarizePoints(this.rt);
        } else if (mode == 2) {
            this.add2(this.rt.getColumnIndex("Length"));
        } else {
            this.summarizeAreas();
        }
        TextPanel textPanel = IJ.getTextPanel();
        if (textPanel != null && (string = textPanel.getColumnHeadings()).equals("")) {
            IJ.setColumnHeadings(this.rt.getColumnHeadings());
        }
        IJ.write("");
        IJ.write(new String(this.mean));
        IJ.write(new String(this.sd));
        IJ.write(new String(this.min));
        IJ.write(new String(this.max));
        IJ.write("");
        this.mean = null;
        this.sd = null;
        this.min = null;
        this.max = null;
    }

    void summarizePoints(ResultsTable resultsTable) {
        this.add2(resultsTable.getColumnIndex("X"));
        this.add2(resultsTable.getColumnIndex("Y"));
        this.add2(resultsTable.getColumnIndex("Value"));
    }

    void summarizeAreas() {
        if ((this.measurements & 1) != 0) {
            this.add2(0);
        }
        if ((this.measurements & 2) != 0) {
            this.add2(1);
        }
        if ((this.measurements & 4) != 0) {
            this.add2(2);
        }
        if ((this.measurements & 8) != 0) {
            this.add2(3);
        }
        if ((this.measurements & 0x10) != 0) {
            this.add2(4);
            this.add2(5);
        }
        if ((this.measurements & 0x20) != 0) {
            this.add2(6);
            this.add2(7);
        }
        if ((this.measurements & 0x40) != 0) {
            this.add2(8);
            this.add2(9);
        }
        if ((this.measurements & 0x80) != 0) {
            this.add2(10);
        }
        if ((this.measurements & 0x200) != 0) {
            this.add2(11);
            this.add2(12);
            this.add2(13);
            this.add2(14);
        }
    }

    private void add2(int n) {
        float[] fArray;
        float[] fArray2 = fArray = n >= 0 ? this.rt.getColumn(n) : null;
        if (fArray != null) {
            FloatProcessor floatProcessor = new FloatProcessor(fArray.length, 1, fArray, null);
            if (floatProcessor == null) {
                return;
            }
            FloatStatistics floatStatistics = new FloatStatistics(floatProcessor);
            if (floatStatistics == null) {
                return;
            }
            this.mean.append(this.n(floatStatistics.mean));
            this.min.append(this.n(floatStatistics.min));
            this.max.append(this.n(floatStatistics.max));
            this.sd.append(this.n(floatStatistics.stdDev));
        } else {
            this.mean.append("-\t");
            this.min.append("-\t");
            this.max.append("-\t");
            this.sd.append("-\t");
        }
    }

    public static int getCounter() {
        return systemRT.getCounter();
    }

    public static synchronized boolean resetCounter() {
        Container container;
        int n = IJ.getTextPanel().getLineCount();
        int n2 = systemRT.getCounter();
        if (n2 > 0 && n > 0 && unsavedMeasurements) {
            container = new SaveChangesDialog((Frame)IJ.getInstance(), "Save " + n2 + " measurements?");
            if (((SaveChangesDialog)container).cancelPressed()) {
                return false;
            }
            if (((SaveChangesDialog)container).savePressed()) {
                new MeasurementsWriter().run("");
            }
        }
        umeans = null;
        systemRT.reset();
        unsavedMeasurements = false;
        container = IJ.getTextPanel();
        if (container != null) {
            ((TextPanel)container).selectAll();
            ((TextPanel)container).clearSelection();
        }
        return true;
    }

    public static void setSaved() {
        unsavedMeasurements = false;
    }

    public static int getMeasurements() {
        return systemMeasurements;
    }

    public static void setMeasurements(int n) {
        systemMeasurements = n;
    }

    public static void savePreferences(Properties properties) {
        ((Hashtable)properties).put(MEASUREMENTS, Integer.toString(systemMeasurements));
        ((Hashtable)properties).put(MARK_WIDTH, Integer.toString(markWidth));
        ((Hashtable)properties).put(PRECISION, Integer.toString(precision));
    }

    public static float[] getUMeans() {
        return umeans;
    }

    public static ResultsTable getResultsTable() {
        return systemRT;
    }

    public static int getPrecision() {
        return precision;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Analyzer() {
        this.rt = systemRT;
        this.rt.setPrecision(precision);
        this.measurements = systemMeasurements;
    }

    public Analyzer(ImagePlus imagePlus) {
        this();
        this.imp = imagePlus;
    }

    public Analyzer(ImagePlus imagePlus, int n, ResultsTable resultsTable) {
        this.imp = imagePlus;
        this.measurements = n;
        this.rt = resultsTable;
    }

    static {
        darkBlue = new Color(0, 0, 160);
        systemMeasurements = Prefs.getInt(MEASUREMENTS, 19);
        markWidth = Prefs.getInt(MARK_WIDTH, 3);
        precision = Prefs.getInt(PRECISION, 3);
        umeans = new float[20];
        systemRT = new ResultsTable();
    }
}

