/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;

public class TextReader
extends ImagePlus
implements PlugIn {
    private static String defaultDirectory;
    int words = 0;
    int chars = 0;
    int lines = 0;

    public void run(String string) {
        ImageProcessor imageProcessor;
        OpenDialog openDialog = new OpenDialog("Acquire Text Image...", string);
        String string2 = openDialog.getDirectory();
        String string3 = openDialog.getFileName();
        if (string3 == null) {
            return;
        }
        String string4 = string2 + string3;
        IJ.showStatus("Opening: " + string4);
        try {
            imageProcessor = this.openFile(string4);
        }
        catch (Exception exception) {
            IJ.showMessage("TextReader", exception.getMessage());
            return;
        }
        this.setProcessor(string3, imageProcessor);
        if (string.equals("")) {
            this.show();
        }
    }

    public ImageProcessor openFile(String string) throws IOException {
        this.lines = 0;
        this.chars = 0;
        this.words = 0;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        this.countLines(bufferedReader);
        ((Reader)bufferedReader).close();
        bufferedReader = new BufferedReader(new FileReader(string));
        int n = this.words / this.lines;
        float[] fArray = new float[n * this.lines];
        FloatProcessor floatProcessor = new FloatProcessor(n, this.lines, fArray, null);
        this.read(bufferedReader, n * this.lines, fArray);
        ((ImageProcessor)floatProcessor).resetMinAndMax();
        return floatProcessor;
    }

    public void countLines(Reader reader) throws IOException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        int n = 1;
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(33, 255);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.eolIsSignificant(true);
        block4: while (streamTokenizer.nextToken() != -1) {
            switch (streamTokenizer.ttype) {
                case 10: {
                    ++this.lines;
                    if (this.lines == 1) {
                        n = this.words;
                    }
                    if (this.lines % 20 != 0 || n <= 1 || this.lines > n) continue block4;
                    IJ.showProgress((double)this.lines / (double)n / 2.0);
                    break;
                }
                case -3: {
                    ++this.words;
                    break;
                }
            }
        }
    }

    public void read(Reader reader, int n, float[] fArray) throws IOException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(33, 255);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.parseNumbers();
        int n2 = 0;
        int n3 = n / 20;
        while (streamTokenizer.nextToken() != -1) {
            if (streamTokenizer.ttype != -2) continue;
            fArray[n2++] = (float)streamTokenizer.nval;
            if (n2 % n3 != 0) continue;
            IJ.showProgress(0.5 + (double)n2 / (double)n / 2.0);
        }
        IJ.showProgress(1.0);
    }
}

