/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.FileSaver;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;

public class StackWriter
implements PlugIn {
    private static String[] choices = new String[]{"Tiff", "Gif", "Jpeg", "Raw"};
    private static String fileType = "Tiff";
    private static int ndigits = 4;
    private static /* synthetic */ Class class$Lij$plugin$StackWriter;

    public void run(String string) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null || imagePlus != null && imagePlus.getStackSize() < 2) {
            IJ.error("This command requires a stack.");
            return;
        }
        String string2 = imagePlus.getTitle();
        int n = string2.lastIndexOf(".");
        if (n >= 0) {
            string2 = string2.substring(0, n);
        }
        GenericDialog genericDialog = new GenericDialog("Save Stack", IJ.getInstance());
        genericDialog.addChoice("Save Slices as:", choices, fileType);
        genericDialog.addStringField("Name:", string2, 12);
        genericDialog.addNumericField("Digits (1-8):", ndigits, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        fileType = genericDialog.getNextChoice();
        string2 = genericDialog.getNextString();
        ndigits = (int)genericDialog.getNextNumber();
        int n2 = 0;
        if (ndigits < 1) {
            ndigits = 1;
        }
        if (ndigits > 8) {
            ndigits = 8;
        }
        if (fileType.equals("Gif") && !FileSaver.okForGif(imagePlus)) {
            return;
        }
        if (fileType.equals("Jpeg") && !FileSaver.okForJpeg(imagePlus)) {
            return;
        }
        String string3 = "";
        if (fileType.equals("Tiff")) {
            string3 = ".tif";
        } else if (fileType.equals("Jpeg")) {
            string3 = ".jpg";
        } else if (fileType.equals("Gif")) {
            string3 = ".gif";
        } else if (fileType.equals("Raw")) {
            string3 = ".raw";
        }
        String string4 = this.getDigits(n2);
        SaveDialog saveDialog = new SaveDialog("StackWriter", string2 + string4 + string3, string3);
        String string5 = saveDialog.getFileName();
        if (string5 == null) {
            return;
        }
        String string6 = saveDialog.getDirectory();
        ImageStack imageStack = imagePlus.getStack();
        ImagePlus imagePlus2 = new ImagePlus();
        int n3 = imageStack.getSize();
        String string7 = string6 + string2;
        int n4 = 1;
        while (n4 <= n3) {
            IJ.showStatus("writing: " + n4 + "/" + n3);
            IJ.showProgress((double)n4 / (double)n3);
            imagePlus2.setProcessor(null, imageStack.getProcessor(n4));
            string4 = this.getDigits(n2++);
            if (fileType.equals("Tiff") ? !new FileSaver(imagePlus2).saveAsTiff(string7 + string4 + string3) : (fileType.equals("Gif") ? !new FileSaver(imagePlus2).saveAsGif(string7 + string4 + string3) : (fileType.equals("Jpeg") ? !new FileSaver(imagePlus2).saveAsJpeg(string7 + string4 + string3) : fileType.equals("Raw") && !new FileSaver(imagePlus2).saveAsRaw(string7 + string4 + string3)))) break;
            System.gc();
            ++n4;
        }
        IJ.showStatus("");
        IJ.showProgress(1.0);
        IJ.register(class$Lij$plugin$StackWriter != null ? class$Lij$plugin$StackWriter : (class$Lij$plugin$StackWriter = StackWriter.class$("ij.plugin.StackWriter")));
    }

    String getDigits(int n) {
        String string = "00000000" + n;
        return string.substring(string.length() - ndigits, string.length());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

