/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class StackEditor
implements PlugIn {
    String arg;
    ImagePlus imp;
    int nSlices;
    int width;
    int height;

    public void run(String string) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        this.nSlices = this.imp.getStackSize();
        this.width = this.imp.getWidth();
        this.height = this.imp.getHeight();
        if (string.equals("tostack")) {
            this.convertImagesToStack();
            return;
        }
        if (this.nSlices < 2) {
            IJ.error("Stack requred");
            return;
        }
        if (string.equals("add")) {
            this.addSlice();
        } else if (string.equals("delete")) {
            this.deleteSlice();
        } else if (string.equals("toimages")) {
            this.convertStackToImages(this.imp);
        }
    }

    void addSlice() {
        if (!this.imp.lock()) {
            return;
        }
        ImageStack imageStack = this.imp.getStack();
        ImageProcessor imageProcessor = this.imp.getProcessor();
        int n = this.imp.getCurrentSlice();
        if (IJ.altKeyDown()) {
            --n;
        }
        imageStack.addSlice(null, imageProcessor.createProcessor(this.width, this.height), n);
        this.imp.setStack(null, imageStack);
        this.imp.setSlice(n + 1);
        this.imp.unlock();
    }

    void deleteSlice() {
        if (!this.imp.lock()) {
            return;
        }
        ImageStack imageStack = this.imp.getStack();
        int n = this.imp.getCurrentSlice();
        imageStack.deleteSlice(n);
        if (imageStack.getSize() == 1) {
            this.imp.setProcessor(null, imageStack.getProcessor(1));
            new ImageWindow(this.imp);
        } else {
            this.imp.setStack(null, imageStack);
            if (n-- < 1) {
                n = 1;
            }
            this.imp.setSlice(n);
        }
        this.imp.unlock();
    }

    public void convertImagesToStack() {
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            IJ.error("No images are open.");
            return;
        }
        if (nArray.length < 2) {
            IJ.error("There must be at least two open images.");
            return;
        }
        ImagePlus[] imagePlusArray = new ImagePlus[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            imagePlusArray[n] = WindowManager.getImage(nArray[n]);
            if (imagePlusArray[n].getStackSize() > 1) {
                IJ.error("None of the open images can be a stack.");
                return;
            }
            ++n;
        }
        n = 0;
        while (n < nArray.length - 1) {
            if (imagePlusArray[n].getType() != imagePlusArray[n + 1].getType()) {
                IJ.error("All open images must be the same type.");
                return;
            }
            if (imagePlusArray[n].getWidth() != imagePlusArray[n + 1].getWidth() || imagePlusArray[n].getHeight() != imagePlusArray[n + 1].getHeight()) {
                IJ.error("All open images must be the same size.");
                return;
            }
            ++n;
        }
        n = imagePlusArray[0].getWidth();
        int n2 = imagePlusArray[0].getHeight();
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        ImageStack imageStack = new ImageStack(n, n2);
        int n3 = 0;
        while (n3 < nArray.length) {
            ImageProcessor imageProcessor = imagePlusArray[n3].getProcessor();
            if (imageProcessor.getMin() < d) {
                d = imageProcessor.getMin();
            }
            if (imageProcessor.getMax() > d2) {
                d2 = imageProcessor.getMax();
            }
            imageStack.addSlice(null, imageProcessor);
            imagePlusArray[n3].changes = false;
            imagePlusArray[n3].getWindow().close();
            ++n3;
        }
        ImagePlus imagePlus = new ImagePlus("Stack", imageStack);
        if (imagePlus.getType() == 1 || imagePlus.getType() == 2) {
            imagePlus.getProcessor().setMinAndMax(d, d2);
        }
        imagePlus.show();
    }

    public void convertStackToImages(ImagePlus imagePlus) {
        int n;
        if (!imagePlus.lock()) {
            return;
        }
        ImageStack imageStack = imagePlus.getStack();
        int n2 = imageStack.getSize();
        if (n2 > 30 && (n = (int)(IJ.showMessageWithCancel("Convert to Images?", "Are you sure you want to convert this\nstack to " + n2 + " separate windows?") ? 1 : 0)) == 0) {
            imagePlus.unlock();
            return;
        }
        n = 1;
        while (n <= n2) {
            String string = imageStack.getSliceLabel(n);
            String string2 = string != null && !string.equals("") ? string : this.getDigits(n);
            new ImagePlus(string2, imageStack.getProcessor(n)).show();
            ++n;
        }
        imagePlus.changes = false;
        ImageWindow imageWindow = imagePlus.getWindow();
        if (imageWindow != null) {
            imageWindow.close();
        }
        imagePlus.unlock();
    }

    String getDigits(int n) {
        String string = "00000000" + n;
        return string.substring(string.length() - 4, string.length());
    }
}

