/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.OvalRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class RoiReader
implements PlugIn {
    final int polygon;
    final int rect;
    final int oval;
    final int line;
    final int freeLine;
    final int segLine;
    final int noRoi;
    final int freehand;
    final int traced;
    byte[] data;

    public void run(String string) {
        OpenDialog openDialog = new OpenDialog("Open ROI...", string);
        String string2 = openDialog.getDirectory();
        String string3 = openDialog.getFileName();
        if (string3 == null) {
            return;
        }
        try {
            this.openRoi(string2, string3);
        }
        catch (IOException iOException) {
            String string4 = iOException.getMessage();
            if (string4 == null || string4.equals("")) {
                string4 = "" + iOException;
            }
            IJ.showMessage("ROI Reader", string4);
        }
    }

    public void openRoi(String string, String string2) throws IOException {
        Object object;
        String string3 = string + string2;
        File file = new File(string3);
        int n = (int)file.length();
        if (n > 5000) {
            throw new IOException("This is not an ImageJ ROI");
        }
        FileInputStream fileInputStream = new FileInputStream(string3);
        this.data = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            n2 += fileInputStream.read(this.data, n2, n - n2);
        }
        if (this.getByte(0) != 73 || this.getByte(1) != 111) {
            throw new IOException("This is not an ImageJ ROI");
        }
        int n3 = this.getByte(6);
        int n4 = this.getShort(8);
        int n5 = this.getShort(10);
        int n6 = this.getShort(12);
        int n7 = this.getShort(14);
        int n8 = n7 - n5;
        int n9 = n6 - n4;
        int n10 = this.getShort(16);
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null || imagePlus.getWidth() < n5 + n8 || imagePlus.getHeight() < n4 + n9) {
            object = new ByteProcessor(n5 + n8 + 10, n4 + n9 + 10);
            ((ImageProcessor)object).setColor(Color.white);
            ((ImageProcessor)object).fill();
            imagePlus = new ImagePlus(string2, (ImageProcessor)object);
            imagePlus.show();
        }
        object = null;
        switch (n3) {
            case 1: {
                imagePlus.setRoi(n5, n4, n8, n9);
                break;
            }
            case 2: {
                object = new OvalRoi(n5, n4, n8, n9, imagePlus);
                imagePlus.setRoi((Roi)object);
                break;
            }
            case 3: {
                int n11 = (int)this.getFloat(18);
                int n12 = (int)this.getFloat(22);
                int n13 = (int)this.getFloat(26);
                int n14 = (int)this.getFloat(30);
                break;
            }
            case 0: 
            case 7: 
            case 8: {
                if (n10 == 0) break;
                int[] nArray = new int[n10];
                int[] nArray2 = new int[n10];
                int n15 = 64;
                int n16 = n15 + 2 * n10;
                int n17 = 0;
                while (n17 < n10) {
                    int n18;
                    int n19 = this.getShort(n15 + n17 * 2);
                    if (n19 < 0) {
                        n19 = 0;
                    }
                    if ((n18 = this.getShort(n16 + n17 * 2)) < 0) {
                        n18 = 0;
                    }
                    nArray[n17] = n5 + n19;
                    nArray2[n17] = n4 + n18;
                    ++n17;
                }
                n17 = n3 == 0 ? 2 : (n3 == 7 ? 3 : 4);
                object = new PolygonRoi(nArray, nArray2, n10, imagePlus, n17);
                imagePlus.setRoi((Roi)object);
                break;
            }
        }
    }

    int getByte(int n) {
        return this.data[n] & 0xFF;
    }

    int getShort(int n) {
        int n2 = this.data[n] & 0xFF;
        int n3 = this.data[n + 1] & 0xFF;
        return (short)((n2 << 8) + n3);
    }

    int getInt(int n) {
        int n2 = this.data[n] & 0xFF;
        int n3 = this.data[n + 1] & 0xFF;
        int n4 = this.data[n + 2] & 0xFF;
        int n5 = this.data[n + 3] & 0xFF;
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
    }

    float getFloat(int n) {
        return Float.intBitsToFloat(this.getInt(n));
    }

    public RoiReader() {
        this.polygon = 0;
        this.rect = 1;
        this.oval = 2;
        this.line = 3;
        this.freeLine = 4;
        this.segLine = 5;
        this.noRoi = 6;
        this.freehand = 7;
        this.traced = 8;
    }
}

