/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Prefs;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.plugin.PlugIn;
import java.util.StringTokenizer;

public class RawReader
implements PlugIn {
    public void run(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t");
        int n = stringTokenizer.countTokens();
        if (n < 6) {
            IJ.write("RawReader expects at least 6 arguments: " + string);
            return;
        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.fileFormat = FileInfo.RAW;
        fileInfo.url = Prefs.getImagesURL();
        fileInfo.fileName = stringTokenizer.nextToken();
        fileInfo.width = this.getNextArg(stringTokenizer);
        fileInfo.height = this.getNextArg(stringTokenizer);
        fileInfo.nImages = this.getNextArg(stringTokenizer);
        fileInfo.fileType = this.getNextArg(stringTokenizer) == 8 ? 0 : 2;
        fileInfo.offset = this.getNextArg(stringTokenizer);
        int n2 = 7;
        while (n2 <= n) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("white")) {
                fileInfo.whiteIsZero = true;
            } else if (string2.startsWith("black")) {
                fileInfo.whiteIsZero = false;
            } else if (string2.startsWith("little")) {
                fileInfo.intelByteOrder = true;
            } else if (string2.startsWith("big")) {
                fileInfo.intelByteOrder = false;
            }
            ++n2;
        }
        if (IJ.debugMode) {
            IJ.write("RawReader: " + fileInfo);
        }
        IJ.showStatus(fileInfo.url + fileInfo.fileName);
        new FileOpener(fileInfo).open();
    }

    int getNextArg(StringTokenizer stringTokenizer) {
        int n = 0;
        try {
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            IJ.write("" + numberFormatException);
        }
        return n;
    }
}

