/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.StackConverter;
import java.awt.Rectangle;

public class RGBStackConverter
implements PlugIn {
    public void run(String string) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.noImage();
            return;
        }
        int n = imagePlus.getStackSize();
        if (n < 2 || n > 3) {
            IJ.error("2 or 3 slice stack required");
            return;
        }
        int n2 = imagePlus.getType();
        if (n2 != 0 && n2 != 1) {
            IJ.error("8-bit or 16-bit grayscale stack required");
            return;
        }
        if (!imagePlus.lock()) {
            return;
        }
        Undo.reset();
        if (n2 == 1) {
            this.sixteenBitsToRGB(imagePlus);
        } else {
            ImagePlus imagePlus2 = imagePlus.createImagePlus();
            imagePlus2.setStack(imagePlus.getTitle() + " (RGB)", imagePlus.getStack());
            ImageConverter imageConverter = new ImageConverter(imagePlus2);
            imageConverter.convertRGBStackToRGB();
            new ImageWindow(imagePlus2);
        }
        imagePlus.unlock();
    }

    void sixteenBitsToRGB(ImagePlus imagePlus) {
        ImageProcessor imageProcessor;
        Rectangle rectangle;
        Roi roi = imagePlus.getRoi();
        if (roi != null) {
            rectangle = roi.getBoundingRect();
            int n = rectangle.width;
            int n2 = rectangle.height;
        } else {
            rectangle = new Rectangle(0, 0, imagePlus.getWidth(), imagePlus.getHeight());
        }
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = new ImageStack(rectangle.width, rectangle.height);
        int n = 1;
        while (n <= imageStack.getSize()) {
            ImageProcessor imageProcessor2 = imageStack.getProcessor(n);
            imageProcessor2.setRoi(rectangle);
            imageProcessor = imageProcessor2.crop();
            imageStack2.addSlice(null, imageProcessor);
            ++n;
        }
        ImagePlus imagePlus2 = imagePlus.createImagePlus();
        imagePlus2.setStack(imagePlus.getTitle() + " (RGB)", imageStack2);
        imageProcessor = imagePlus2.getProcessor();
        StackConverter stackConverter = new StackConverter(imagePlus2);
        stackConverter.convertToGray8();
        ImageConverter imageConverter = new ImageConverter(imagePlus2);
        imageConverter.convertRGBStackToRGB();
        imagePlus2.show();
    }
}

