/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.HistogramWindow;
import ij.gui.ImageCanvas;
import ij.gui.Line;
import ij.io.JpegEncoder;
import ij.plugin.PlugIn;
import ij.plugin.filter.Analyzer;
import ij.process.FloatBlitter;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;

public class Options
implements PlugIn {
    private static /* synthetic */ Class class$Lij$plugin$Options;

    public void run(String string) {
        IJ.register(class$Lij$plugin$Options != null ? class$Lij$plugin$Options : (class$Lij$plugin$Options = Options.class$("ij.plugin.Options")));
        if (string.equals("misc")) {
            Float f;
            GenericDialog genericDialog = new GenericDialog("Miscellaneous Options", IJ.getInstance());
            genericDialog.addNumericField("Real Histogram Bins:", HistogramWindow.nBins, 0);
            genericDialog.addStringField("Divide by Zero Value:", "" + FloatBlitter.divideByZeroValue, 10);
            genericDialog.addCheckbox("Use Pointer Cursor", ImageCanvas.usePointer);
            genericDialog.addCheckbox("Scale When Converting", ImageConverter.getDoScaling());
            genericDialog.addCheckbox("Debug Mode", IJ.debugMode);
            genericDialog.showDialog();
            if (genericDialog.wasCanceled()) {
                return;
            }
            int n = (int)genericDialog.getNextNumber();
            if (n >= 2 && n <= 1000) {
                HistogramWindow.nBins = n;
            }
            String string2 = genericDialog.getNextString();
            try {
                f = new Float(string2);
            }
            catch (NumberFormatException numberFormatException) {
                f = null;
            }
            if (f != null) {
                FloatBlitter.divideByZeroValue = f.floatValue();
            }
            ImageCanvas.usePointer = genericDialog.getNextBoolean();
            ImageConverter.setDoScaling(genericDialog.getNextBoolean());
            IJ.debugMode = genericDialog.getNextBoolean();
            return;
        }
        if (string.equals("width")) {
            int n = (int)IJ.getNumber("Line Width:", Line.getWidth());
            if (n == Integer.MIN_VALUE) {
                return;
            }
            Line.setWidth(n);
            ImagePlus imagePlus = WindowManager.getCurrentImage();
            if (imagePlus != null && imagePlus.isProcessor()) {
                ImageProcessor imageProcessor = imagePlus.getProcessor();
                imageProcessor.setLineWidth(Line.getWidth());
            }
            return;
        }
        if (string.equals("quality")) {
            int n = (int)IJ.getNumber("JPEG quality (0-100):", JpegEncoder.getQuality());
            if (n == Integer.MIN_VALUE) {
                return;
            }
            JpegEncoder.setQuality(n);
            return;
        }
        if (string.equals("calc")) {
            Float f;
            String string3 = IJ.getString("Real Divide by Zero Value:", "" + FloatBlitter.divideByZeroValue);
            if (string3.equals("")) {
                return;
            }
            try {
                f = new Float(string3);
            }
            catch (NumberFormatException numberFormatException) {
                f = null;
            }
            if (f != null) {
                FloatBlitter.divideByZeroValue = f.floatValue();
            }
            return;
        }
        if (string.equals("cross")) {
            int n = (int)IJ.getNumber("Mark Width:", Analyzer.markWidth);
            if (n == Integer.MIN_VALUE) {
                return;
            }
            Analyzer.markWidth = n;
            return;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

