/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Color;

public class MontageMaker
implements PlugIn {
    private static int columns;
    private static int rows;
    private static int first;
    private static int last;
    private static int inc;
    private static double scale;
    private static boolean label;
    private static boolean borders;
    private static int saveID;
    private static /* synthetic */ Class class$Lij$plugin$MontageMaker;

    public void run(String string) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null || imagePlus.getStackSize() == 1) {
            IJ.error("Stack required");
            return;
        }
        this.makeMontage(imagePlus);
        saveID = imagePlus.getID();
        IJ.register(class$Lij$plugin$MontageMaker != null ? class$Lij$plugin$MontageMaker : (class$Lij$plugin$MontageMaker = MontageMaker.class$("ij.plugin.MontageMaker")));
    }

    public void makeMontage(ImagePlus imagePlus) {
        int n = imagePlus.getStackSize();
        if (columns == 0 || imagePlus.getID() != saveID) {
            rows = columns = (int)Math.sqrt(n);
            int n2 = n - columns * rows;
            if (n2 > 0) {
                columns += (int)Math.ceil((double)n2 / (double)rows);
            }
            scale = 1.0;
            if (imagePlus.getWidth() * columns > 800) {
                scale = 0.5;
            }
            if (imagePlus.getWidth() * columns > 1600) {
                scale = 0.25;
            }
            inc = 1;
            first = 1;
            last = n;
        }
        GenericDialog genericDialog = new GenericDialog("Make Montage", IJ.getInstance());
        genericDialog.addNumericField("Columns:", columns, 0);
        genericDialog.addNumericField("Rows:", rows, 0);
        genericDialog.addNumericField("Scale Factor:", scale, 2);
        genericDialog.addNumericField("First Slice:", first, 0);
        genericDialog.addNumericField("Last Slice:", last, 0);
        genericDialog.addNumericField("Increment:", inc, 0);
        genericDialog.addCheckbox("Label Slices", label);
        genericDialog.addCheckbox("Borders", borders);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        columns = (int)genericDialog.getNextNumber();
        rows = (int)genericDialog.getNextNumber();
        scale = genericDialog.getNextNumber();
        first = (int)genericDialog.getNextNumber();
        last = (int)genericDialog.getNextNumber();
        inc = (int)genericDialog.getNextNumber();
        if (first < 1) {
            first = 1;
        }
        if (last > n) {
            last = n;
        }
        if (inc < 1) {
            inc = 1;
        }
        if (genericDialog.invalidNumber()) {
            IJ.error("Invalid number");
            return;
        }
        label = genericDialog.getNextBoolean();
        borders = genericDialog.getNextBoolean();
        this.makeMontage(imagePlus, columns, rows, scale, first, last, inc, label, borders);
    }

    public void makeMontage(ImagePlus imagePlus, int n, int n2, double d, int n3, int n4, int n5, boolean bl, boolean bl2) {
        boolean bl3;
        int n6 = imagePlus.getWidth();
        int n7 = imagePlus.getHeight();
        int n8 = imagePlus.getStackSize();
        int n9 = (int)((double)n6 * d);
        int n10 = (int)((double)n7 * d);
        int n11 = n9 * n;
        int n12 = n10 * n2;
        ImageProcessor imageProcessor = imagePlus.getProcessor().createProcessor(n11, n12);
        ImageStatistics imageStatistics = imagePlus.getStatistics();
        boolean bl4 = bl3 = imageStatistics.mode < 128;
        if (imagePlus.isInvertedLut()) {
            boolean bl5 = bl3 = !bl3;
        }
        if (bl3) {
            imageProcessor.setColor(Color.black);
            imageProcessor.fill();
            imageProcessor.setColor(Color.white);
        } else {
            imageProcessor.setColor(Color.white);
            imageProcessor.fill();
            imageProcessor.setColor(Color.black);
        }
        ImageStack imageStack = imagePlus.getStack();
        int n13 = 0;
        int n14 = 0;
        int n15 = n3;
        while (n15 <= n4) {
            ImageProcessor imageProcessor2 = imageStack.getProcessor(n15).resize(n9, n10);
            imageProcessor.insert(imageProcessor2, n13, n14);
            if (bl2) {
                this.drawBorder(imageProcessor, n13, n14, n9, n10);
            }
            if (bl) {
                this.drawLabel(imageProcessor, n15, n13, n14, n9, n10);
            }
            if ((n13 += n9) >= n11) {
                n13 = 0;
                if ((n14 += n10) >= n12) break;
            }
            IJ.showProgress((double)(n15 - n3) / (double)(n4 - n3));
            n15 += n5;
        }
        if (bl2) {
            this.drawBorder(imageProcessor, 0, 0, n11 - 1, n12 - 1);
        }
        IJ.showProgress(1.0);
        new ImagePlus("Montage", imageProcessor).show();
    }

    void drawBorder(ImageProcessor imageProcessor, int n, int n2, int n3, int n4) {
        imageProcessor.moveTo(n, n2);
        imageProcessor.lineTo(n + n3, n2);
        imageProcessor.lineTo(n + n3, n2 + n4);
        imageProcessor.lineTo(n, n2 + n4);
        imageProcessor.lineTo(n, n2);
    }

    void drawLabel(ImageProcessor imageProcessor, int n, int n2, int n3, int n4, int n5) {
        String string = "" + n;
        int n6 = imageProcessor.getStringWidth(string);
        imageProcessor.moveTo(n2 += n4 / 2 - n6 / 2, n3 += n5);
        imageProcessor.drawString(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        label = false;
        borders = false;
    }
}

