/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class LutLoader
extends ImagePlus
implements PlugIn {
    private static String defaultDirectory = null;

    public void run(String string) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.reds = new byte[256];
        fileInfo.greens = new byte[256];
        fileInfo.blues = new byte[256];
        fileInfo.lutSize = 256;
        int n = 0;
        if (string.equals("invert")) {
            this.invertLut();
            return;
        }
        if (string.equals("fire")) {
            n = this.fire(fileInfo.reds, fileInfo.greens, fileInfo.blues);
        } else if (string.equals("grays")) {
            n = this.grays(fileInfo.reds, fileInfo.greens, fileInfo.blues);
        } else if (string.equals("ice")) {
            n = this.ice(fileInfo.reds, fileInfo.greens, fileInfo.blues);
        } else if (string.equals("spectrum")) {
            n = this.spectrum(fileInfo.reds, fileInfo.greens, fileInfo.blues);
        } else if (string.equals("3-3-2 RGB")) {
            n = this.rgb332(fileInfo.reds, fileInfo.greens, fileInfo.blues);
        } else if (string.equals("red")) {
            n = this.oneColor(0, fileInfo.reds, fileInfo.greens, fileInfo.blues);
        } else if (string.equals("green")) {
            n = this.oneColor(1, fileInfo.reds, fileInfo.greens, fileInfo.blues);
        } else if (string.equals("blue")) {
            n = this.oneColor(2, fileInfo.reds, fileInfo.greens, fileInfo.blues);
        } else if (string.equals("redgreen")) {
            n = this.redGreen(fileInfo.reds, fileInfo.greens, fileInfo.blues);
        }
        if (n > 0) {
            if (n < 256) {
                this.interpolate(fileInfo.reds, fileInfo.greens, fileInfo.blues, n);
            }
            fileInfo.fileName = string;
            this.showLut(fileInfo, true);
            return;
        }
        OpenDialog openDialog = new OpenDialog("Open LUT...", string);
        fileInfo.directory = openDialog.getDirectory();
        fileInfo.fileName = openDialog.getFileName();
        if (fileInfo.fileName == null) {
            return;
        }
        IJ.showStatus("Opening: " + fileInfo.directory + fileInfo.fileName);
        try {
            int n2 = this.readLut(fileInfo, false);
            if (n2 == 0) {
                this.readLut(fileInfo, true);
            }
        }
        catch (IOException iOException) {
            IJ.error(iOException.getMessage());
            return;
        }
        this.showLut(fileInfo, string.equals(""));
        IJ.showStatus("");
    }

    void showLut(FileInfo fileInfo, boolean bl) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null) {
            if (imagePlus.getType() == 4) {
                IJ.error("Color tables cannot be assiged to RGB Images.");
            } else {
                ImageProcessor imageProcessor = imagePlus.getProcessor();
                IndexColorModel indexColorModel = new IndexColorModel(8, 256, fileInfo.reds, fileInfo.greens, fileInfo.blues);
                imageProcessor.setColorModel(indexColorModel);
                if (imagePlus.getStackSize() > 1) {
                    imagePlus.getStack().setColorModel(indexColorModel);
                }
                imagePlus.updateAndDraw();
            }
        } else {
            this.createImage(fileInfo, bl);
        }
    }

    void invertLut() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.noImage();
            return;
        }
        if (imagePlus.getType() == 4) {
            IJ.error("RGB images do not use LUTs");
            return;
        }
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        imageProcessor.invertLut();
        if (imagePlus.getStackSize() > 1) {
            imagePlus.getStack().setColorModel(imageProcessor.getColorModel());
        }
        imagePlus.updateAndDraw();
        if (imagePlus.getRoi() != null) {
            imagePlus.draw();
        }
    }

    int fire(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int[] nArray = new int[]{0, 0, 1, 25, 49, 73, 98, 122, 146, 162, 173, 184, 195, 207, 217, 229, 240, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
        int[] nArray2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 35, 57, 79, 101, 117, 133, 147, 161, 175, 190, 205, 219, 234, 248, 255, 255, 255, 255};
        int[] nArray3 = new int[]{31, 61, 96, 130, 165, 192, 220, 227, 210, 181, 151, 122, 93, 64, 35, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 98, 160, 223, 255};
        int n = 0;
        while (n < nArray.length) {
            byArray[n] = (byte)nArray[n];
            byArray2[n] = (byte)nArray2[n];
            byArray3[n] = (byte)nArray3[n];
            ++n;
        }
        return nArray.length;
    }

    int grays(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n = 0;
        while (n < 256) {
            byArray[n] = (byte)n;
            byArray2[n] = (byte)n;
            byArray3[n] = (byte)n;
            ++n;
        }
        return 256;
    }

    int oneColor(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n2 = 0;
        while (n2 < 256) {
            if (n == 0) {
                byArray[n2] = (byte)n2;
            } else if (n == 1) {
                byArray2[n2] = (byte)n2;
            } else {
                byArray3[n2] = (byte)n2;
            }
            ++n2;
        }
        return 256;
    }

    int ice(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 19, 29, 50, 48, 79, 112, 134, 158, 186, 201, 217, 229, 242, 250, 250, 250, 250, 251, 250, 250, 250, 250, 251, 251, 243, 230};
        int[] nArray2 = new int[]{156, 165, 176, 184, 190, 196, 193, 184, 171, 162, 146, 125, 107, 93, 81, 87, 92, 97, 95, 93, 93, 90, 85, 69, 64, 54, 47, 35, 19, 0, 4, 0};
        int[] nArray3 = new int[]{140, 147, 158, 166, 170, 176, 209, 220, 234, 225, 236, 246, 250, 251, 250, 250, 245, 230, 230, 222, 202, 180, 163, 142, 123, 114, 106, 94, 84, 64, 26, 27};
        int n = 0;
        while (n < nArray.length) {
            byArray[n] = (byte)nArray[n];
            byArray2[n] = (byte)nArray2[n];
            byArray3[n] = (byte)nArray3[n];
            ++n;
        }
        return nArray.length;
    }

    int spectrum(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n = 0;
        while (n < 256) {
            Color color = Color.getHSBColor((float)n / 255.0f, 1.0f, 1.0f);
            byArray[n] = (byte)color.getRed();
            byArray2[n] = (byte)color.getGreen();
            byArray3[n] = (byte)color.getBlue();
            ++n;
        }
        return 256;
    }

    int rgb332(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n = 0;
        while (n < 256) {
            byArray[n] = (byte)(n & 0xE0);
            byArray2[n] = (byte)(n << 3 & 0xE0);
            byArray3[n] = (byte)(n << 6 & 0xC0);
            ++n;
        }
        return 256;
    }

    int redGreen(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n = 0;
        while (n < 128) {
            byArray[n] = (byte)(n * 2);
            byArray2[n] = 0;
            byArray3[n] = 0;
            ++n;
        }
        n = 128;
        while (n < 256) {
            byArray[n] = 0;
            byArray2[n] = (byte)(n * 2);
            byArray3[n] = 0;
            ++n;
        }
        return 256;
    }

    void interpolate(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        byte[] byArray4 = new byte[n];
        byte[] byArray5 = new byte[n];
        byte[] byArray6 = new byte[n];
        System.arraycopy(byArray, 0, byArray4, 0, n);
        System.arraycopy(byArray2, 0, byArray5, 0, n);
        System.arraycopy(byArray3, 0, byArray6, 0, n);
        double d = (double)n / 256.0;
        int n2 = 0;
        while (n2 < 256) {
            int n3 = (int)((double)n2 * d);
            int n4 = n3 + 1;
            if (n4 == n) {
                n4 = n - 1;
            }
            double d2 = (double)n2 * d - (double)n3;
            byArray[n2] = (byte)((1.0 - d2) * (double)(byArray4[n3] & 0xFF) + d2 * (double)(byArray4[n4] & 0xFF));
            byArray2[n2] = (byte)((1.0 - d2) * (double)(byArray5[n3] & 0xFF) + d2 * (double)(byArray5[n4] & 0xFF));
            byArray3[n2] = (byte)((1.0 - d2) * (double)(byArray6[n3] & 0xFF) + d2 * (double)(byArray6[n4] & 0xFF));
            ++n2;
        }
    }

    int readLut(FileInfo fileInfo, boolean bl) throws IOException {
        InputStream inputStream = fileInfo.url == null || fileInfo.url.equals("") ? new FileInputStream(fileInfo.directory + fileInfo.fileName) : new URL(fileInfo.url + fileInfo.fileName).openStream();
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = 256;
        if (!bl) {
            int n2 = dataInputStream.readInt();
            if (n2 != 1229147980) {
                return 0;
            }
            short s = dataInputStream.readShort();
            n = dataInputStream.readShort();
            short s2 = dataInputStream.readShort();
            short s3 = dataInputStream.readShort();
            long l = dataInputStream.readLong();
            long l2 = dataInputStream.readLong();
            int n3 = dataInputStream.readInt();
        }
        dataInputStream.read(fileInfo.reds, 0, n);
        dataInputStream.read(fileInfo.greens, 0, n);
        dataInputStream.read(fileInfo.blues, 0, n);
        if (n < 256) {
            this.interpolate(fileInfo.reds, fileInfo.greens, fileInfo.blues, n);
        }
        dataInputStream.close();
        return 256;
    }

    void createImage(FileInfo fileInfo, boolean bl) {
        int n = 256;
        int n2 = 32;
        IndexColorModel indexColorModel = new IndexColorModel(8, 256, fileInfo.reds, fileInfo.greens, fileInfo.blues);
        byte[] byArray = new byte[n * n2];
        ByteProcessor byteProcessor = new ByteProcessor(n, n2, byArray, indexColorModel);
        int[] nArray = new int[n];
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = n3;
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            byteProcessor.putRow(0, n3, nArray, n);
            ++n3;
        }
        this.setProcessor(fileInfo.fileName, byteProcessor);
        if (bl) {
            this.show();
        }
    }
}

