/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Menus;
import ij.gui.GenericDialog;
import ij.io.PluginClassLoader;
import ij.plugin.PlugIn;
import ij.util.StringSorter;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Vector;

public class Installer
implements PlugIn {
    private static String[] menus = new String[]{"Shortcuts", "Plugins", "Import", "Save As", "Filters", "Tools", "Utilities"};
    private static final String TITLE = "Installer";
    private static String command = "";
    private static String shortcut = "";
    private static String defaultPlugin = "";
    private static String menuStr = menus[0];
    private static /* synthetic */ Class class$Lij$plugin$Installer;

    public void run(String string) {
        this.installPlugin();
    }

    void installPlugin() {
        String[] stringArray = this.getPlugins();
        if (stringArray == null || stringArray.length == 0) {
            IJ.error("No plugins found");
            return;
        }
        GenericDialog genericDialog = new GenericDialog("Install Plugin", IJ.getInstance());
        genericDialog.addChoice("Plugin:", stringArray, defaultPlugin);
        genericDialog.addChoice("Menu:", menus, menuStr);
        genericDialog.addStringField("Command:", command, 16);
        genericDialog.addStringField("Shortcut:", shortcut, 3);
        genericDialog.addStringField("Argument:", "", 12);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        String string = genericDialog.getNextChoice();
        menuStr = genericDialog.getNextChoice();
        command = genericDialog.getNextString();
        shortcut = genericDialog.getNextString();
        String string2 = genericDialog.getNextString();
        IJ.register(class$Lij$plugin$Installer != null ? class$Lij$plugin$Installer : (class$Lij$plugin$Installer = Installer.class$("ij.plugin.Installer")));
        defaultPlugin = string;
        if (command.equals("")) {
            IJ.showMessage(TITLE, "Command required");
            return;
        }
        if (shortcut.length() > 1) {
            shortcut = shortcut.replace('f', 'F');
        }
        int n = 32;
        if (menuStr.equals(menus[0])) {
            n = 104;
        } else if (menuStr.equals(menus[1])) {
            n = 112;
        } else if (menuStr.equals(menus[2])) {
            n = 105;
        } else if (menuStr.equals(menus[3])) {
            n = 115;
        } else if (menuStr.equals(menus[4])) {
            n = 102;
        } else if (menuStr.equals(menus[5])) {
            n = 116;
        } else if (menuStr.equals(menus[6])) {
            n = 117;
        }
        if (!string2.equals("")) {
            string = string + "(\"" + string2 + "\")";
        }
        int n2 = Menus.installPlugin(string, (char)n, command, shortcut, IJ.getInstance());
        switch (n2) {
            case -1: {
                IJ.showMessage(TITLE, "The command \"" + command + "\" \nis already being used.");
                return;
            }
            case -2: {
                IJ.showMessage(TITLE, "The shortcut must be a single character or \"F1\"-\"F12\".");
                return;
            }
            case -3: {
                IJ.showMessage("The \"" + shortcut + "\" shortcut is already being used.");
                return;
            }
        }
        command = "";
        shortcut = "";
        if (!string.endsWith(")")) {
            this.installAbout(string);
        }
    }

    void installAbout(String string) {
        boolean bl = false;
        PluginClassLoader pluginClassLoader = new PluginClassLoader(Menus.getPlugInsPath());
        try {
            Class<?> clazz = pluginClassLoader.loadClass(string);
            Method method = clazz.getDeclaredMethod("showAbout", new Class[0]);
            if (method != null) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            Menus.installPlugin(string + "(\"about\")", 'a', string + "...", "", IJ.getInstance());
        }
    }

    String[] getPlugins() {
        String string = Menus.getPlugInsPath();
        if (string == null) {
            return null;
        }
        File file = new File(string);
        Object[] objectArray = file.list();
        if (objectArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < objectArray.length) {
            String string2 = objectArray[n];
            boolean bl = string2.endsWith(".class");
            if (string2.indexOf(95) >= 0 && bl && string2.indexOf(36) < 0) {
                string2 = string2.substring(0, string2.length() - 6);
                vector.addElement(string2);
            } else if (!bl) {
                this.getSubdirectoryPlugins(string, string2, vector);
            }
            ++n;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        StringSorter.sort((String[])objectArray);
        return objectArray;
    }

    void getSubdirectoryPlugins(String string, String string2, Vector vector) {
        if (string2.endsWith(".java")) {
            return;
        }
        File file = new File(string, string2);
        if (!file.isDirectory()) {
            return;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        string2 = string2 + "/";
        int n = 0;
        while (n < stringArray.length) {
            String string3 = stringArray[n];
            if (string3.indexOf(95) >= 0 && string3.endsWith(".class") && string3.indexOf(36) < 0) {
                string3 = string3.substring(0, string3.length() - 6);
                vector.addElement(string3);
            }
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

