/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.YesNoCancelDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import java.awt.Frame;

public class ImageCalculator
implements PlugIn {
    private static int operator;
    private static String title1;
    private static String title2;
    private static boolean createWindow;
    private static /* synthetic */ Class class$Lij$plugin$ImageCalculator;

    public void run(String string) {
        Object object;
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            IJ.error("No windows are open.");
            return;
        }
        IJ.register(class$Lij$plugin$ImageCalculator != null ? class$Lij$plugin$ImageCalculator : (class$Lij$plugin$ImageCalculator = ImageCalculator.class$("ij.plugin.ImageCalculator")));
        String[] stringArray = new String[nArray.length];
        String[] stringArray2 = new String[]{"Add", "Subtract", "Multiply", "Divide", "AND", "OR", "XOR", "Min", "Max", "Average", "Difference", "Copy"};
        int n = 0;
        while (n < nArray.length) {
            object = WindowManager.getImage(nArray[n]);
            stringArray[n] = object != null ? ((ImagePlus)object).getTitle() : "";
            ++n;
        }
        GenericDialog genericDialog = new GenericDialog("Image Calculator", IJ.getInstance());
        object = title1.equals("") ? stringArray[0] : title1;
        genericDialog.addChoice("Image1:", stringArray, (String)object);
        genericDialog.addChoice("Operation:", stringArray2, stringArray2[operator]);
        object = title2.equals("") ? stringArray[0] : title2;
        genericDialog.addChoice("Image2:", stringArray, (String)object);
        genericDialog.addCheckbox("Create New Window", createWindow);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        int n2 = genericDialog.getNextChoiceIndex();
        title1 = stringArray[n2];
        operator = genericDialog.getNextChoiceIndex();
        int n3 = genericDialog.getNextChoiceIndex();
        createWindow = genericDialog.getNextBoolean();
        title2 = stringArray[n3];
        ImagePlus imagePlus = WindowManager.getImage(nArray[n2]);
        ImagePlus imagePlus2 = WindowManager.getImage(nArray[n3]);
        int n4 = imagePlus.getStackSize();
        int n5 = imagePlus2.getStackSize();
        if (n4 > 1 && n5 > 1 && n4 != n5) {
            IJ.showMessage("Image Calculator", "Both stacks must have the same number of sizes.");
            return;
        }
        if (n4 > 1 && (n5 == 1 || n4 == n5)) {
            YesNoCancelDialog yesNoCancelDialog = new YesNoCancelDialog((Frame)IJ.getInstance(), "Process Stack?", "Process all " + n4 + " slices?");
            if (yesNoCancelDialog.cancelPressed()) {
                return;
            }
            if (yesNoCancelDialog.yesPressed()) {
                this.doStackOperation(imagePlus, imagePlus2);
            } else {
                this.doOperation(imagePlus, imagePlus2);
            }
        } else {
            this.doOperation(imagePlus, imagePlus2);
        }
    }

    void doStackOperation(ImagePlus imagePlus, ImagePlus imagePlus2) {
        if (createWindow) {
            if ((imagePlus = this.duplicateStack(imagePlus)) == null) {
                IJ.showMessage("Calculator", "Out of memory");
                return;
            }
            imagePlus.show();
        }
        int n = this.getBlitterMode();
        ImageWindow imageWindow = imagePlus.getWindow();
        if (imageWindow != null) {
            WindowManager.setCurrentWindow(imageWindow);
        }
        Undo.reset();
        ImageStack imageStack = imagePlus.getStack();
        StackProcessor stackProcessor = new StackProcessor(imageStack, imagePlus.getProcessor());
        try {
            if (imagePlus2.getStackSize() == 1) {
                stackProcessor.copyBits(imagePlus2.getProcessor(), 0, 0, n);
            } else {
                stackProcessor.copyBits(imagePlus2.getStack(), 0, 0, n);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IJ.error("\"" + imagePlus.getTitle() + "\": " + illegalArgumentException.getMessage());
            return;
        }
        imagePlus.setStack(null, imageStack);
        imagePlus.updateAndDraw();
    }

    void doOperation(ImagePlus imagePlus, ImagePlus imagePlus2) {
        int n = this.getBlitterMode();
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        ImageProcessor imageProcessor2 = imagePlus2.getProcessor();
        if (createWindow) {
            imageProcessor = this.createNewImage(imageProcessor, imageProcessor2);
        } else {
            ImageWindow imageWindow = imagePlus.getWindow();
            if (imageWindow != null) {
                WindowManager.setCurrentWindow(imageWindow);
            }
            imageProcessor.snapshot();
            Undo.setup(1, imagePlus);
        }
        try {
            imageProcessor.copyBits(imageProcessor2, 0, 0, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IJ.error("\"" + imagePlus.getTitle() + "\": " + illegalArgumentException.getMessage());
            return;
        }
        if (createWindow) {
            new ImagePlus("Result", imageProcessor).show();
        } else {
            imagePlus.updateAndDraw();
        }
    }

    ImageProcessor createNewImage(ImageProcessor imageProcessor, ImageProcessor imageProcessor2) {
        int n = Math.min(imageProcessor.getWidth(), imageProcessor2.getWidth());
        int n2 = Math.min(imageProcessor.getHeight(), imageProcessor2.getHeight());
        ImageProcessor imageProcessor3 = imageProcessor.createProcessor(n, n2);
        imageProcessor3.insert(imageProcessor, 0, 0);
        return imageProcessor3;
    }

    private int getBlitterMode() {
        int n = 0;
        switch (operator) {
            case 0: {
                n = 3;
                break;
            }
            case 1: {
                n = 4;
                break;
            }
            case 2: {
                n = 5;
                break;
            }
            case 3: {
                n = 6;
                break;
            }
            case 4: {
                n = 9;
                break;
            }
            case 5: {
                n = 10;
                break;
            }
            case 6: {
                n = 11;
                break;
            }
            case 7: {
                n = 12;
                break;
            }
            case 8: {
                n = 13;
                break;
            }
            case 9: {
                n = 7;
                break;
            }
            case 10: {
                n = 8;
                break;
            }
            case 11: {
                n = 0;
                break;
            }
        }
        return n;
    }

    ImagePlus duplicateStack(ImagePlus imagePlus) {
        ImageStack imageStack = imagePlus.getStack();
        int n = imageStack.getWidth();
        int n2 = imageStack.getHeight();
        int n3 = imageStack.getSize();
        ImageStack imageStack2 = imagePlus.createEmptyStack();
        try {
            int n4 = 1;
            while (n4 <= n3) {
                ImageProcessor imageProcessor = imageStack.getProcessor(n4);
                imageProcessor.setRoi(null);
                ImageProcessor imageProcessor2 = imageProcessor.crop();
                imageStack2.addSlice(imageStack.getSliceLabel(n4), imageProcessor2);
                ++n4;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            imageStack2.trim();
            imageStack2 = null;
            return null;
        }
        return new ImagePlus("Result", imageStack2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        title1 = "";
        title2 = "";
        createWindow = true;
    }
}

