/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.plugin.Plots;
import ij.plugin.PlotsCanvas;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Rectangle;

public class GelAnalyzer
implements PlugIn {
    static int saveID;
    static int nLanes;
    static Rectangle firstRect;
    static final int MAX_LANES = 100;
    static int[] y;
    static PlotsCanvas plotsCanvas;
    static boolean uncalibratedOD;
    static boolean labelWithPercentages;
    boolean invertedLut;
    private static /* synthetic */ Class class$Lij$plugin$GelAnalyzer;

    public void run(String string) {
        Roi roi;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.noImage();
            return;
        }
        if (string.equals("reset")) {
            nLanes = 0;
            saveID = imagePlus.getID();
            if (plotsCanvas != null) {
                plotsCanvas.reset();
            }
            return;
        }
        if (string.equals("percent") && plotsCanvas != null) {
            plotsCanvas.displayPercentages();
            return;
        }
        if (string.equals("label") && plotsCanvas != null) {
            if (GelAnalyzer.plotsCanvas.counter == 0) {
                this.show("There are no peak area measurements.");
            } else {
                plotsCanvas.labelPeaks();
            }
            return;
        }
        if (string.equals("options")) {
            GenericDialog genericDialog = new GenericDialog("Gel Analyzer Options...", IJ.getInstance());
            genericDialog.addCheckbox("Uncalibrated OD", uncalibratedOD);
            genericDialog.addCheckbox("Label with Percentages", labelWithPercentages);
            genericDialog.showDialog();
            if (genericDialog.wasCanceled()) {
                return;
            }
            uncalibratedOD = genericDialog.getNextBoolean();
            labelWithPercentages = genericDialog.getNextBoolean();
            return;
        }
        if (imagePlus.getID() != saveID) {
            nLanes = 0;
            saveID = imagePlus.getID();
        }
        if ((roi = imagePlus.getRoi()) != null && string.equals("perimeter")) {
            IJ.write("Perimeter: " + roi.getLength());
            return;
        }
        if (roi == null || roi.getType() != 0) {
            this.show("Rectangular selection required.");
            return;
        }
        this.invertedLut = imagePlus.isInvertedLut();
        Rectangle rectangle = roi.getBoundingRect();
        if (nLanes == 0) {
            IJ.register(class$Lij$plugin$GelAnalyzer != null ? class$Lij$plugin$GelAnalyzer : (class$Lij$plugin$GelAnalyzer = GelAnalyzer.class$("ij.plugin.GelAnalyzer")));
        }
        if (string.equals("first")) {
            this.selectFirstLane(rectangle);
            return;
        }
        if (nLanes == 0) {
            this.show("You must first use the \"Outline First Lane\" command.");
            return;
        }
        if (string.equals("next")) {
            this.selectNextLane(rectangle);
            return;
        }
        if (string.equals("plot")) {
            if (rectangle.y != y[nLanes]) {
                this.selectNextLane(rectangle);
            }
            this.plotLanes(imagePlus);
            return;
        }
    }

    void selectFirstLane(Rectangle rectangle) {
        if (rectangle.height >= rectangle.width) {
            this.show("Lanes must be horizontal.");
            return;
        }
        IJ.showStatus("Lane 1 selected");
        firstRect = rectangle;
        nLanes = 1;
        GelAnalyzer.y[1] = rectangle.y;
    }

    void selectNextLane(Rectangle rectangle) {
        if (rectangle.width != GelAnalyzer.firstRect.width || rectangle.height != GelAnalyzer.firstRect.height) {
            this.show("Selections must all be the same size.");
            return;
        }
        if (nLanes < 100) {
            ++nLanes;
        }
        IJ.showStatus("Lane " + nLanes + " selected");
        GelAnalyzer.y[GelAnalyzer.nLanes] = rectangle.y;
    }

    double od(double d) {
        if (this.invertedLut) {
            if (d == 255.0) {
                d = 254.5;
            }
            return 0.434294481 * Math.log(255.0 / (255.0 - d));
        }
        if (d == 0.0) {
            d = 0.5;
        }
        return 0.434294481 * Math.log(255.0 / d);
    }

    void plotLanes(ImagePlus imagePlus) {
        Object object;
        int n;
        Calibration calibration = imagePlus.getCalibration();
        if (uncalibratedOD) {
            calibration.setFunction(21, null, "Uncalibrated OD");
        } else if (calibration.getFunction() == 21) {
            calibration.setFunction(20, null, "Gray Value");
        }
        int n2 = 16;
        int n3 = 2;
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        double[][] dArray = new double[101][];
        IJ.showStatus("Plotting " + nLanes + " lanes");
        int n4 = 1;
        while (n4 <= nLanes) {
            imagePlus.setRoi(GelAnalyzer.firstRect.x, y[n4], GelAnalyzer.firstRect.width, GelAnalyzer.firstRect.height);
            ProfilePlot profilePlot = new ProfilePlot(imagePlus);
            dArray[n4] = profilePlot.getProfile();
            if (profilePlot.getMin() < d) {
                d = profilePlot.getMin();
            }
            if (profilePlot.getMax() > d2) {
                d2 = profilePlot.getMax();
            }
            ++n4;
        }
        int n5 = GelAnalyzer.firstRect.width;
        if (n5 < 500) {
            n5 = 500;
        }
        if (n5 > 2 * GelAnalyzer.firstRect.width) {
            n5 = 2 * GelAnalyzer.firstRect.width;
        }
        if ((n = n5 / 2) < 200) {
            n = 200;
        }
        if (n > 400) {
            n = 400;
        }
        ByteProcessor byteProcessor = new ByteProcessor(n5, n2 + nLanes * n + n3);
        ((ImageProcessor)byteProcessor).setColor(Color.white);
        byteProcessor.fill();
        ((ImageProcessor)byteProcessor).setColor(Color.black);
        int n6 = byteProcessor.getHeight();
        byteProcessor.moveTo(0, 0);
        byteProcessor.lineTo(n5 - 1, 0);
        byteProcessor.lineTo(n5 - 1, n6 - 1);
        byteProcessor.lineTo(0, n6 - 1);
        byteProcessor.lineTo(0, 0);
        byteProcessor.moveTo(0, n6 - 2);
        byteProcessor.lineTo(n5 - 1, n6 - 2);
        String string = imagePlus.getTitle() + "; ";
        string = calibration.calibrated() ? string + calibration.getValueUnit() : string + "**Uncalibrated**";
        byteProcessor.moveTo(5, n2);
        byteProcessor.drawString(string);
        double d3 = (double)n5 / (double)dArray[1].length;
        double d4 = d2 - d == 0.0 ? 1.0 : (double)n / (d2 - d);
        int n7 = 1;
        while (n7 <= nLanes) {
            object = dArray[n7];
            int n8 = (n7 - 1) * n + n2;
            int n9 = n8 + n;
            byteProcessor.moveTo(0, n9);
            byteProcessor.lineTo((int)((double)((double[])object).length * d3), n9);
            byteProcessor.moveTo(0, n9 - (int)((object[0] - d) * d4));
            int n10 = 1;
            while (n10 < ((Object)object).length) {
                byteProcessor.lineTo((int)((double)n10 * d3 + 0.5), n9 - (int)((object[n10] - d) * d4 + 0.5));
                ++n10;
            }
            ++n7;
        }
        Plots plots = new Plots();
        plots.setProcessor("Plots", byteProcessor);
        byteProcessor.setThreshold(0.0, 0.0, 2);
        ((ImagePlus)plots).show();
        nLanes = 0;
        saveID = 0;
        object = Toolbar.getInstance();
        ((Toolbar)object).setColor(Color.black);
        ((Toolbar)object).setTool(4);
        ImageWindow imageWindow = WindowManager.getCurrentWindow();
        plotsCanvas = (PlotsCanvas)imageWindow.getCanvas();
    }

    void show(String string) {
        IJ.showMessage("Gel Analyzer", string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        nLanes = 0;
        y = new int[101];
        uncalibratedOD = true;
        labelWithPercentages = true;
    }
}

