/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.util.StringSorter;
import java.io.File;

public class FolderOpener
implements PlugIn {
    public void run(String string) {
        OpenDialog openDialog = new OpenDialog("Open All As Stack...", string);
        String string2 = openDialog.getDirectory();
        String string3 = openDialog.getFileName();
        if (string3 == null) {
            return;
        }
        String[] stringArray = new File(string2).list();
        if (stringArray == null) {
            return;
        }
        StringSorter.sort(stringArray);
        if (IJ.debugMode) {
            IJ.write("FolderOpener: " + string2 + " (" + stringArray.length + " files)");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        ImageStack imageStack = null;
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        int n4 = 0;
        try {
            int n5 = 0;
            while (n5 < stringArray.length) {
                ImagePlus imagePlus = new Opener().openImage(string2, stringArray[n5]);
                if (imagePlus != null && imageStack == null) {
                    imageStack = imagePlus.createEmptyStack();
                    n = imagePlus.getWidth();
                    n2 = imagePlus.getHeight();
                    n3 = imagePlus.getType();
                }
                if (imageStack != null) {
                    n4 = imageStack.getSize() + 1;
                }
                IJ.showStatus(n4 + "/" + stringArray.length);
                IJ.showProgress((double)n4 / (double)stringArray.length);
                if (imagePlus == null) {
                    IJ.write(stringArray[n5] + ": unable to open");
                } else if (imagePlus.getWidth() != n || imagePlus.getHeight() != n2) {
                    IJ.write(stringArray[n5] + ": wrong dimensions");
                } else if (imagePlus.getType() != n3) {
                    IJ.write(stringArray[n5] + ": wrong type");
                } else {
                    ImageProcessor imageProcessor = imagePlus.getProcessor();
                    if (imageProcessor.getMin() < d) {
                        d = imageProcessor.getMin();
                    }
                    if (imageProcessor.getMax() > d2) {
                        d2 = imageProcessor.getMax();
                    }
                    imageStack.addSlice(imagePlus.getTitle(), imageProcessor);
                }
                System.gc();
                ++n5;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IJ.outOfMemory("FolderOpener");
            imageStack.trim();
        }
        if (imageStack != null && imageStack.getSize() > 0) {
            ImagePlus imagePlus = new ImagePlus("Stack", imageStack);
            if (imagePlus.getType() == 1 || imagePlus.getType() == 2) {
                imagePlus.getProcessor().setMinAndMax(d, d2);
            }
            imagePlus.show();
        }
        IJ.showProgress(1.0);
    }
}

