/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.plugin.FitsDecoder;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.io.IOException;

public class FITS
extends ImagePlus
implements PlugIn {
    public void run(String string) {
        OpenDialog openDialog = new OpenDialog("Open FITS...", string);
        String string2 = openDialog.getDirectory();
        String string3 = openDialog.getFileName();
        if (string3 == null) {
            return;
        }
        IJ.showStatus("Opening: " + string2 + string3);
        FitsDecoder fitsDecoder = new FitsDecoder(string2, string3);
        FileInfo fileInfo = null;
        try {
            fileInfo = fitsDecoder.getInfo();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (fileInfo != null && fileInfo.width > 0 && fileInfo.height > 0 && fileInfo.offset > 0) {
            FileOpener fileOpener = new FileOpener(fileInfo);
            ImagePlus imagePlus = fileOpener.open(false);
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            this.setProcessor(string3, imageProcessor);
            this.setCalibration(imagePlus.getCalibration());
            this.setProperty("Info", fitsDecoder.getHeaderInfo());
            if (string.equals("")) {
                this.show();
            }
        } else {
            IJ.error("This does not appear to be a FITS file.");
        }
        IJ.showStatus("");
    }
}

