/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.io.FileInfo;
import ij.plugin.DicomDictionary;
import ij.util.Tools;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

class DicomDecoder {
    private static final int PIXEL_REPRESENTATION = 2621699;
    private static final int TRANSFER_SYNTAX_UID = 131088;
    private static final int SLICE_SPACING = 0x180088;
    private static final int NUMBER_OF_FRAMES = 0x280008;
    private static final int ROWS = 2621456;
    private static final int COLUMNS = 2621457;
    private static final int PIXEL_SPACING = 2621488;
    private static final int BITS_ALLOCATED = 2621696;
    private static final int RED_PALETTE = 2626049;
    private static final int GREEN_PALETTE = 2626050;
    private static final int BLUE_PALETTE = 2626051;
    private static final int PIXEL_DATA = 2145386512;
    private static final int AE = 16709;
    private static final int AS = 16723;
    private static final int AT = 16724;
    private static final int CS = 17235;
    private static final int DA = 17473;
    private static final int DS = 17491;
    private static final int DT = 17492;
    private static final int FD = 17988;
    private static final int FL = 17996;
    private static final int IS = 18771;
    private static final int LO = 19535;
    private static final int LT = 19540;
    private static final int PN = 20558;
    private static final int SH = 21320;
    private static final int SL = 21324;
    private static final int SS = 21331;
    private static final int ST = 21332;
    private static final int TM = 21581;
    private static final int UI = 21833;
    private static final int UL = 21836;
    private static final int US = 21843;
    private static final int UT = 21844;
    private static final int OB = 20290;
    private static final int OW = 20311;
    private static final int SQ = 21329;
    private static final int UN = 21838;
    private static final int QQ = 16191;
    private static Properties dictionary;
    private static final int ID_OFFSET = 128;
    private static final String DICM = "DICM";
    private static final int IMPLICIT_VR = 11565;
    static char[] buf8;
    private String directory;
    private String fileName;
    private BufferedInputStream f;
    private int location = 0;
    private boolean littleEndian = true;
    private int elementLength;
    private int vr;
    private byte[] vrLetters = new byte[2];
    private int previousGroup;
    private StringBuffer dicomInfo = new StringBuffer(1000);
    private boolean dicmFound;
    private boolean oddLocations;
    char[] buf10;
    private static /* synthetic */ Class class$Lij$plugin$DICOM;

    String getString(int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.f.read(byArray, n2, n - n2);
            n2 += n3;
        }
        this.location += n;
        return new String(byArray);
    }

    int getByte() throws IOException {
        int n = this.f.read();
        if (n == -1) {
            throw new IOException("unexpected EOF");
        }
        ++this.location;
        return n;
    }

    int getShort() throws IOException {
        int n = this.getByte();
        int n2 = this.getByte();
        if (this.littleEndian) {
            return (n2 << 8) + n;
        }
        return (n << 8) + n2;
    }

    final int getInt() throws IOException {
        int n = this.getByte();
        int n2 = this.getByte();
        int n3 = this.getByte();
        int n4 = this.getByte();
        if (this.littleEndian) {
            return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    byte[] getLut(int n) throws IOException {
        if ((n & 1) != 0) {
            String string = this.getString(n);
            return null;
        }
        byte[] byArray = new byte[n /= 2];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)(this.getShort() >>> 8);
            ++n2;
        }
        return byArray;
    }

    int getLength() throws IOException {
        int n = this.getByte();
        int n2 = this.getByte();
        int n3 = this.getByte();
        int n4 = this.getByte();
        this.vr = (n << 8) + n2;
        switch (this.vr) {
            case 20290: 
            case 20311: 
            case 21329: 
            case 21838: {
                if (n3 == 0 || n4 == 0) {
                    return this.getInt();
                }
                this.vr = 11565;
                if (this.littleEndian) {
                    return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
                }
                return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
            }
            case 16191: 
            case 16709: 
            case 16723: 
            case 16724: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 17988: 
            case 17996: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21324: 
            case 21331: 
            case 21332: 
            case 21581: 
            case 21833: 
            case 21836: 
            case 21843: 
            case 21844: {
                if (this.littleEndian) {
                    return (n4 << 8) + n3;
                }
                return (n3 << 8) + n4;
            }
        }
        this.vr = 11565;
        if (this.littleEndian) {
            return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    int getNextTag() throws IOException {
        int n = this.getShort();
        int n2 = this.getShort();
        int n3 = n << 16 | n2;
        this.elementLength = this.getLength();
        if (this.elementLength == 13 && !this.oddLocations) {
            this.elementLength = 10;
        }
        if (this.elementLength == -1) {
            this.elementLength = 0;
        }
        return n3;
    }

    FileInfo getFileInfo() throws IOException {
        FileInfo fileInfo = new FileInfo();
        int n = 16;
        fileInfo.fileFormat = FileInfo.RAW;
        fileInfo.fileName = this.fileName;
        fileInfo.directory = this.directory;
        fileInfo.width = 0;
        fileInfo.height = 0;
        fileInfo.offset = 0;
        fileInfo.intelByteOrder = true;
        fileInfo.fileType = 2;
        this.f = new BufferedInputStream(new FileInputStream(this.directory + this.fileName));
        if (IJ.debugMode) {
            IJ.write("");
            IJ.write("DicomDecoder: decoding " + this.fileName);
        }
        long l = 128L;
        while (l > 0L) {
            l -= this.f.skip(l);
        }
        this.location += 128;
        if (!this.getString(4).equals(DICM)) {
            this.f.close();
            this.f = new BufferedInputStream(new FileInputStream(this.directory + this.fileName));
            this.location = 0;
            if (IJ.debugMode) {
                IJ.write("DICM not found at offset 128; reseting to offset 0");
            }
        } else if (IJ.debugMode) {
            this.dicmFound = true;
            IJ.write("DICM found at offset 128");
        }
        boolean bl = true;
        while (true) {
            int n2 = this.getNextTag();
            if ((this.location & 1) != 0) {
                this.oddLocations = true;
                if (this.dicmFound) break;
            }
            if (n2 == 131088) {
                String string = this.getString(this.elementLength);
                this.addInfo(n2, string);
                if (string.indexOf("1.2.4") <= -1 && string.indexOf("1.2.5") <= -1) continue;
                this.f.close();
                String string2 = "ImageJ cannot open compressed DICOM images.\n \n";
                string2 = string2 + "Transfer Syntax UID = " + string;
                throw new IOException(string2);
            }
            if (n2 == 0x280008) {
                String string = this.getString(this.elementLength);
                this.addInfo(n2, string);
                double d = this.s2d(string);
                if (!(d > 1.0)) continue;
                fileInfo.nImages = (int)d;
                continue;
            }
            if (n2 == 2621456) {
                fileInfo.height = this.getShort();
                this.addInfo(n2, Integer.toString(fileInfo.height));
                continue;
            }
            if (n2 == 2621457) {
                fileInfo.width = this.getShort();
                this.addInfo(n2, Integer.toString(fileInfo.width));
                continue;
            }
            if (n2 == 2621488) {
                String string = this.getString(this.elementLength);
                this.getSpatialScale(fileInfo, string);
                this.addInfo(n2, string);
                continue;
            }
            if (n2 == 0x180088) {
                String string = this.getString(this.elementLength);
                fileInfo.pixelDepth = this.s2d(string);
                this.addInfo(n2, string);
                continue;
            }
            if (n2 == 2621696) {
                n = this.getShort();
                if (n == 8) {
                    fileInfo.fileType = 0;
                }
                this.addInfo(n2, Integer.toString(n));
                continue;
            }
            if (n2 == 2621699) {
                int n3 = this.getShort();
                if (n3 == 1) {
                    fileInfo.fileType = 1;
                }
                this.addInfo(n2, Integer.toString(n3));
                continue;
            }
            if (n2 == 2626049) {
                fileInfo.reds = this.getLut(this.elementLength);
                this.addInfo(n2, Integer.toString(this.elementLength / 2));
                continue;
            }
            if (n2 == 2626050) {
                fileInfo.greens = this.getLut(this.elementLength);
                this.addInfo(n2, Integer.toString(this.elementLength / 2));
                continue;
            }
            if (n2 == 2626051) {
                fileInfo.blues = this.getLut(this.elementLength);
                this.addInfo(n2, Integer.toString(this.elementLength / 2));
                continue;
            }
            if (n2 == 2145386512 && this.elementLength != 0) {
                fileInfo.offset = this.location;
                this.addInfo(n2, Integer.toString(this.location));
                break;
            }
            if (n2 == 2139619344 && this.elementLength != 0) {
                fileInfo.offset = this.location + 4;
                break;
            }
            this.addInfo(n2, null);
        }
        if (fileInfo.fileType == 0 && fileInfo.reds != null && fileInfo.greens != null && fileInfo.blues != null && fileInfo.reds.length == fileInfo.greens.length && fileInfo.reds.length == fileInfo.blues.length) {
            fileInfo.fileType = 5;
            fileInfo.lutSize = fileInfo.reds.length;
        }
        if (IJ.debugMode) {
            IJ.write("width: " + fileInfo.width);
            IJ.write("height: " + fileInfo.height);
            IJ.write("images: " + fileInfo.nImages);
            IJ.write("bits allocated: " + n);
            IJ.write("offset: " + fileInfo.offset);
        }
        this.f.close();
        return fileInfo;
    }

    String getDicomInfo() {
        return new String(this.dicomInfo);
    }

    void addInfo(int n, String string) throws IOException {
        String string2 = this.getHeaderInfo(n, string);
        if (string2 != null) {
            int n2 = n >>> 16;
            if (n2 != this.previousGroup) {
                this.dicomInfo.append("\n");
            }
            this.previousGroup = n2;
            this.dicomInfo.append(this.tag2hex(n) + string2 + "\n");
        }
        if (IJ.debugMode) {
            if (string2 == null) {
                string2 = "";
            }
            this.vrLetters[0] = (byte)(this.vr >> 8);
            this.vrLetters[1] = (byte)(this.vr & 0xFF);
            String string3 = new String(this.vrLetters);
            IJ.write("(" + this.tag2hex(n) + string3 + " " + this.elementLength + " bytes from " + (this.location - this.elementLength) + ") " + string2);
        }
    }

    String getHeaderInfo(int n, String string) throws IOException {
        String string2 = this.i2hex(n);
        String string3 = (String)((Hashtable)dictionary).get(string2);
        if (string3 != null) {
            if (this.vr == 11565 && string3 != null) {
                this.vr = (string3.charAt(0) << 8) + string3.charAt(1);
            }
            string3 = string3.substring(2);
        }
        if (string != null) {
            return string3 + ": " + string;
        }
        switch (this.vr) {
            case 16709: 
            case 16723: 
            case 16724: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21332: 
            case 21581: 
            case 21833: {
                string = this.getString(this.elementLength);
                break;
            }
            case 21843: {
                if (this.elementLength == 2) {
                    string = Integer.toString(this.getShort());
                    break;
                }
                string = "";
                int n2 = this.elementLength / 2;
                int n3 = 0;
                while (n3 < n2) {
                    string = string + Integer.toString(this.getShort()) + " ";
                    ++n3;
                }
                break;
            }
            default: {
                long l = this.elementLength;
                while (l > 0L) {
                    l -= this.f.skip(l);
                }
                this.location += this.elementLength;
                string = "";
            }
        }
        if (string3 == null) {
            return null;
        }
        return string3 + ": " + string;
    }

    String i2hex(int n) {
        int n2 = 7;
        while (n2 >= 0) {
            DicomDecoder.buf8[n2] = Tools.hexDigits[n & 0xF];
            n >>>= 4;
            --n2;
        }
        return new String(buf8);
    }

    String tag2hex(int n) {
        if (this.buf10 == null) {
            this.buf10 = new char[11];
            this.buf10[4] = 44;
            this.buf10[9] = 32;
        }
        int n2 = 8;
        while (n2 >= 0) {
            this.buf10[n2] = Tools.hexDigits[n & 0xF];
            n >>>= 4;
            if (--n2 != 4) continue;
            --n2;
        }
        return new String(this.buf10);
    }

    double s2d(String string) {
        Double d;
        try {
            d = new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    void getSpatialScale(FileInfo fileInfo, String string) {
        double d = 0.0;
        double d2 = 0.0;
        int n = string.indexOf(92);
        if (n > 0) {
            d = this.s2d(string.substring(0, n));
            d2 = this.s2d(string.substring(n + 1));
        }
        if (d != 0.0 && d2 != 0.0) {
            fileInfo.pixelWidth = d;
            fileInfo.pixelHeight = d2;
            fileInfo.unit = "mm";
        }
    }

    boolean dicmFound() {
        return this.dicmFound;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public DicomDecoder(String string, String string2) {
        this.directory = string;
        this.fileName = string2;
        if (dictionary == null) {
            DicomDictionary dicomDictionary = new DicomDictionary();
            dictionary = dicomDictionary.getDictionary();
        }
        IJ.register(class$Lij$plugin$DICOM != null ? class$Lij$plugin$DICOM : (class$Lij$plugin$DICOM = DicomDecoder.class$("ij.plugin.DICOM")));
    }

    static {
        buf8 = new char[8];
    }
}

