/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.DicomDecoder;
import ij.plugin.PlugIn;
import java.io.IOException;

public class DICOM
extends ImagePlus
implements PlugIn {
    public void run(String string) {
        Object object;
        FileInfo fileInfo;
        DicomDecoder dicomDecoder;
        String string2;
        block10: {
            OpenDialog openDialog = new OpenDialog("Open Dicom...", string);
            String string3 = openDialog.getDirectory();
            string2 = openDialog.getFileName();
            if (string2 == null) {
                return;
            }
            IJ.showStatus("Opening: " + string3 + string2);
            dicomDecoder = new DicomDecoder(string3, string2);
            fileInfo = null;
            try {
                fileInfo = dicomDecoder.getFileInfo();
            }
            catch (IOException iOException) {
                object = iOException.getMessage();
                IJ.showStatus("");
                if (((String)object).indexOf("EOF") < 0) {
                    IJ.showMessage("DicomDecoder", (String)object);
                    return;
                }
                if (dicomDecoder.dicmFound()) break block10;
                object = "This does not appear to be a valid\nDICOM file. It does not have the\ncharacters 'DICM' at offset 128.";
                IJ.showMessage("DicomDecoder", (String)object);
                return;
            }
        }
        if (fileInfo != null && fileInfo.width > 0 && fileInfo.height > 0 && fileInfo.offset > 0) {
            FileOpener fileOpener = new FileOpener(fileInfo);
            object = fileOpener.open(false);
            if (fileInfo.fileType == 1) {
                Calibration calibration = ((ImagePlus)object).getCalibration();
                double[] dArray = new double[]{-32768.0, 1.0};
                calibration.setFunction(0, dArray, "gray value");
            }
            if (((ImagePlus)object).getStackSize() > 1) {
                this.setStack(string2, ((ImagePlus)object).getStack());
            } else {
                this.setProcessor(string2, ((ImagePlus)object).getProcessor());
            }
            this.setCalibration(((ImagePlus)object).getCalibration());
            this.setProperty("Info", dicomDecoder.getDicomInfo());
            if (string.equals("")) {
                this.show();
            }
        } else {
            IJ.showMessage("DicomDecoder", "Unable to decode DICOM header.");
        }
        IJ.showStatus("");
    }
}

