/*
 * Decompiled with CFR 0.152.
 */
package ij.measure;

import ij.ImagePlus;
import ij.measure.CurveFitter;

public class Calibration {
    public static final int STRAIGHT_LINE = 0;
    public static final int POLY2 = 1;
    public static final int POLY3 = 2;
    public static final int POLY4 = 3;
    public static final int EXPONENTIAL = 4;
    public static final int POWER = 5;
    public static final int LOG = 6;
    public static final int RODBARD = 7;
    public static final int GAMMA_VARIATE = 8;
    public static final int NONE = 20;
    public static final int UNCALIBRATED_OD = 21;
    public double pixelWidth = 1.0;
    public double pixelHeight = 1.0;
    public double pixelDepth = 1.0;
    public int xOrigin;
    public int yOrigin;
    public boolean invertY;
    private double[] coefficients;
    private String unit = "pixel";
    private String units;
    private String valueUnit = "Gray Value";
    private int function = 20;
    private float[] cTable;
    private boolean invertedLut;
    private int bitDepth = 8;

    public boolean scaled() {
        return this.pixelWidth != 1.0 || this.pixelHeight != 1.0;
    }

    public void setUnit(String string) {
        this.unit = string == null ? "pixel" : string;
        this.units = null;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getUnits() {
        if (this.units == null) {
            this.units = this.unit.equals("pixel") ? "pixels" : (this.unit.equals("micron") ? "microns" : (this.unit.equals("inch") ? "inches" : this.unit));
        }
        return this.units;
    }

    public double getX(int n) {
        return (double)(n - this.xOrigin) * this.pixelWidth;
    }

    public double getY(int n) {
        return (double)(n - this.yOrigin) * this.pixelHeight;
    }

    public void setFunction(int n, double[] dArray, String string) {
        if (n == 20) {
            this.disableDensityCalibration();
            return;
        }
        if (dArray == null && n >= 0 && n <= 8) {
            return;
        }
        this.function = n;
        this.coefficients = dArray;
        if (string != null) {
            this.valueUnit = string;
        }
        this.cTable = null;
    }

    public void disableDensityCalibration() {
        this.function = 20;
        this.coefficients = null;
        this.cTable = null;
        this.valueUnit = "Gray Value";
    }

    public String getValueUnit() {
        return this.valueUnit;
    }

    public double[] getCoefficients() {
        return this.coefficients;
    }

    public boolean calibrated() {
        return this.function != 20;
    }

    public int getFunction() {
        return this.function;
    }

    public float[] getCTable() {
        if (this.cTable == null) {
            this.makeCTable();
        }
        return this.cTable;
    }

    void makeCTable() {
        if (this.bitDepth == 16) {
            this.make16BitCTable();
            return;
        }
        if (this.function == 21) {
            this.cTable = new float[256];
            int n = 0;
            while (n < 256) {
                this.cTable[n] = (float)this.od(n);
                ++n;
            }
        } else if (this.function >= 0 && this.function <= 8 && this.coefficients != null) {
            this.cTable = new float[256];
            int n = 0;
            while (n < 256) {
                this.cTable[n] = (float)CurveFitter.f(this.function, this.coefficients, n);
                ++n;
            }
        } else {
            this.cTable = null;
        }
    }

    void make16BitCTable() {
        if (this.function >= 0 && this.function <= 8 && this.coefficients != null) {
            this.cTable = new float[65536];
            int n = 0;
            while (n < 65536) {
                this.cTable[n] = (float)CurveFitter.f(this.function, this.coefficients, n);
                ++n;
            }
        } else {
            this.cTable = null;
        }
    }

    double od(double d) {
        if (this.invertedLut) {
            if (d == 255.0) {
                d = 254.5;
            }
            return 0.434294481 * Math.log(255.0 / (255.0 - d));
        }
        if (d == 0.0) {
            d = 0.5;
        }
        return 0.434294481 * Math.log(255.0 / d);
    }

    public double getCValue(int n) {
        if (this.function == 20) {
            return n;
        }
        if (this.function >= 0 && this.function <= 8 && this.coefficients != null) {
            return CurveFitter.f(this.function, this.coefficients, n);
        }
        if (this.cTable == null) {
            this.makeCTable();
        }
        if (this.cTable != null && n >= 0 && n < this.cTable.length) {
            return this.cTable[n];
        }
        return n;
    }

    public Calibration copy() {
        Calibration calibration = new Calibration();
        calibration.pixelWidth = this.pixelWidth;
        calibration.pixelHeight = this.pixelHeight;
        calibration.pixelDepth = this.pixelDepth;
        calibration.unit = this.unit;
        calibration.units = this.units;
        calibration.valueUnit = this.valueUnit;
        calibration.function = this.function;
        calibration.coefficients = this.coefficients;
        calibration.cTable = this.cTable;
        calibration.invertedLut = this.invertedLut;
        calibration.bitDepth = this.bitDepth;
        return calibration;
    }

    public String toString() {
        return "w=" + this.pixelWidth + ", h=" + this.pixelHeight + ", d=" + this.pixelDepth + ", unit=" + this.unit + ", f=" + this.function + ", nc=" + (this.coefficients != null ? "" + this.coefficients.length : "null") + ", table=" + (this.cTable != null ? "" + this.cTable.length : "null") + ", vunit=" + this.valueUnit;
    }

    public Calibration(ImagePlus imagePlus) {
        if (imagePlus != null) {
            if (imagePlus.getType() == 1) {
                this.bitDepth = 16;
            }
            this.invertedLut = imagePlus.isInvertedLut();
        }
    }

    public Calibration() {
    }
}

