/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.io.FileInfo;
import ij.io.ImageWriter;
import java.io.DataOutputStream;
import java.io.IOException;

public class TiffEncoder {
    static final int IMAGE_START = 768;
    static final int HDR_SIZE = 8;
    static final int MAP_SIZE = 768;
    static final int BPS_DATA_SIZE = 6;
    static final int SCALE_DATA_SIZE = 16;
    private FileInfo fi;
    private int bitsPerSample;
    private int photoInterp;
    private int samplesPerPixel;
    private int nEntries;
    private int ifdSize;
    private int imageOffset = 768;
    private int imageSize;
    private int stackSize;
    private byte[] description;

    public void write(DataOutputStream dataOutputStream) throws IOException {
        this.writeHeader(dataOutputStream);
        int n = 0;
        if (this.fi.nImages > 1) {
            n = 768 + this.stackSize;
            if (this.fi.fileType == 5) {
                n += 1536;
            }
        }
        this.writeIFD(dataOutputStream, this.imageOffset, n);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.fi.fileType == 6) {
            n2 = this.writeBitsPerPixel(dataOutputStream);
        }
        if (this.description != null) {
            n4 = this.writeDescription(dataOutputStream);
        }
        if (this.fi.unit != null && this.fi.pixelWidth != 0.0 && this.fi.pixelHeight != 0.0) {
            n3 = this.writeScale(dataOutputStream);
        }
        byte[] byArray = new byte[768 - (8 + this.ifdSize + n2 + n4 + n3)];
        dataOutputStream.write(byArray);
        new ImageWriter(this.fi).write(dataOutputStream);
        if (this.fi.fileType == 5) {
            this.writeColorMap(dataOutputStream);
        }
        int n5 = 2;
        while (n5 <= this.fi.nImages) {
            n = n5 == this.fi.nImages ? 0 : (n += this.ifdSize);
            this.imageOffset += this.imageSize;
            this.writeIFD(dataOutputStream, this.imageOffset, n);
            ++n5;
        }
    }

    void writeHeader(DataOutputStream dataOutputStream) throws IOException {
        byte[] byArray = new byte[]{77, 77, 0, 42, 0, 0, 0, 8};
        dataOutputStream.write(byArray);
    }

    void writeEntry(DataOutputStream dataOutputStream, int n, int n2, int n3, int n4) throws IOException {
        dataOutputStream.writeShort(n);
        dataOutputStream.writeShort(n2);
        dataOutputStream.writeInt(n3);
        if (n3 == 1 && n2 == 3) {
            n4 <<= 16;
        }
        dataOutputStream.writeInt(n4);
    }

    void writeIFD(DataOutputStream dataOutputStream, int n, int n2) throws IOException {
        int n3;
        int n4 = 8 + this.ifdSize;
        dataOutputStream.writeShort(this.nEntries);
        this.writeEntry(dataOutputStream, 254, 4, 1, 0);
        this.writeEntry(dataOutputStream, 256, 3, 1, this.fi.width);
        this.writeEntry(dataOutputStream, 257, 3, 1, this.fi.height);
        if (this.fi.fileType == 6) {
            this.writeEntry(dataOutputStream, 258, 3, 3, n4);
            n4 += 6;
        } else {
            this.writeEntry(dataOutputStream, 258, 3, 1, this.bitsPerSample);
        }
        this.writeEntry(dataOutputStream, 262, 3, 1, this.photoInterp);
        if (this.description != null) {
            this.writeEntry(dataOutputStream, 270, 2, this.description.length, n4);
            n4 += this.description.length;
        }
        this.writeEntry(dataOutputStream, 273, 4, 1, n);
        this.writeEntry(dataOutputStream, 277, 3, 1, this.samplesPerPixel);
        this.writeEntry(dataOutputStream, 278, 3, 1, this.fi.height);
        this.writeEntry(dataOutputStream, 279, 4, 1, this.imageSize);
        if (this.fi.unit != null && this.fi.pixelWidth != 0.0 && this.fi.pixelHeight != 0.0) {
            this.writeEntry(dataOutputStream, 282, 5, 1, n4);
            this.writeEntry(dataOutputStream, 283, 5, 1, n4 + 8);
            n4 += 16;
            n3 = 1;
            if (this.fi.unit.equals("inch")) {
                n3 = 2;
            } else if (this.fi.unit.equals("cm")) {
                n3 = 3;
            }
            this.writeEntry(dataOutputStream, 296, 3, 1, n3);
        }
        if (this.fi.fileType == FileInfo.GRAY32_FLOAT) {
            n3 = 3;
            this.writeEntry(dataOutputStream, 339, 3, 1, n3);
        }
        if (this.fi.fileType == 5) {
            this.writeEntry(dataOutputStream, 320, 3, 768, 768 + this.stackSize);
        }
        dataOutputStream.writeInt(n2);
    }

    int writeBitsPerPixel(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(8);
        dataOutputStream.writeShort(8);
        dataOutputStream.writeShort(8);
        return 6;
    }

    int writeScale(DataOutputStream dataOutputStream) throws IOException {
        double d = 1.0 / this.fi.pixelWidth;
        double d2 = 1.0 / this.fi.pixelHeight;
        double d3 = 1000000.0;
        if (d > 1000.0) {
            d3 = 1000.0;
        }
        dataOutputStream.writeInt((int)(d * d3));
        dataOutputStream.writeInt((int)d3);
        dataOutputStream.writeInt((int)(d2 * d3));
        dataOutputStream.writeInt((int)d3);
        return 16;
    }

    int writeDescription(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(this.description, 0, this.description.length);
        return this.description.length;
    }

    void writeColorMap(DataOutputStream dataOutputStream) throws IOException {
        byte[] byArray = new byte[1536];
        int n = 0;
        int n2 = 0;
        while (n2 < this.fi.lutSize) {
            byArray[n] = this.fi.reds[n2];
            byArray[512 + n] = this.fi.greens[n2];
            byArray[1024 + n] = this.fi.blues[n2];
            n += 2;
            ++n2;
        }
        dataOutputStream.write(byArray);
    }

    void makeDescriptionString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("ImageJ=1.22d\n");
        if (this.fi.nImages > 1) {
            stringBuffer.append("images=" + this.fi.nImages + "\n");
        }
        if (this.fi.unit != null) {
            stringBuffer.append("unit=" + this.fi.unit + "\n");
        }
        if (this.fi.valueUnit != null) {
            stringBuffer.append("cf=" + this.fi.calibrationFunction + "\n");
            if (this.fi.coefficients != null) {
                int n = 0;
                while (n < this.fi.coefficients.length) {
                    stringBuffer.append("c" + n + "=" + this.fi.coefficients[n] + "\n");
                    ++n;
                }
            }
            stringBuffer.append("vunit=" + this.fi.valueUnit + "\n");
        }
        stringBuffer.append("");
        this.description = new String(stringBuffer).getBytes();
        this.description[this.description.length - 1] = 0;
    }

    public TiffEncoder(FileInfo fileInfo) {
        this.fi = fileInfo;
        fileInfo.intelByteOrder = false;
        this.bitsPerSample = 8;
        this.samplesPerPixel = 1;
        this.nEntries = 9;
        int n = 1;
        switch (fileInfo.fileType) {
            case 0: {
                this.photoInterp = fileInfo.whiteIsZero ? 0 : 1;
                break;
            }
            case 1: 
            case 2: {
                this.bitsPerSample = 16;
                this.photoInterp = fileInfo.whiteIsZero ? 0 : 1;
                n = 2;
                break;
            }
            case 4: {
                this.bitsPerSample = 32;
                this.photoInterp = fileInfo.whiteIsZero ? 0 : 1;
                n = 4;
                break;
            }
            case 6: {
                this.photoInterp = 2;
                this.samplesPerPixel = 3;
                n = 3;
                break;
            }
            case 5: {
                this.photoInterp = 3;
                this.nEntries = 10;
                break;
            }
            default: {
                this.photoInterp = 0;
            }
        }
        if (fileInfo.unit != null && fileInfo.pixelWidth != 0.0 && fileInfo.pixelHeight != 0.0) {
            this.nEntries += 3;
        }
        if (fileInfo.fileType == FileInfo.GRAY32_FLOAT) {
            ++this.nEntries;
        }
        this.makeDescriptionString();
        if (this.description != null) {
            ++this.nEntries;
        }
        this.ifdSize = 2 + this.nEntries * 12 + 4;
        this.imageSize = fileInfo.width * fileInfo.height * n;
        this.stackSize = this.imageSize * fileInfo.nImages;
    }
}

