/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.ImageReader;
import ij.io.OpenDialog;
import ij.io.TiffDecoder;
import ij.plugin.frame.Editor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import ij.text.TextWindow;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Opener {
    private static final int UNKNOWN = 0;
    private static final int TIFF = 1;
    private static final int DICOM = 2;
    private static final int FITS = 3;
    private static final int PGM = 4;
    private static final int JPEG = 5;
    private static final int GIF = 6;
    private static final int LUT = 7;
    private static final int BMP = 8;
    private static final int ZIP = 9;
    private static final int JAVA = 10;
    private static final int ROI = 11;
    private static final int TEXT = 12;
    private static String defaultDirectory = null;
    private boolean showErrorDialog = false;

    public void openImage() {
        OpenDialog openDialog = new OpenDialog("Open...", "");
        String string = openDialog.getDirectory();
        String string2 = openDialog.getFileName();
        if (string2 == null) {
            return;
        }
        IJ.showStatus("Opening: " + string + string2);
        this.showErrorDialog = true;
        ImagePlus imagePlus = this.openImage(string, string2);
        if (imagePlus != null) {
            imagePlus.show();
        }
    }

    public ImagePlus openImage(String string, String string2) {
        String string3 = string + string2;
        switch (this.getFileType(string3, string2)) {
            case 1: {
                ImagePlus imagePlus = this.openTiff(string, string2);
                return imagePlus;
            }
            case 2: {
                ImagePlus imagePlus = (ImagePlus)IJ.runPlugIn("ij.plugin.DICOM", string3);
                if (imagePlus.getWidth() != 0) {
                    return imagePlus;
                }
                return null;
            }
            case 3: {
                ImagePlus imagePlus = (ImagePlus)IJ.runPlugIn("ij.plugin.FITS", string3);
                if (imagePlus.getWidth() != 0) {
                    return imagePlus;
                }
                return null;
            }
            case 4: {
                ImagePlus imagePlus = (ImagePlus)IJ.runPlugIn("ij.plugin.PGM_Reader", string3);
                if (imagePlus.getWidth() != 0) {
                    return imagePlus;
                }
                return null;
            }
            case 5: 
            case 6: {
                ImagePlus imagePlus = this.openJpegOrGif(string, string2);
                if (imagePlus != null && imagePlus.getWidth() != 0) {
                    return imagePlus;
                }
                return null;
            }
            case 7: {
                ImagePlus imagePlus = (ImagePlus)IJ.runPlugIn("ij.plugin.LutLoader", string3);
                if (imagePlus.getWidth() != 0) {
                    return imagePlus;
                }
                return null;
            }
            case 8: {
                ImagePlus imagePlus = (ImagePlus)IJ.runPlugIn("ij.plugin.BMP", string3);
                if (imagePlus.getWidth() != 0) {
                    return imagePlus;
                }
                return null;
            }
            case 9: {
                ImagePlus imagePlus = (ImagePlus)IJ.runPlugIn("ij.plugin.Zip_Reader", string3);
                if (imagePlus.getWidth() != 0) {
                    return imagePlus;
                }
                return null;
            }
            case 11: {
                IJ.runPlugIn("ij.plugin.RoiReader", string3);
                return null;
            }
            case 10: 
            case 12: {
                File file = new File(string3);
                if (file.length() < 28000L) {
                    Editor editor = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "");
                    if (editor != null) {
                        editor.open(string, string2);
                    }
                } else {
                    new TextWindow(string3, 400, 450);
                }
                return null;
            }
            case 0: {
                if (this.showErrorDialog) {
                    IJ.showMessage("Open...", "This file does not appear to be in TIFF, JPEG, \n GIF, BMP, DICOM, FITS, PGM, ZIP or LUT format.");
                }
                return null;
            }
        }
        return null;
    }

    public ImagePlus openURL(String string) {
        try {
            String string2 = "";
            int n = string.lastIndexOf(47);
            if (n == -1) {
                n = string.lastIndexOf(92);
            }
            if (n <= 0) {
                throw new MalformedURLException("Invalid URL: " + string);
            }
            string2 = string.substring(n + 1);
            URL uRL = new URL(string);
            IJ.showStatus("" + string);
            ImagePlus imagePlus = null;
            imagePlus = string.endsWith(".tif") || string.endsWith(".TIF") ? this.openTiff(uRL.openStream(), string2) : (string.endsWith(".zip") ? this.openZip(uRL) : this.openJpegOrGifUsingURL(string2, uRL));
            IJ.showStatus("");
            return imagePlus;
        }
        catch (Exception exception) {
            IJ.showMessage("" + exception);
            return null;
        }
    }

    ImagePlus openZip(URL uRL) throws IOException {
        int n;
        IJ.showProgress(0.01);
        URLConnection uRLConnection = uRL.openConnection();
        int n2 = uRLConnection.getContentLength();
        n2 *= 2;
        InputStream inputStream = uRLConnection.getInputStream();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        if (zipEntry == null) {
            return null;
        }
        String string = zipEntry.getName();
        if (!string.endsWith(".tif")) {
            throw new IOException("This ZIP archive does not appear to contain a TIFF file");
        }
        int n3 = 0;
        boolean bl = false;
        while ((n = zipInputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
            IJ.showProgress((double)((n3 += n) % n2) / (double)n2);
        }
        zipInputStream.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        IJ.showProgress(1.0);
        return this.openTiff(new ByteArrayInputStream(byArray2), string);
    }

    ImagePlus openJpegOrGifUsingURL(String string, URL uRL) {
        if (uRL == null) {
            return null;
        }
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        if (image != null) {
            ImagePlus imagePlus = new ImagePlus(string, image);
            return imagePlus;
        }
        return null;
    }

    ImagePlus openJpegOrGif(String string, String string2) {
        ImagePlus imagePlus = null;
        Image image = Toolkit.getDefaultToolkit().getImage(string + string2);
        if (image != null) {
            imagePlus = new ImagePlus(string2, image);
            if (imagePlus.getType() == 4) {
                Opener.convertGrayJpegTo8Bits(imagePlus);
            }
            FileInfo fileInfo = new FileInfo();
            fileInfo.fileFormat = FileInfo.GIF_OR_JPG;
            fileInfo.fileName = string2;
            fileInfo.directory = string;
            imagePlus.setFileInfo(fileInfo);
        }
        return imagePlus;
    }

    public static void convertGrayJpegTo8Bits(ImagePlus imagePlus) {
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        int n = imageProcessor.getWidth();
        int n2 = imageProcessor.getHeight();
        int[] nArray = (int[])imageProcessor.getPixels();
        int n3 = 0;
        while (n3 < n2 - 8) {
            int n4 = n3 * n;
            int n5 = 0;
            while (n5 < n - 8) {
                int n6 = nArray[n4 + n5];
                int n7 = (n6 & 0xFF0000) >> 16;
                int n8 = (n6 & 0xFF00) >> 8;
                int n9 = n6 & 0xFF;
                if (n7 != n8 || n8 != n9) {
                    return;
                }
                ++n5;
            }
            ++n3;
        }
        IJ.showStatus("Converting to 8-bits");
        new ImageConverter(imagePlus).convertToGray8();
    }

    boolean allSameSizeAndType(FileInfo[] fileInfoArray) {
        boolean bl = true;
        boolean bl2 = true;
        int n = fileInfoArray[0].offset;
        int n2 = fileInfoArray[0].width * fileInfoArray[0].height * fileInfoArray[0].getBytesPerPixel();
        int n3 = 1;
        while (n3 < fileInfoArray.length) {
            bl &= fileInfoArray[n3].fileType == fileInfoArray[0].fileType && fileInfoArray[n3].width == fileInfoArray[0].width && fileInfoArray[n3].height == fileInfoArray[0].height;
            bl2 &= fileInfoArray[n3].offset == n + n3 * n2;
            ++n3;
        }
        if (bl2) {
            fileInfoArray[0].nImages = fileInfoArray.length;
        }
        if (IJ.debugMode) {
            IJ.write("  sameSizeAndType: " + bl);
            IJ.write("  contiguous: " + bl2);
        }
        return bl;
    }

    public ImagePlus openTiffStack(FileInfo[] fileInfoArray) {
        Object object;
        if (fileInfoArray.length > 1 && !this.allSameSizeAndType(fileInfoArray)) {
            return null;
        }
        FileInfo fileInfo = fileInfoArray[0];
        if (fileInfo.nImages > 1) {
            return new FileOpener(fileInfo).open(false);
        }
        ColorModel colorModel = FileOpener.createColorModel(fileInfo);
        ImageStack imageStack = new ImageStack(fileInfo.width, fileInfo.height, colorModel);
        int n = fileInfo.offset;
        int n2 = fileInfo.width * fileInfo.height * fileInfo.getBytesPerPixel();
        int n3 = 0;
        try {
            object = FileOpener.createInputStream(fileInfo);
            ImageReader imageReader = new ImageReader(fileInfo);
            int n4 = 0;
            while (n4 < fileInfoArray.length) {
                IJ.showStatus("Reading: " + (n4 + 1) + "/" + fileInfoArray.length);
                Object object2 = imageReader.readPixels((InputStream)object, n);
                if (object2 == null) break;
                if (n4 < fileInfoArray.length - 1 && (n = fileInfoArray[n4 + 1].offset - (n3 += n2 + n)) < 0) {
                    throw new IOException("Images are not in order");
                }
                if (fileInfo.fileType == FileInfo.GRAY16_UNSIGNED) {
                    imageStack.addUnsignedShortSlice(null, object2);
                } else {
                    imageStack.addSlice(null, object2);
                }
                IJ.showProgress((double)n4 / (double)fileInfoArray.length);
                ++n4;
            }
            ((InputStream)object).close();
        }
        catch (Exception exception) {
            IJ.write("" + exception);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IJ.outOfMemory(fileInfo.fileName);
            imageStack.deleteLastSlice();
            imageStack.deleteLastSlice();
        }
        IJ.showProgress(1.0);
        if (imageStack.getSize() == 0) {
            return null;
        }
        if (fileInfo.whiteIsZero) {
            new StackProcessor(imageStack, imageStack.getProcessor(1)).invert();
        }
        object = new ImagePlus(fileInfo.fileName, imageStack);
        FileOpener.setResolution(fileInfo, (ImagePlus)object);
        ((ImagePlus)object).setFileInfo(fileInfo);
        IJ.showProgress(1.0);
        return object;
    }

    public ImagePlus openTiff(String string, String string2) {
        TiffDecoder tiffDecoder = new TiffDecoder(string, string2);
        if (IJ.debugMode) {
            tiffDecoder.enableDebugging();
        }
        FileInfo[] fileInfoArray = null;
        try {
            fileInfoArray = tiffDecoder.getTiffInfo();
        }
        catch (IOException iOException) {
            IJ.showMessage("TiffDecoder", iOException.getMessage());
            return null;
        }
        if (fileInfoArray == null) {
            return null;
        }
        return this.openTiff2(fileInfoArray);
    }

    public ImagePlus openTiff(InputStream inputStream, String string) {
        FileInfo[] fileInfoArray = null;
        try {
            TiffDecoder tiffDecoder = new TiffDecoder(inputStream, string);
            if (IJ.debugMode) {
                tiffDecoder.enableDebugging();
            }
            fileInfoArray = tiffDecoder.getTiffInfo();
        }
        catch (FileNotFoundException fileNotFoundException) {
            IJ.showMessage("TiffDecoder", "File not found: " + fileNotFoundException.getMessage());
            return null;
        }
        catch (Exception exception) {
            IJ.showMessage("TiffDecoder", "" + exception);
            return null;
        }
        return this.openTiff2(fileInfoArray);
    }

    ImagePlus openTiff2(FileInfo[] fileInfoArray) {
        if (fileInfoArray == null) {
            return null;
        }
        ImagePlus imagePlus = null;
        if (IJ.debugMode) {
            IJ.write(fileInfoArray[0].info);
        }
        if (fileInfoArray.length > 1 && (imagePlus = this.openTiffStack(fileInfoArray)) != null) {
            return imagePlus;
        }
        FileOpener fileOpener = new FileOpener(fileInfoArray[0]);
        imagePlus = fileOpener.open(false);
        IJ.showStatus("");
        return imagePlus;
    }

    int getFileType(String string, String string2) {
        byte[] byArray = new byte[132];
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ((InputStream)fileInputStream).read(byArray, 0, 132);
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            return 0;
        }
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        int n3 = byArray[2] & 0xFF;
        int n4 = byArray[3] & 0xFF;
        if (n == 73 && n2 == 73 && n3 == 42 && n4 == 0) {
            return 1;
        }
        if (n == 77 && n2 == 77 && n3 == 0 && n4 == 42) {
            return 1;
        }
        if (n == 255 && n2 == 216 && n3 == 255) {
            return 5;
        }
        if (n == 71 && n2 == 73 && n3 == 70 && n4 == 56) {
            return 6;
        }
        if (byArray[128] == 68 && byArray[129] == 73 && byArray[130] == 67 && byArray[131] == 77) {
            return 2;
        }
        if (n == 8 && n2 == 0 && n4 == 0) {
            return 2;
        }
        if (n == 83 && n2 == 73 && n3 == 77 && n4 == 80) {
            return 3;
        }
        if (!(n != 80 || n2 != 50 && n2 != 53 || n3 != 10 && n3 != 13 && n3 != 32 && n3 != 9)) {
            return 4;
        }
        if ((string2 = string2.toLowerCase()).endsWith(".lut")) {
            return 7;
        }
        if (n == 66 && n2 == 77 && string2.endsWith(".bmp")) {
            return 8;
        }
        if (string2.endsWith(".zip")) {
            return 9;
        }
        if (string2.endsWith(".java")) {
            return 10;
        }
        if (n == 73 && n2 == 111) {
            return 11;
        }
        if (string2.endsWith(".txt") || n >= 32 && n <= 126 && n2 >= 32 && n2 <= 126 && n3 >= 32 && n3 <= 126 && n4 >= 32 && n4 <= 126 && byArray[8] >= 32 && byArray[8] <= 126) {
            return 12;
        }
        return 0;
    }
}

