/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.io.FileInfo;
import java.io.IOException;
import java.io.OutputStream;

public class ImageWriter {
    private FileInfo fi;
    private boolean showProgressBar = true;

    private void showProgress(double d) {
        if (this.showProgressBar) {
            IJ.showProgress(d);
        }
    }

    void write8BitImage(OutputStream outputStream, byte[] byArray) throws IOException {
        int n = 0;
        int n2 = this.fi.width * this.fi.height;
        int n3 = 8192;
        while (n < n2) {
            if (n + n3 > n2) {
                n3 = n2 - n;
            }
            outputStream.write(byArray, n, n3);
            this.showProgress((double)(n += n3) / (double)n2);
        }
    }

    void write8BitStack(OutputStream outputStream, Object[] objectArray) throws IOException {
        this.showProgressBar = false;
        int n = 0;
        while (n < this.fi.nImages) {
            IJ.showStatus("Writing: " + (n + 1) + "/" + this.fi.nImages);
            this.write8BitImage(outputStream, (byte[])objectArray[n]);
            IJ.showProgress((double)(n + 1) / (double)this.fi.nImages);
            ++n;
        }
    }

    void write16BitImage(OutputStream outputStream, short[] sArray) throws IOException {
        int n = 0;
        int n2 = this.fi.width * this.fi.height * 2;
        int n3 = 8192;
        byte[] byArray = new byte[n3];
        while (n < n2) {
            short s;
            int n4;
            if (n + n3 > n2) {
                n3 = n2 - n;
            }
            int n5 = n / 2;
            if (this.fi.intelByteOrder) {
                n4 = 0;
                while (n4 < n3) {
                    s = sArray[n5];
                    byArray[n4] = (byte)s;
                    byArray[n4 + 1] = (byte)(s >>> 8);
                    ++n5;
                    n4 += 2;
                }
            } else {
                n4 = 0;
                while (n4 < n3) {
                    s = sArray[n5];
                    byArray[n4] = (byte)(s >>> 8);
                    byArray[n4 + 1] = (byte)s;
                    ++n5;
                    n4 += 2;
                }
            }
            outputStream.write(byArray, 0, n3);
            this.showProgress((double)(n += n3) / (double)n2);
        }
    }

    void write16BitStack(OutputStream outputStream, Object[] objectArray) throws IOException {
        this.showProgressBar = false;
        int n = 0;
        while (n < this.fi.nImages) {
            IJ.showStatus("Writing: " + (n + 1) + "/" + this.fi.nImages);
            this.write16BitImage(outputStream, (short[])objectArray[n]);
            IJ.showProgress((double)(n + 1) / (double)this.fi.nImages);
            ++n;
        }
    }

    void writeFloatImage(OutputStream outputStream, float[] fArray) throws IOException {
        int n = 0;
        int n2 = this.fi.width * this.fi.height * 4;
        int n3 = 8192;
        byte[] byArray = new byte[n3];
        while (n < n2) {
            int n4;
            int n5;
            if (n + n3 > n2) {
                n3 = n2 - n;
            }
            int n6 = n / 4;
            if (this.fi.intelByteOrder) {
                n5 = 0;
                while (n5 < n3) {
                    n4 = Float.floatToIntBits(fArray[n6]);
                    byArray[n5] = (byte)n4;
                    byArray[n5 + 1] = (byte)(n4 >> 8);
                    byArray[n5 + 2] = (byte)(n4 >> 16);
                    byArray[n5 + 3] = (byte)(n4 >> 24);
                    ++n6;
                    n5 += 4;
                }
            } else {
                n5 = 0;
                while (n5 < n3) {
                    n4 = Float.floatToIntBits(fArray[n6]);
                    byArray[n5] = (byte)(n4 >> 24);
                    byArray[n5 + 1] = (byte)(n4 >> 16);
                    byArray[n5 + 2] = (byte)(n4 >> 8);
                    byArray[n5 + 3] = (byte)n4;
                    ++n6;
                    n5 += 4;
                }
            }
            outputStream.write(byArray, 0, n3);
            this.showProgress((double)(n += n3) / (double)n2);
        }
    }

    void writeFloatStack(OutputStream outputStream, Object[] objectArray) throws IOException {
        this.showProgressBar = false;
        int n = 0;
        while (n < this.fi.nImages) {
            IJ.showStatus("Writing: " + (n + 1) + "/" + this.fi.nImages);
            this.writeFloatImage(outputStream, (float[])objectArray[n]);
            IJ.showProgress((double)(n + 1) / (double)this.fi.nImages);
            ++n;
        }
    }

    void writeRGBImage(OutputStream outputStream, int[] nArray) throws IOException {
        int n = 0;
        int n2 = this.fi.width * this.fi.height * 3;
        int n3 = this.fi.width * 24;
        byte[] byArray = new byte[n3];
        while (n < n2) {
            if (n + n3 > n2) {
                n3 = n2 - n;
            }
            int n4 = n / 3;
            int n5 = 0;
            while (n5 < n3) {
                byArray[n5] = (byte)(nArray[n4] >> 16);
                byArray[n5 + 1] = (byte)(nArray[n4] >> 8);
                byArray[n5 + 2] = (byte)nArray[n4];
                ++n4;
                n5 += 3;
            }
            outputStream.write(byArray, 0, n3);
            this.showProgress((double)(n += n3) / (double)n2);
        }
    }

    void writeRGBStack(OutputStream outputStream, Object[] objectArray) throws IOException {
        this.showProgressBar = false;
        int n = 0;
        while (n < this.fi.nImages) {
            IJ.showStatus("Writing: " + (n + 1) + "/" + this.fi.nImages);
            this.writeRGBImage(outputStream, (int[])objectArray[n]);
            IJ.showProgress((double)(n + 1) / (double)this.fi.nImages);
            ++n;
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.fi.nImages > 1 && !(this.fi.pixels instanceof Object[])) {
            throw new IOException("Stack expected");
        }
        switch (this.fi.fileType) {
            case 0: 
            case 5: {
                if (this.fi.nImages > 1) {
                    this.write8BitStack(outputStream, (Object[])this.fi.pixels);
                    break;
                }
                this.write8BitImage(outputStream, (byte[])this.fi.pixels);
                break;
            }
            case 1: 
            case 2: {
                if (this.fi.nImages > 1) {
                    this.write16BitStack(outputStream, (Object[])this.fi.pixels);
                    break;
                }
                this.write16BitImage(outputStream, (short[])this.fi.pixels);
                break;
            }
            case 4: {
                if (this.fi.nImages > 1) {
                    this.writeFloatStack(outputStream, (Object[])this.fi.pixels);
                    break;
                }
                this.writeFloatImage(outputStream, (float[])this.fi.pixels);
                break;
            }
            case 6: {
                if (this.fi.nImages > 1) {
                    this.writeRGBStack(outputStream, (Object[])this.fi.pixels);
                    break;
                }
                this.writeRGBImage(outputStream, (int[])this.fi.pixels);
                break;
            }
        }
    }

    public ImageWriter(FileInfo fileInfo) {
        this.fi = fileInfo;
    }
}

