/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.io.FileInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class ImageReader {
    private FileInfo fi;
    private int width;
    private int height;
    private int skipCount;
    private int bytesPerPixel;
    private int bufferSize;
    private int byteCount;
    private int nPixels;
    private boolean showProgressBar = true;
    private int eofErrorCount;

    void eofError() {
        if (this.eofErrorCount++ == 1) {
            IJ.write("<<End of file exceeded>>");
        }
    }

    byte[] read8bitImage(InputStream inputStream) throws IOException {
        int n = 0;
        byte[] byArray = new byte[this.nPixels];
        while (n < this.byteCount) {
            int n2 = n + this.bufferSize > this.nPixels ? this.nPixels - n : this.bufferSize;
            int n3 = inputStream.read(byArray, n, n2);
            if (n3 == -1) {
                this.eofError();
                break;
            }
            this.showProgress((double)(n += n3) / (double)this.byteCount);
        }
        return byArray;
    }

    private void showProgress(double d) {
        if (this.showProgressBar) {
            IJ.showProgress(d);
        }
    }

    short[] read16bitImage(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[this.bufferSize];
        short[] sArray = new short[this.nPixels];
        int n = 0;
        int n2 = 0;
        while (n < this.byteCount) {
            int n3;
            int n4;
            if (n + this.bufferSize > this.byteCount) {
                this.bufferSize = this.byteCount - n;
            }
            int n5 = 0;
            while (n5 < this.bufferSize) {
                int n6 = inputStream.read(byArray, n5, this.bufferSize - n5);
                if (n6 == -1) {
                    this.eofError();
                    return sArray;
                }
                n5 += n6;
            }
            this.showProgress((double)(n += this.bufferSize) / (double)this.byteCount);
            int n7 = this.bufferSize / this.bytesPerPixel;
            int n8 = 0;
            if (this.fi.intelByteOrder) {
                n4 = n2;
                while (n4 < n2 + n7) {
                    n3 = (byArray[n8 + 1] & 0xFF) << 8 | byArray[n8] & 0xFF;
                    sArray[n4] = (short)n3;
                    n8 += 2;
                    ++n4;
                }
            } else {
                n4 = n2;
                while (n4 < n2 + n7) {
                    n3 = (byArray[n8] & 0xFF) << 8 | byArray[n8 + 1] & 0xFF;
                    sArray[n4] = (short)n3;
                    n8 += 2;
                    ++n4;
                }
            }
            n2 += n7;
        }
        return sArray;
    }

    float[] read32bitImage(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[this.bufferSize];
        float[] fArray = new float[this.nPixels];
        int n = 0;
        int n2 = 0;
        while (n < this.byteCount) {
            int n3;
            int n4;
            if (n + this.bufferSize > this.byteCount) {
                this.bufferSize = this.byteCount - n;
            }
            int n5 = 0;
            while (n5 < this.bufferSize) {
                int n6 = inputStream.read(byArray, n5, this.bufferSize - n5);
                if (n6 == -1) {
                    this.eofError();
                    return fArray;
                }
                n5 += n6;
            }
            this.showProgress((double)(n += this.bufferSize) / (double)this.byteCount);
            int n7 = this.bufferSize / this.bytesPerPixel;
            int n8 = 0;
            if (this.fi.intelByteOrder) {
                n4 = n2;
                while (n4 < n2 + n7) {
                    n3 = (byArray[n8 + 3] & 0xFF) << 24 | (byArray[n8 + 2] & 0xFF) << 16 | (byArray[n8 + 1] & 0xFF) << 8 | byArray[n8] & 0xFF;
                    fArray[n4] = this.fi.fileType == 4 ? Float.intBitsToFloat(n3) : (float)n3;
                    n8 += 4;
                    ++n4;
                }
            } else {
                n4 = n2;
                while (n4 < n2 + n7) {
                    n3 = (byArray[n8] & 0xFF) << 24 | (byArray[n8 + 1] & 0xFF) << 16 | (byArray[n8 + 2] & 0xFF) << 8 | byArray[n8 + 3] & 0xFF;
                    fArray[n4] = this.fi.fileType == 4 ? Float.intBitsToFloat(n3) : (float)n3;
                    n8 += 4;
                    ++n4;
                }
            }
            n2 += n7;
        }
        return fArray;
    }

    int[] readChunkyRGB(InputStream inputStream) throws IOException {
        this.bufferSize = 24 * this.width;
        byte[] byArray = new byte[this.bufferSize];
        int[] nArray = new int[this.nPixels];
        int n = 0;
        int n2 = 0;
        while (n < this.byteCount) {
            if (n + this.bufferSize > this.byteCount) {
                this.bufferSize = this.byteCount - n;
            }
            int n3 = 0;
            while (n3 < this.bufferSize) {
                int n4 = inputStream.read(byArray, n3, this.bufferSize - n3);
                if (n4 == -1) {
                    this.eofError();
                    return nArray;
                }
                n3 += n4;
            }
            this.showProgress((double)(n += this.bufferSize) / (double)this.byteCount);
            int n5 = this.bufferSize / this.bytesPerPixel;
            int n6 = 0;
            int n7 = n2;
            while (n7 < n2 + n5) {
                int n8 = byArray[n6++] & 0xFF;
                int n9 = byArray[n6++] & 0xFF;
                int n10 = byArray[n6++] & 0xFF;
                nArray[n7] = 0xFF000000 | n8 << 16 | n9 << 8 | n10;
                ++n7;
            }
            n2 += n5;
        }
        return nArray;
    }

    int[] readPlanarRGB(InputStream inputStream) throws IOException {
        int n = this.nPixels;
        byte[] byArray = new byte[n];
        int[] nArray = new int[this.nPixels];
        int n2 = 0;
        this.showProgress(0.12);
        int n3 = inputStream.read(byArray, 0, n);
        if (n3 == -1) {
            this.eofError();
            return nArray;
        }
        n2 += n3;
        int n4 = 0;
        while (n4 < n) {
            int n5 = byArray[n4] & 0xFF;
            nArray[n4] = 0xFF000000 | n5 << 16;
            ++n4;
        }
        this.showProgress(0.37);
        n3 = inputStream.read(byArray, 0, n);
        if (n3 == -1) {
            this.eofError();
            return nArray;
        }
        n2 += n3;
        n4 = 0;
        while (n4 < n) {
            int n6 = byArray[n4] & 0xFF;
            int n7 = n4++;
            nArray[n7] = nArray[n7] | n6 << 8;
        }
        this.showProgress(0.62);
        n3 = inputStream.read(byArray, 0, n);
        if (n3 == -1) {
            this.eofError();
            return nArray;
        }
        n2 += n3;
        n4 = 0;
        while (n4 < n) {
            int n8 = byArray[n4] & 0xFF;
            int n9 = n4++;
            nArray[n9] = nArray[n9] | n8;
        }
        this.showProgress(0.87);
        return nArray;
    }

    void skip(InputStream inputStream) throws IOException {
        if (this.skipCount > 0) {
            int n = 0;
            int n2 = 0;
            while (n < this.skipCount) {
                long l = inputStream.skip(this.skipCount - n);
                if (l == -1L || ++n2 > 5) break;
                n = (int)((long)n + l);
            }
        }
        this.byteCount = this.width * this.height * this.bytesPerPixel;
        this.nPixels = this.width * this.height;
        this.bufferSize = this.byteCount / 25;
        this.bufferSize = this.bufferSize < 8192 ? 8192 : this.bufferSize / 8192 * 8192;
    }

    public Object readPixels(InputStream inputStream) {
        try {
            switch (this.fi.fileType) {
                case 0: 
                case 5: {
                    this.bytesPerPixel = 1;
                    this.skip(inputStream);
                    return this.read8bitImage(inputStream);
                }
                case 1: {
                    this.bytesPerPixel = 2;
                    this.skip(inputStream);
                    short[] sArray = this.read16bitImage(inputStream);
                    this.convertToUnsigned(sArray);
                    return sArray;
                }
                case 2: {
                    this.bytesPerPixel = 2;
                    this.skip(inputStream);
                    return this.read16bitImage(inputStream);
                }
                case 3: 
                case 4: {
                    this.bytesPerPixel = 4;
                    this.skip(inputStream);
                    return this.read32bitImage(inputStream);
                }
                case 6: {
                    this.bytesPerPixel = 3;
                    this.skip(inputStream);
                    return this.readChunkyRGB(inputStream);
                }
                case 7: {
                    this.bytesPerPixel = 3;
                    this.skip(inputStream);
                    return this.readPlanarRGB(inputStream);
                }
            }
            return null;
        }
        catch (IOException iOException) {
            IJ.write("" + iOException);
            return null;
        }
    }

    public Object readPixels(InputStream inputStream, int n) {
        this.skipCount = n;
        this.showProgressBar = false;
        Object object = this.readPixels(inputStream);
        if (this.eofErrorCount > 0) {
            return null;
        }
        return object;
    }

    public Object readPixels(String string) {
        InputStream inputStream;
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            IJ.write("" + malformedURLException);
            return null;
        }
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            IJ.write("" + iOException);
            return null;
        }
        return this.readPixels(inputStream);
    }

    void convertToUnsigned(short[] sArray) {
        short s;
        int s2 = Integer.MAX_VALUE;
        int n = 0;
        while (n < sArray.length) {
            short s3 = sArray[n];
            if (s3 < s) {
                s = s3;
            }
            ++n;
        }
        if (s < 0 || this.fi.fileFormat == 4) {
            n = 0;
            while (n < sArray.length) {
                sArray[n] = (short)(sArray[n] + 32768);
                ++n;
            }
        } else {
            this.fi.fileType = 2;
        }
    }

    public ImageReader(FileInfo fileInfo) {
        this.fi = fileInfo;
        this.width = fileInfo.width;
        this.height = fileInfo.height;
        this.skipCount = fileInfo.offset;
    }
}

