/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.io.FileInfo;
import ij.io.GifEncoder;
import ij.io.ImageWriter;
import ij.io.JpegEncoder;
import ij.io.SaveDialog;
import ij.io.TextEncoder;
import ij.io.TiffEncoder;
import ij.measure.Calibration;
import ij.plugin.filter.Analyzer;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileSaver {
    private static String defaultDirectory = null;
    private ImagePlus imp;
    private String name;
    private String directory;

    public boolean save() {
        return this.saveAsTiff();
    }

    String getPath(String string, String string2) {
        this.name = this.imp.getTitle();
        SaveDialog saveDialog = new SaveDialog("Save as " + string, this.name, string2);
        this.name = saveDialog.getFileName();
        if (this.name == null) {
            return null;
        }
        this.directory = saveDialog.getDirectory();
        this.imp.startTiming();
        return this.directory + this.name;
    }

    public boolean saveAsTiff() {
        String string = this.getPath("TIFF", ".tif");
        if (string == null) {
            return false;
        }
        if (this.imp.getStackSize() == 1) {
            return this.saveAsTiff(string);
        }
        return this.saveAsTiffStack(string);
    }

    public boolean saveAsTiff(String string) {
        FileInfo fileInfo = this.imp.getFileInfo();
        fileInfo.nImages = 1;
        try {
            TiffEncoder tiffEncoder = new TiffEncoder(fileInfo);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            tiffEncoder.write(dataOutputStream);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            this.showErrorMessage(iOException);
            return false;
        }
        this.updateImp(fileInfo, FileInfo.TIFF);
        return true;
    }

    public boolean saveAsTiffStack(String string) {
        FileInfo fileInfo = this.imp.getFileInfo();
        if (fileInfo.nImages == 1) {
            IJ.write("This is not a stack");
            return false;
        }
        try {
            TiffEncoder tiffEncoder = new TiffEncoder(fileInfo);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            tiffEncoder.write(dataOutputStream);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            this.showErrorMessage(iOException);
            return false;
        }
        this.updateImp(fileInfo, FileInfo.TIFF);
        return true;
    }

    public boolean saveAsZip() {
        String string = this.getPath("TIFF/ZIP", ".zip");
        if (string == null) {
            return false;
        }
        return this.saveAsZip(string);
    }

    public boolean saveAsZip(String string) {
        FileInfo fileInfo = this.imp.getFileInfo();
        if (!string.endsWith(".zip")) {
            string = string + ".zip";
        }
        if (this.name == null) {
            this.name = this.imp.getTitle();
        }
        if (this.name.endsWith(".zip")) {
            this.name = this.name.substring(0, this.name.length() - 4);
        }
        if (!this.name.endsWith(".tif")) {
            this.name = this.name + ".tif";
        }
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string));
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(zipOutputStream));
            zipOutputStream.putNextEntry(new ZipEntry(this.name));
            TiffEncoder tiffEncoder = new TiffEncoder(fileInfo);
            tiffEncoder.write(dataOutputStream);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            this.showErrorMessage(iOException);
            return false;
        }
        this.updateImp(fileInfo, FileInfo.TIFF);
        return true;
    }

    public static boolean okForGif(ImagePlus imagePlus) {
        int n = imagePlus.getType();
        if (n == 4 || n == 1 || n == 2) {
            IJ.error("To save as Gif, the image must be \"8-bit\" or \"8-bit Color\".");
            return false;
        }
        return true;
    }

    public boolean saveAsGif() {
        if (!FileSaver.okForGif(this.imp)) {
            return false;
        }
        String string = this.getPath("GIF", ".gif");
        if (string == null) {
            return false;
        }
        return this.saveAsGif(string);
    }

    public boolean saveAsGif(String string) {
        if (!FileSaver.okForGif(this.imp)) {
            return false;
        }
        FileInfo fileInfo = this.imp.getFileInfo();
        try {
            GifEncoder gifEncoder = new GifEncoder(fileInfo.width, fileInfo.height, (byte[])fileInfo.pixels, fileInfo.reds, fileInfo.greens, fileInfo.blues);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            gifEncoder.write(bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            this.showErrorMessage(iOException);
            return false;
        }
        this.updateImp(fileInfo, FileInfo.GIF_OR_JPG);
        return true;
    }

    public static boolean okForJpeg(ImagePlus imagePlus) {
        int n = imagePlus.getType();
        if (n == 1 || n == 2) {
            IJ.error("16 and 32-bit grayscale images cannot be saved as JPEG.");
            return false;
        }
        return true;
    }

    public boolean saveAsJpeg() {
        if (!FileSaver.okForJpeg(this.imp)) {
            return false;
        }
        String string = this.getPath("JPEG", ".jpg");
        if (string == null) {
            return false;
        }
        return this.saveAsJpeg(string);
    }

    public boolean saveAsJpeg(String string) {
        if (!FileSaver.okForJpeg(this.imp)) {
            return false;
        }
        FileInfo fileInfo = this.imp.getFileInfo();
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            JpegEncoder jpegEncoder = new JpegEncoder(this.imp.getImage(), JpegEncoder.getQuality(), bufferedOutputStream);
            jpegEncoder.Compress();
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            this.showErrorMessage(iOException);
            return false;
        }
        this.updateImp(fileInfo, FileInfo.GIF_OR_JPG);
        return true;
    }

    public boolean saveAsRaw() {
        String string = this.getPath("Raw", ".raw");
        if (string == null) {
            return false;
        }
        if (this.imp.getStackSize() == 1) {
            return this.saveAsRaw(string);
        }
        return this.saveAsRawStack(string);
    }

    public boolean saveAsRaw(String string) {
        FileInfo fileInfo = this.imp.getFileInfo();
        fileInfo.nImages = 1;
        try {
            ImageWriter imageWriter = new ImageWriter(fileInfo);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            imageWriter.write(bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            this.showErrorMessage(iOException);
            return false;
        }
        this.updateImp(fileInfo, FileInfo.RAW);
        return true;
    }

    public boolean saveAsRawStack(String string) {
        FileInfo fileInfo = this.imp.getFileInfo();
        if (fileInfo.nImages == 1) {
            IJ.write("This is not a stack");
            return false;
        }
        try {
            ImageWriter imageWriter = new ImageWriter(fileInfo);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            imageWriter.write(bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            this.showErrorMessage(iOException);
            return false;
        }
        this.updateImp(fileInfo, FileInfo.RAW);
        return true;
    }

    public boolean saveAsText() {
        String string = this.getPath("Text", ".txt");
        if (string == null) {
            return false;
        }
        return this.saveAsText(string);
    }

    public boolean saveAsText(String string) {
        try {
            Calibration calibration = this.imp.getCalibration();
            int n = Analyzer.getPrecision();
            TextEncoder textEncoder = new TextEncoder(this.imp.getProcessor(), calibration, n);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            textEncoder.write(dataOutputStream);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            this.showErrorMessage(iOException);
            return false;
        }
        return true;
    }

    public boolean saveAsLut() {
        if (this.imp.getType() == 4) {
            IJ.error("RGB Images do not have a LUT.");
            return false;
        }
        String string = this.getPath("LUT", ".lut");
        if (string == null) {
            return false;
        }
        return this.saveAsLut(string);
    }

    public boolean saveAsLut(String string) {
        LookUpTable lookUpTable = this.imp.createLut();
        int n = lookUpTable.getMapSize();
        if (n == 0) {
            IJ.error("RGB Images do not have a LUT.");
            return false;
        }
        if (n < 256) {
            IJ.error("Cannot save LUTs with less than 256 entries.");
            return false;
        }
        byte[] byArray = lookUpTable.getReds();
        byte[] byArray2 = lookUpTable.getGreens();
        byte[] byArray3 = lookUpTable.getBlues();
        byte[] byArray4 = new byte[768];
        int n2 = 0;
        while (n2 < 256) {
            byArray4[n2] = byArray[n2];
            byArray4[n2 + 256] = byArray2[n2];
            byArray4[n2 + 512] = byArray3[n2];
            ++n2;
        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.width = 768;
        fileInfo.height = 1;
        fileInfo.pixels = byArray4;
        try {
            ImageWriter imageWriter = new ImageWriter(fileInfo);
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            imageWriter.write(fileOutputStream);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            this.showErrorMessage(iOException);
            return false;
        }
        return true;
    }

    private void updateImp(FileInfo fileInfo, int n) {
        this.imp.changes = false;
        if (this.name != null) {
            fileInfo.fileFormat = n;
            fileInfo.fileName = this.name;
            fileInfo.directory = this.directory;
            if (n == FileInfo.TIFF) {
                fileInfo.offset = 768;
            }
            this.imp.setTitle(this.name);
            this.imp.setFileInfo(fileInfo);
        }
    }

    void showErrorMessage(IOException iOException) {
        IJ.error("An error occured writing the file.\n \n" + iOException);
    }

    public FileSaver(ImagePlus imagePlus) {
        this.imp = imagePlus;
    }
}

