/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.gui.ProgressBar;
import ij.io.FileInfo;
import ij.io.ImageReader;
import ij.io.Opener;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ShortProcessor;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class FileOpener {
    private FileInfo fi;
    private int width;
    private int height;

    public void open() {
        this.open(true);
    }

    public ImagePlus open(boolean bl) {
        ImagePlus imagePlus = null;
        Object var5_3 = null;
        ColorModel colorModel = FileOpener.createColorModel(this.fi);
        if (this.fi.nImages > 1) {
            return this.openStack(colorModel, bl);
        }
        switch (this.fi.fileType) {
            case 0: 
            case 5: {
                Object object = this.readPixels(this.fi);
                if (object == null) {
                    return null;
                }
                ByteProcessor byteProcessor = new ByteProcessor(this.width, this.height, (byte[])object, colorModel);
                imagePlus = new ImagePlus(this.fi.fileName, byteProcessor);
                break;
            }
            case 1: 
            case 2: {
                Object object = this.readPixels(this.fi);
                if (object == null) {
                    return null;
                }
                ShortProcessor shortProcessor = new ShortProcessor(this.width, this.height, (short[])object, colorModel);
                imagePlus = new ImagePlus(this.fi.fileName, shortProcessor);
                break;
            }
            case 3: 
            case 4: {
                Object object = this.readPixels(this.fi);
                if (object == null) {
                    return null;
                }
                FloatProcessor floatProcessor = new FloatProcessor(this.width, this.height, (float[])object, colorModel);
                imagePlus = new ImagePlus(this.fi.fileName, floatProcessor);
                break;
            }
            case 6: 
            case 7: {
                Object object = this.readPixels(this.fi);
                if (object == null) {
                    return null;
                }
                Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, (int[])object, 0, this.width));
                imagePlus = new ImagePlus(this.fi.fileName, image);
                break;
            }
        }
        imagePlus.setFileInfo(this.fi);
        FileOpener.setResolution(this.fi, imagePlus);
        if (bl) {
            imagePlus.show();
        }
        IJ.showProgress(1.0);
        return imagePlus;
    }

    ImagePlus openStack(ColorModel colorModel, boolean bl) {
        Object object;
        ImageStack imageStack = new ImageStack(this.fi.width, this.fi.height, colorModel);
        int n = this.fi.offset;
        try {
            object = new ImageReader(this.fi);
            InputStream inputStream = FileOpener.createInputStream(this.fi);
            int n2 = 1;
            while (n2 <= this.fi.nImages) {
                IJ.showStatus("Reading: " + n2 + "/" + this.fi.nImages);
                Object object2 = ((ImageReader)object).readPixels(inputStream, n);
                if (object2 == null) break;
                imageStack.addSlice(null, object2);
                n = this.fi.gapBetweenImages;
                IJ.showProgress((double)n2 / (double)this.fi.nImages);
                ++n2;
            }
            inputStream.close();
        }
        catch (Exception exception) {
            IJ.write("" + exception);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IJ.outOfMemory(this.fi.fileName);
            imageStack.trim();
        }
        IJ.showProgress(1.0);
        if (imageStack.getSize() == 0) {
            return null;
        }
        object = new ImagePlus(this.fi.fileName, imageStack);
        if (bl) {
            ((ImagePlus)object).show();
        }
        ((ImagePlus)object).setFileInfo(this.fi);
        FileOpener.setResolution(this.fi, (ImagePlus)object);
        IJ.showProgress(1.0);
        return object;
    }

    public void revertToSaved(ImagePlus imagePlus) {
        ProgressBar progressBar = IJ.getInstance().getProgressBar();
        if (this.fi.fileFormat == FileInfo.GIF_OR_JPG) {
            Image image = Toolkit.getDefaultToolkit().getImage(this.fi.directory + this.fi.fileName);
            imagePlus.setImage(image);
            if (imagePlus.getType() == 4) {
                Opener.convertGrayJpegTo8Bits(imagePlus);
            }
            return;
        }
        if (this.fi.nImages > 1) {
            return;
        }
        if (this.fi.url == null || this.fi.url.equals("")) {
            IJ.showStatus("Loading: " + this.fi.directory + this.fi.fileName);
        } else {
            IJ.showStatus("Loading: " + this.fi.url + this.fi.fileName);
        }
        Object object = this.readPixels(this.fi);
        if (object == null) {
            return;
        }
        ColorModel colorModel = FileOpener.createColorModel(this.fi);
        switch (this.fi.fileType) {
            case 0: 
            case 5: {
                ByteProcessor byteProcessor = new ByteProcessor(this.width, this.height, (byte[])object, colorModel);
                imagePlus.setProcessor(null, byteProcessor);
                break;
            }
            case 1: 
            case 2: {
                ShortProcessor shortProcessor = new ShortProcessor(this.width, this.height, (short[])object, colorModel);
                imagePlus.setProcessor(null, shortProcessor);
                break;
            }
            case 3: 
            case 4: {
                FloatProcessor floatProcessor = new FloatProcessor(this.width, this.height, (float[])object, colorModel);
                imagePlus.setProcessor(null, floatProcessor);
                break;
            }
            case 6: 
            case 7: {
                Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, (int[])object, 0, this.width));
                imagePlus.setImage(image);
                break;
            }
        }
    }

    static void setResolution(FileInfo fileInfo, ImagePlus imagePlus) {
        int n;
        Calibration calibration = null;
        if (fileInfo.pixelWidth > 0.0 && fileInfo.unit != null) {
            calibration = new Calibration(imagePlus);
            calibration.pixelWidth = fileInfo.pixelWidth;
            calibration.pixelHeight = fileInfo.pixelHeight;
            calibration.pixelDepth = fileInfo.pixelDepth;
            calibration.setUnit(fileInfo.unit);
        }
        if (fileInfo.valueUnit != null && ((n = fileInfo.calibrationFunction) >= 0 && n <= 8 && fileInfo.coefficients != null || n == 21)) {
            if (calibration == null) {
                calibration = new Calibration(imagePlus);
            }
            calibration.setFunction(n, fileInfo.coefficients, fileInfo.valueUnit);
        }
        if (calibration != null) {
            imagePlus.setCalibration(calibration);
        }
    }

    public static ColorModel createColorModel(FileInfo fileInfo) {
        if (fileInfo.fileType == 5 && fileInfo.lutSize > 0) {
            return new IndexColorModel(8, fileInfo.lutSize, fileInfo.reds, fileInfo.greens, fileInfo.blues);
        }
        return LookUpTable.createGrayscaleColorModel(fileInfo.whiteIsZero);
    }

    public static InputStream createInputStream(FileInfo fileInfo) throws IOException, MalformedURLException {
        if (fileInfo.inputStream != null) {
            return fileInfo.inputStream;
        }
        if (fileInfo.url != null && !fileInfo.url.equals("")) {
            return new URL(fileInfo.url + fileInfo.fileName).openStream();
        }
        return new FileInputStream(new File(fileInfo.directory + fileInfo.fileName));
    }

    Object readPixels(FileInfo fileInfo) {
        Object object = null;
        try {
            InputStream inputStream = FileOpener.createInputStream(fileInfo);
            ImageReader imageReader = new ImageReader(fileInfo);
            object = imageReader.readPixels(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            IJ.write("FileOpener.readPixels(): " + exception);
        }
        return object;
    }

    public FileOpener(FileInfo fileInfo) {
        this.fi = fileInfo;
        if (fileInfo != null) {
            this.width = fileInfo.width;
            this.height = fileInfo.height;
        }
    }
}

