/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.Roi;
import ij.process.ColorProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class TextRoi
extends Roi {
    static final int MAX_LINES = 50;
    private static String name = "SansSerif";
    private static int style = 0;
    private static int size = 18;
    private String[] theText = new String[50];
    private boolean firstChar = true;
    private int cline = 0;

    public void addChar(char c) {
        if (c < ' ' && c != '\b' && c != '\n') {
            return;
        }
        if (this.firstChar) {
            this.cline = 0;
            this.theText[this.cline] = new String("");
            int n = 1;
            while (n < 50) {
                this.theText[n] = null;
                ++n;
            }
        }
        if (c == '\b') {
            if (this.theText[this.cline].length() > 0) {
                this.theText[this.cline] = this.theText[this.cline].substring(0, this.theText[this.cline].length() - 1);
            } else if (this.cline > 0) {
                this.theText[this.cline] = null;
                --this.cline;
            }
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
            this.firstChar = false;
            return;
        }
        if (c == '\n') {
            if (this.cline < 49) {
                ++this.cline;
            }
        } else {
            char[] cArray = new char[]{c};
            int n = this.cline;
            this.theText[n] = this.theText[n] + new String(cArray);
            if (this.firstChar) {
                this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
            } else {
                this.draw(this.ic.getGraphics());
            }
            this.firstChar = false;
            return;
        }
        this.theText[this.cline] = "";
    }

    public int[] getMask() {
        Image image = GUI.createBlankImage(this.width, this.height);
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.black);
        Font font = new Font(name, style, size);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.getDescent();
        graphics.setFont(font);
        int n3 = 0;
        int n4 = 0;
        while (n3 < 50 && this.theText[n3] != null) {
            graphics.drawString(this.theText[n3], 1, n4 + n - n2 + 1);
            ++n3;
            n4 += n;
        }
        graphics.dispose();
        ColorProcessor colorProcessor = new ColorProcessor(image);
        return (int[])colorProcessor.getPixels();
    }

    public void draw(Graphics graphics) {
        super.draw(graphics);
        double d = this.ic.getMagnification();
        int n = this.ic.screenX(this.x);
        int n2 = this.ic.screenY(this.y);
        int n3 = (int)((double)this.width * d);
        int n4 = (int)((double)this.height * d);
        Font font = new Font(name, style, (int)((double)size * d));
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n5 = fontMetrics.getHeight();
        int n6 = fontMetrics.getDescent();
        graphics.setFont(font);
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setClip(n, n2, n3, n4);
        int n7 = 0;
        while (n7 < 50 && this.theText[n7] != null) {
            graphics.drawString(this.theText[n7], n + (int)d, n2 + n5 - n6 + (int)d);
            ++n7;
            n2 += n5;
        }
        if (rectangle != null) {
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public static String getFont() {
        return name;
    }

    public static int getSize() {
        return size;
    }

    public static int getStyle() {
        return style;
    }

    public static void setFont(String string, int n, int n2) {
        Roi roi;
        name = string;
        size = n;
        style = n2;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null && (roi = imagePlus.getRoi()) instanceof TextRoi) {
            imagePlus.draw();
        }
    }

    public TextRoi(int n, int n2, ImagePlus imagePlus) {
        super(n, n2, imagePlus);
        this.theText[0] = "Replace me";
    }
}

