/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageWindow;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class StackWindow
extends ImageWindow
implements Runnable,
AdjustmentListener,
ActionListener {
    protected Scrollbar sliceSelector;
    protected Thread thread;
    protected boolean done;
    protected int slice;

    public synchronized void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (!this.running) {
            this.slice = this.sliceSelector.getValue();
            this.notify();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public boolean close() {
        if (!super.close()) {
            return false;
        }
        StackWindow stackWindow = this;
        synchronized (stackWindow) {
            this.done = true;
            this.notify();
        }
        return true;
    }

    public void showSlice(int n) {
        if (n >= 1 && n <= this.imp.getStackSize()) {
            this.imp.setSlice(n);
        }
    }

    public void updateSliceSelector() {
        int n = this.imp.getStackSize();
        int n2 = this.sliceSelector.getMaximum();
        if (n2 != n + 1) {
            this.sliceSelector.setMaximum(n + 1);
        }
        this.sliceSelector.setValue(this.imp.getCurrentSlice());
    }

    public void run() {
        while (!this.done) {
            StackWindow stackWindow = this;
            synchronized (stackWindow) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.done) {
                return;
            }
            if (this.slice <= 0) continue;
            int n = this.slice;
            this.slice = 0;
            if (n == this.imp.getCurrentSlice()) continue;
            this.imp.setSlice(n);
        }
    }

    public StackWindow(ImagePlus imagePlus) {
        super(imagePlus);
        ImageStack imageStack = imagePlus.getStack();
        int n = imageStack.getSize();
        this.sliceSelector = new Scrollbar(0, 1, 1, 1, n + 1);
        this.add(this.sliceSelector);
        this.sliceSelector.addAdjustmentListener(this);
        int n2 = n / 10;
        if (n2 < 1) {
            n2 = 1;
        }
        this.sliceSelector.setUnitIncrement(1);
        this.sliceSelector.setBlockIncrement(n2);
        this.pack();
        this.show();
        imagePlus.setSlice(1);
        this.thread = new Thread((Runnable)this, "SliceSelector");
        this.thread.start();
    }
}

