/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public class ProgressBar
extends Canvas {
    private static boolean autoHide;
    private int canvasWidth;
    private int canvasHeight;
    private int x;
    private int y;
    private int width;
    private int height;
    private double percent;
    private long startTime;
    private int count;
    private boolean showBar;
    private boolean negativeProgress;
    private Color barColor = Color.gray;
    private Color fillColor = new Color(204, 204, 255);
    private Color backgroundColor = Color.lightGray;
    private Color frameBrighter = this.backgroundColor.brighter();
    private Color frameDarker = this.backgroundColor.darker();

    void fill3DRect(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(this.fillColor);
        graphics.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        graphics.setColor(this.frameDarker);
        graphics.drawLine(n, n2, n, n2 + n4);
        graphics.drawLine(n + 1, n2, n + n3 - 1, n2);
        graphics.setColor(this.frameBrighter);
        graphics.drawLine(n + 1, n2 + n4, n + n3, n2 + n4);
        graphics.drawLine(n + n3, n2, n + n3, n2 + n4 - 1);
    }

    public void show(double d) {
        long l;
        ++this.count;
        if (this.count == 1) {
            this.startTime = System.currentTimeMillis();
            this.showBar = false;
        } else if (this.count == 2 && (l = System.currentTimeMillis()) - this.startTime >= 50L) {
            this.showBar = true;
        }
        this.negativeProgress = d < this.percent;
        this.percent = d;
        if (d >= 1.0) {
            this.count = 0;
            d = 0.0;
            this.showBar = false;
            this.repaint();
        } else if (this.showBar) {
            this.repaint();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.showBar) {
            this.fill3DRect(graphics, this.x - 1, this.y - 1, this.width + 1, this.height + 1);
            this.drawBar(graphics);
        } else {
            graphics.setColor(this.backgroundColor);
            graphics.fillRect(0, 0, this.canvasWidth, this.canvasHeight);
        }
    }

    void drawBar(Graphics graphics) {
        if (this.percent < 0.0) {
            this.percent = 0.0;
        }
        int n = (int)((double)this.width * this.percent);
        if (this.negativeProgress) {
            graphics.setColor(this.fillColor);
            graphics.fillRect(n + 2, this.y, this.width - n, this.height);
        } else {
            graphics.setColor(this.barColor);
            graphics.fillRect(this.x, this.y, n, this.height);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.canvasWidth, this.canvasHeight);
    }

    public ProgressBar(int n, int n2) {
        this.canvasWidth = n;
        this.canvasHeight = n2;
        this.x = 3;
        this.y = 5;
        this.width = n - 8;
        this.height = n2 - 7;
        this.showBar = false;
        this.negativeProgress = false;
        this.count = 0;
        this.percent = 0.0;
    }
}

