/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.PlotWindow;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class ProfilePlot {
    static final int MIN_WIDTH = 350;
    static final double ASPECT_RATIO = 0.5;
    private static double fixedMin = Prefs.getDouble("pp.min", 0.0);
    private static double fixedMax = Prefs.getDouble("pp.max", 0.0);
    protected double[] profile;
    private double magnification;
    private double min;
    private double max;
    private boolean minAndMaxCalculated;
    protected double pixelSize;
    protected String units;
    protected String yLabel;
    private static /* synthetic */ Class class$Lij$gui$ProfilePlot;

    public Dimension getPlotSize() {
        if (this.profile == null) {
            return null;
        }
        int n = (int)((double)this.profile.length * this.magnification);
        int n2 = (int)((double)n * 0.5);
        if (n < 350) {
            n = 350;
            n2 = (int)((double)n * 0.5);
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = Math.min(dimension.width - 200, 1000);
        if (n > n3) {
            n = n3;
            n2 = (int)((double)n * 0.5);
        }
        return new Dimension(n, n2);
    }

    public void createWindow() {
        if (this.profile == null) {
            return;
        }
        Dimension dimension = this.getPlotSize();
        String string = "Distance (" + this.units + ")";
        int n = this.profile.length;
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = (float)((double)n2 * this.pixelSize);
            ++n2;
        }
        float[] fArray2 = new float[n];
        int n3 = 0;
        while (n3 < n) {
            fArray2[n3] = (float)this.profile[n3];
            ++n3;
        }
        n3 = fixedMin == 0.0 && fixedMax == 0.0 ? 0 : 1;
        PlotWindow plotWindow = new PlotWindow("", string, this.yLabel, fArray, fArray2);
        if (n3 != 0) {
            double[] dArray = Tools.getMinMax(fArray);
            plotWindow.setLimits(dArray[0], dArray[1], fixedMin, fixedMax);
        }
        plotWindow.draw();
    }

    public double[] getProfile() {
        return this.profile;
    }

    public double getMin() {
        if (!this.minAndMaxCalculated) {
            this.findMinAndMax();
        }
        return this.min;
    }

    public double getMax() {
        if (!this.minAndMaxCalculated) {
            this.findMinAndMax();
        }
        return this.max;
    }

    public static void setMinAndMax(double d, double d2) {
        fixedMin = d;
        fixedMax = d2;
        IJ.register(class$Lij$gui$ProfilePlot != null ? class$Lij$gui$ProfilePlot : (class$Lij$gui$ProfilePlot = ProfilePlot.class$("ij.gui.ProfilePlot")));
    }

    public static double getFixedMin() {
        return fixedMin;
    }

    public static double getFixedMax() {
        return fixedMax;
    }

    double[] getRowAverageProfile(Rectangle rectangle, Calibration calibration, ImageProcessor imageProcessor) {
        double[] dArray = new double[rectangle.height];
        int n = rectangle.x;
        while (n < rectangle.x + rectangle.width) {
            double[] dArray2 = imageProcessor.getLine(n, rectangle.y, n, rectangle.y + rectangle.height - 1);
            int n2 = 0;
            while (n2 < rectangle.height) {
                int n3 = n2;
                dArray[n3] = dArray[n3] + dArray2[n2];
                ++n2;
            }
            ++n;
        }
        n = 0;
        while (n < rectangle.height) {
            int n4 = n++;
            dArray[n4] = dArray[n4] / (double)rectangle.width;
        }
        if (calibration != null) {
            this.pixelSize = calibration.pixelHeight;
        }
        return dArray;
    }

    double[] getColumnAverageProfile(Rectangle rectangle, ImageProcessor imageProcessor) {
        double[] dArray = new double[rectangle.width];
        int n = rectangle.y;
        while (n < rectangle.y + rectangle.height) {
            double[] dArray2 = imageProcessor.getLine(rectangle.x, n, rectangle.x + rectangle.width - 1, n);
            int n2 = 0;
            while (n2 < rectangle.width) {
                int n3 = n2;
                dArray[n3] = dArray[n3] + dArray2[n2];
                ++n2;
            }
            ++n;
        }
        n = 0;
        while (n < rectangle.width) {
            int n4 = n++;
            dArray[n4] = dArray[n4] / (double)rectangle.height;
        }
        return dArray;
    }

    double[] getIrregularProfile(Roi roi, ImageProcessor imageProcessor) {
        int n = ((PolygonRoi)roi).getNCoordinates();
        int[] nArray = ((PolygonRoi)roi).getXCoordinates();
        int[] nArray2 = ((PolygonRoi)roi).getYCoordinates();
        Rectangle rectangle = roi.getBoundingRect();
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = 0;
        double d = 0.0;
        double[] dArray = new double[n];
        int n5 = 0;
        while (n5 < n - 1) {
            int n6 = nArray[n5 + 1] - nArray[n5];
            int n7 = nArray2[n5 + 1] - nArray2[n5];
            double d2 = Math.sqrt(n6 * n6 + n7 * n7);
            d += d2;
            dArray[n5] = d2;
            ++n5;
        }
        double[] dArray2 = new double[(int)d + 1];
        d = 0.0;
        int n8 = 0;
        while (n8 < n - 1) {
            double[] dArray3 = imageProcessor.getLine(nArray[n8] + n2, nArray2[n8] + n3, nArray[n8 + 1] + n2, nArray2[n8 + 1] + n3);
            int n9 = 0;
            while (n9 < dArray3.length) {
                dArray2[n4 + n9] = dArray3[n9];
                ++n9;
            }
            n4 = (int)(d += dArray[n8]);
            ++n8;
        }
        return dArray2;
    }

    void findMinAndMax() {
        if (this.profile == null) {
            return;
        }
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        int n = 0;
        while (n < this.profile.length) {
            double d3 = this.profile[n];
            if (d3 < d) {
                d = d3;
            }
            if (d3 > d2) {
                d2 = d3;
            }
            ++n;
        }
        this.min = d;
        this.max = d2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ProfilePlot() {
    }

    public ProfilePlot(ImagePlus imagePlus) {
        this(imagePlus, false);
    }

    public ProfilePlot(ImagePlus imagePlus, boolean bl) {
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            IJ.error("Selection required.");
            return;
        }
        int n = roi.getType();
        if (n != 5 && n != 6 && n != 7 && n != 0) {
            IJ.error("Line or rectangular selection required.");
            return;
        }
        Calibration calibration = imagePlus.getCalibration();
        this.pixelSize = calibration.pixelWidth;
        this.units = calibration.getUnits();
        this.yLabel = calibration.getValueUnit();
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        imageProcessor.setCalibrationTable(calibration.getCTable());
        this.profile = n == 5 ? ((Line)roi).getPixels() : (n == 6 || n == 7 ? this.getIrregularProfile(roi, imageProcessor) : (bl ? this.getRowAverageProfile(roi.getBoundingRect(), calibration, imageProcessor) : this.getColumnAverageProfile(roi.getBoundingRect(), imageProcessor)));
        imageProcessor.setCalibrationTable(null);
        ImageWindow imageWindow = imagePlus.getWindow();
        this.magnification = imageWindow != null ? imageWindow.getCanvas().getMagnification() : 1.0;
    }
}

