/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GUI;
import ij.gui.ImageWindow;
import ij.gui.ProfilePlot;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Button;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.CharArrayWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;

public class PlotWindow
extends ImageWindow
implements ActionListener,
ClipboardOwner {
    public static final int CIRCLE = 0;
    static final int LEFT_MARGIN = 50;
    static final int RIGHT_MARGIN = 20;
    static final int TOP_MARGIN = 20;
    static final int BOTTOM_MARGIN = 30;
    static final int WIDTH = 450;
    static final int HEIGHT = 200;
    static final String MIN = "pp.min";
    static final String MAX = "pp.max";
    static final String OPTIONS = "pp.options";
    static final int SAVE_X_VALUES = 1;
    static final int AUTO_CLOSE = 2;
    private static String defaultDirectory = null;
    private static int options;
    public static boolean saveXValues;
    public static boolean autoClose;
    private int frameWidth;
    private int frameHeight;
    private int xloc;
    private int yloc;
    private Rectangle frame = null;
    private float[] xValues;
    private float[] yValues;
    private int nPoints;
    private double xScale;
    private double yScale;
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private Button list;
    private Button save;
    private Button copy;
    private Label coordinates;
    private String xLabel;
    private String yLabel;
    private FontMetrics fm;
    private Font font = new Font("Helvetica", 0, 12);
    private boolean fixedYScale;
    private Graphics g;
    private static /* synthetic */ Class class$Lij$gui$PlotWindow;

    public void setLimits(double d, double d2, double d3, double d4) {
        this.xMin = d;
        this.xMax = d2;
        this.yMin = d3;
        this.yMax = d4;
        this.fixedYScale = true;
    }

    public void addPoints(float[] fArray, float[] fArray2, int n) {
        this.setup();
        int n2 = 0;
        while (n2 < fArray.length) {
            int n3 = 50 + (int)(((double)fArray[n2] - this.xMin) * this.xScale);
            int n4 = 20 + this.frameHeight - (int)(((double)fArray2[n2] - this.yMin) * this.yScale);
            this.g.drawOval(n3 - 2, n4 - 2, 5, 5);
            ++n2;
        }
    }

    public void addPoints(double[] dArray, double[] dArray2, int n) {
        this.addPoints(Tools.toFloat(dArray), Tools.toFloat(dArray2), n);
    }

    public void addLabel(double d, double d2, String string) {
        this.setup();
        int n = 50 + (int)(d * (double)this.frameWidth);
        int n2 = 20 + (int)(d2 * (double)this.frameHeight);
        this.g.drawString(string, n, n2);
    }

    public void draw() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(2));
        this.list = new Button(" List ");
        this.list.addActionListener(this);
        panel.add(this.list);
        this.save = new Button("Save...");
        this.save.addActionListener(this);
        panel.add(this.save);
        this.copy = new Button("Copy...");
        this.copy.addActionListener(this);
        panel.add(this.copy);
        this.coordinates = new Label("                     ");
        this.coordinates.setFont(new Font("Monospaced", 0, 12));
        panel.add(this.coordinates);
        this.add(panel);
        this.pack();
        this.drawPlot();
        this.g.dispose();
        this.g = null;
        this.imp.setProcessor(null, new ColorProcessor(this.imp.getImage()));
        this.imp.updateAndDraw();
    }

    void setup() {
        if (this.g != null) {
            return;
        }
        this.g = this.imp.getImage().getGraphics();
        this.g.setColor(Color.black);
        this.g.setFont(this.font);
        if (this.frameWidth == 0) {
            this.frameWidth = 450;
            this.frameHeight = 200;
        }
        this.frame = new Rectangle(50, 20, this.frameWidth, this.frameHeight);
        this.xScale = this.xMax - this.xMin == 0.0 ? 1.0 : (double)this.frame.width / (this.xMax - this.xMin);
        this.yScale = this.yMax - this.yMin == 0.0 ? 1.0 : (double)this.frame.height / (this.yMax - this.yMin);
    }

    String d2s(double d) {
        if ((double)Math.round(d) == d) {
            return IJ.d2s(d, 0);
        }
        return IJ.d2s(d);
    }

    public void mouseMoved(int n, int n2) {
        if (this.frame == null || this.coordinates == null) {
            return;
        }
        if (this.frame.contains(n, n2)) {
            this.coordinates.setText("X=" + this.d2s((double)(n -= this.frame.x) / this.xScale + this.xMin) + ", Y=" + this.d2s((double)(this.frameHeight - (n2 -= this.frame.y)) / this.yScale + this.yMin));
        } else {
            this.coordinates.setText("");
        }
    }

    void drawPlot() {
        this.setup();
        this.g.drawRect(this.frame.x, this.frame.y, this.frame.width, this.frame.height);
        int[] nArray = new int[this.nPoints];
        int[] nArray2 = new int[this.nPoints];
        int n = 0;
        while (n < this.nPoints) {
            double d = this.yValues[n];
            if (d < this.yMin) {
                d = this.yMin;
            }
            if (d > this.yMax) {
                d = this.yMax;
            }
            nArray[n] = 50 + (int)(((double)this.xValues[n] - this.xMin) * this.xScale);
            nArray2[n] = 20 + this.frame.height - (int)((d - this.yMin) * this.yScale);
            ++n;
        }
        this.g.drawPolyline(nArray, nArray2, this.nPoints);
        String string = this.d2s(this.yMax);
        int n2 = this.getWidth(string, this.g);
        if (n2 + 4 > 50) {
            this.g.drawString(string, 4, 16);
        } else {
            this.g.drawString(string, 50 - this.getWidth(string, this.g) - 4, 30);
        }
        string = this.d2s(this.yMin);
        n2 = this.getWidth(string, this.g);
        if (n2 + 4 > 50) {
            this.g.drawString(string, 4, 20 + this.frame.height);
        } else {
            this.g.drawString(string, 50 - this.getWidth(string, this.g) - 4, 20 + this.frame.height);
        }
        int n3 = 50;
        int n4 = 20 + this.frame.height + 15;
        this.g.drawString(this.d2s(this.xMin), n3, n4);
        string = this.d2s(this.xMax);
        this.g.drawString(string, n3 + this.frame.width - this.getWidth(string, this.g) + 6, n4);
        this.g.drawString(this.xLabel, 50 + (this.frame.width - this.getWidth(this.xLabel, this.g)) / 2, n4 + 3);
        this.drawYLabel(this.g, this.yLabel, 50, 20, this.frame.height);
    }

    void drawYLabel(Graphics graphics, String string, int n, int n2, int n3) {
        if (string.equals("")) {
            return;
        }
        if (this.fm == null) {
            this.fm = graphics.getFontMetrics();
        }
        int n4 = this.fm.stringWidth(string);
        int n5 = this.fm.getHeight();
        Image image = this.createImage(n4, n5);
        Graphics graphics2 = image.getGraphics();
        graphics2.setFont(this.font);
        int n6 = this.fm.getDescent();
        graphics2.drawString(string, 0, n5 - n6);
        graphics2.dispose();
        ImageProcessor imageProcessor = new ColorProcessor(image);
        imageProcessor = imageProcessor.rotateLeft();
        image = imageProcessor.createImage();
        int n7 = n2 + (n3 - this.getWidth(string, graphics)) / 2;
        if (n7 < n2) {
            n7 = n2;
        }
        int n8 = n - n5 - 5;
        graphics.drawImage(image, n8, n7, null);
    }

    int getWidth(String string, Graphics graphics) {
        if (this.fm == null) {
            this.fm = graphics.getFontMetrics();
        }
        return this.fm.stringWidth(string);
    }

    void showList() {
        if (saveXValues) {
            IJ.setColumnHeadings("X\tY");
        } else {
            IJ.setColumnHeadings("Y");
        }
        int n = 0;
        while (n < this.nPoints) {
            if (saveXValues) {
                IJ.write(this.d2s(this.xValues[n]) + "\t" + this.d2s(this.yValues[n]));
            } else {
                IJ.write(this.d2s(this.yValues[n]));
            }
            ++n;
        }
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void saveAsText() {
        String string;
        FileDialog fileDialog = new FileDialog((Frame)this, "Save as Text...", 1);
        if (defaultDirectory != null) {
            fileDialog.setDirectory(defaultDirectory);
        }
        fileDialog.show();
        String string2 = fileDialog.getFile();
        defaultDirectory = string = fileDialog.getDirectory();
        fileDialog.dispose();
        PrintWriter printWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string + string2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            printWriter = new PrintWriter(bufferedOutputStream);
        }
        catch (IOException iOException) {
            IJ.error("" + iOException);
            return;
        }
        IJ.wait(250);
        IJ.showStatus("Saving plot values...");
        int n = 0;
        while (n < this.nPoints) {
            if (saveXValues) {
                printWriter.println(this.d2s(this.xValues[n]) + "\t" + this.d2s(this.yValues[n]));
            } else {
                printWriter.println(this.d2s(this.yValues[n]));
            }
            ++n;
        }
        printWriter.close();
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void copyToClipboard() {
        Clipboard clipboard = null;
        try {
            clipboard = this.getToolkit().getSystemClipboard();
        }
        catch (Exception exception) {
            clipboard = null;
        }
        if (clipboard == null) {
            IJ.error("Unable to copy to Clipboard.");
            return;
        }
        IJ.showStatus("Copying plot values...");
        CharArrayWriter charArrayWriter = new CharArrayWriter(this.nPoints * 4);
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        int n = 0;
        while (n < this.nPoints) {
            if (saveXValues) {
                printWriter.print(this.d2s(this.xValues[n]) + "\t" + this.d2s(this.yValues[n]) + "\n");
            } else {
                printWriter.print(this.d2s(this.yValues[n]) + "\n");
            }
            ++n;
        }
        String string = charArrayWriter.toString();
        printWriter.close();
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, this);
        IJ.showStatus(string.length() + " characters copied to Clipboard");
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.list) {
            this.showList();
        } else if (object == this.save) {
            this.saveAsText();
        } else {
            this.copyToClipboard();
        }
    }

    public static void savePreferences(Properties properties) {
        double d = ProfilePlot.getFixedMin();
        double d2 = ProfilePlot.getFixedMax();
        if ((d != 0.0 || d2 != 0.0) && d < d2) {
            ((Hashtable)properties).put(MIN, Double.toString(d));
            ((Hashtable)properties).put(MAX, Double.toString(d2));
        }
        int n = 0;
        if (saveXValues) {
            n |= 1;
        }
        if (autoClose) {
            n |= 2;
        }
        ((Hashtable)properties).put(OPTIONS, Integer.toString(n));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PlotWindow(String string, String string2, String string3, float[] fArray, float[] fArray2) {
        super(new ImagePlus(string, GUI.createBlankImage(520, 250)));
        this.xLabel = string2;
        this.yLabel = string3;
        this.xValues = fArray;
        this.yValues = fArray2;
        double[] dArray = Tools.getMinMax(fArray);
        this.xMin = dArray[0];
        this.xMax = dArray[1];
        dArray = Tools.getMinMax(fArray2);
        this.yMin = dArray[0];
        this.yMax = dArray[1];
        this.fixedYScale = false;
        this.nPoints = fArray.length;
    }

    static {
        IJ.register(class$Lij$gui$PlotWindow != null ? class$Lij$gui$PlotWindow : (class$Lij$gui$PlotWindow = PlotWindow.class$("ij.gui.PlotWindow")));
        options = Prefs.getInt(OPTIONS, 1);
        saveXValues = (options & 1) != 0;
        autoClose = (options & 2) != 0;
    }
}

