/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.ImagePlus;
import ij.gui.GUI;
import ij.gui.Line;
import ij.gui.Roi;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

public class OvalRoi
extends Roi {
    public void draw(Graphics graphics) {
        graphics.setColor(Roi.ROIColor);
        double d = this.ic.getMagnification();
        graphics.drawOval(this.ic.screenX(this.x), this.ic.screenY(this.y), (int)((double)this.width * d), (int)((double)this.height * d));
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
        this.showStatus();
    }

    public void drawPixels() {
        double d;
        ImageProcessor imageProcessor = this.imp.getProcessor();
        int n = this.width / 2;
        int n2 = this.height / 2;
        double d2 = n * n;
        double d3 = n2 * n2;
        int n3 = this.x + n;
        int n4 = this.y + n2;
        imageProcessor.moveTo(this.x, this.y + n2);
        int n5 = -n + 1;
        while (n5 <= n) {
            d = Math.sqrt(d3 * (1.0 - (double)(n5 * n5) / d2));
            imageProcessor.lineTo(n3 + n5, n4 + (int)(d + 0.5));
            ++n5;
        }
        imageProcessor.moveTo(this.x, this.y + n2);
        n5 = -n + 1;
        while (n5 <= n) {
            d = Math.sqrt(d3 * (1.0 - (double)(n5 * n5) / d2));
            imageProcessor.lineTo(n3 + n5, n4 - (int)(d + 0.5));
            ++n5;
        }
        if (Line.getWidth() > 1) {
            this.updateFullWindow = true;
        }
    }

    public boolean contains(int n, int n2) {
        double d;
        double d2;
        if (!super.contains(n, n2)) {
            return false;
        }
        return (double)((n = Math.abs(n - (this.x + this.width / 2))) * n) / ((d2 = (double)(this.width / 2)) * d2) + (double)((n2 = Math.abs(n2 - (this.y + this.height / 2))) * n2) / ((d = (double)(this.height / 2)) * d) <= 1.0;
    }

    public int[] getMask() {
        Image image = GUI.createBlankImage(this.width, this.height);
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.black);
        graphics.fillOval(0, 0, this.width, this.height);
        graphics.dispose();
        ColorProcessor colorProcessor = new ColorProcessor(image);
        return (int[])colorProcessor.getPixels();
    }

    public double getLength() {
        return Math.PI * (double)(this.width + this.height) / 2.0;
    }

    public OvalRoi(int n, int n2, int n3, int n4, ImagePlus imagePlus) {
        super(n, n2, n3, n4, imagePlus);
        this.type = 1;
    }

    public OvalRoi(int n, int n2, ImagePlus imagePlus) {
        super(n, n2, imagePlus);
        this.type = 1;
    }
}

