/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;

public class NewImage {
    public static final int GRAY8 = 0;
    public static final int GRAY16 = 1;
    public static final int GRAY32 = 2;
    public static final int RGB = 3;
    public static final int FILL_WHITE = 0;
    public static final int FILL_BLACK = 1;
    public static final int FILL_RAMP = 2;
    private static String name = "Untitled";
    private static int width = 400;
    private static int height = 400;
    private static int slices = 1;
    private static int type = 0;
    private static int fillWith = 0;
    private static String[] types = new String[]{"8-bit Unsigned", "16-bit Unsigned", "32-bit Real", "32-bit RGB"};
    private static String[] fill = new String[]{"White", "Black", "Ramp", "Clipboard"};

    static void createStack(ImagePlus imagePlus, ImageProcessor imageProcessor, int n, int n2) {
        int n3 = imagePlus.getWidth();
        int n4 = imagePlus.getHeight();
        ImageStack imageStack = imagePlus.createEmptyStack();
        try {
            imageStack.addSlice(null, imageProcessor);
            int n5 = 2;
            while (n5 <= n) {
                Object[] objectArray = null;
                switch (n2) {
                    case 0: {
                        objectArray = new byte[n3 * n4];
                        break;
                    }
                    case 1: {
                        objectArray = new short[n3 * n4];
                        break;
                    }
                    case 2: {
                        objectArray = new float[n3 * n4];
                        break;
                    }
                    case 3: {
                        objectArray = new int[n3 * n4];
                        break;
                    }
                }
                System.arraycopy(imageProcessor.getPixels(), 0, objectArray, 0, n3 * n4);
                imageStack.addSlice(null, objectArray);
                ++n5;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IJ.outOfMemory(imagePlus.getTitle());
            imageStack.trim();
        }
        if (imageStack.getSize() > 1) {
            imagePlus.setStack(null, imageStack);
        }
    }

    static ImagePlus createImagePlus() {
        return new ImagePlus();
    }

    public static ImagePlus createByteImage(String string, int n, int n2, int n3, int n4) {
        byte[] byArray = new byte[n * n2];
        switch (n4) {
            case 0: {
                int n5 = 0;
                while (n5 < n * n2) {
                    byArray[n5] = -1;
                    ++n5;
                }
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                byte[] byArray2 = new byte[n];
                int n6 = 0;
                while (n6 < n) {
                    byArray2[n6] = (byte)(n6 * 255 / (n - 1));
                    ++n6;
                }
                n6 = 0;
                while (n6 < n2) {
                    int n7 = n6 * n;
                    int n8 = 0;
                    while (n8 < n) {
                        byArray[n7++] = byArray2[n8];
                        ++n8;
                    }
                    ++n6;
                }
                break;
            }
        }
        ByteProcessor byteProcessor = new ByteProcessor(n, n2, byArray, null);
        ImagePlus imagePlus = NewImage.createImagePlus();
        imagePlus.setProcessor(string, byteProcessor);
        if (n3 > 1) {
            NewImage.createStack(imagePlus, byteProcessor, n3, 0);
        }
        return imagePlus;
    }

    public static ImagePlus createRGBImage(String string, int n, int n2, int n3, int n4) {
        int[] nArray = new int[n * n2];
        switch (n4) {
            case 0: {
                int n5 = 0;
                while (n5 < n * n2) {
                    nArray[n5] = -1;
                    ++n5;
                }
                break;
            }
            case 1: {
                int n5 = 0;
                while (n5 < n * n2) {
                    nArray[n5] = -16777216;
                    ++n5;
                }
                break;
            }
            case 2: {
                int n5;
                int n6 = 0;
                while (n6 < n2) {
                    int n7 = 0;
                    while (n7 < n) {
                        byte by;
                        byte by2 = by = (byte)(n7 * 255 / (n - 1));
                        n5 = by;
                        nArray[n6 * n + n7] = 0xFF000000 | n5 << 16 & 0xFF0000 | by2 << 8 & 0xFF00 | by & 0xFF;
                        ++n7;
                    }
                    ++n6;
                }
                break;
            }
        }
        ColorProcessor colorProcessor = new ColorProcessor(n, n2, nArray);
        ImagePlus imagePlus = NewImage.createImagePlus();
        imagePlus.setProcessor(string, colorProcessor);
        if (n3 > 1) {
            NewImage.createStack(imagePlus, colorProcessor, n3, 3);
        }
        return imagePlus;
    }

    public static ImagePlus createShortImage(String string, int n, int n2, int n3, int n4) {
        short[] sArray = new short[n * n2];
        switch (n4) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                int n5 = 0;
                while (n5 < n2) {
                    int n6 = 0;
                    while (n6 < n) {
                        sArray[n5 * n + n6] = (short)(n6 * 65535 / (n - 1));
                        ++n6;
                    }
                    ++n5;
                }
                break;
            }
        }
        ShortProcessor shortProcessor = new ShortProcessor(n, n2, sArray, null);
        ImagePlus imagePlus = NewImage.createImagePlus();
        imagePlus.setProcessor(string, shortProcessor);
        if (n3 > 1) {
            NewImage.createStack(imagePlus, shortProcessor, n3, 1);
        }
        return imagePlus;
    }

    public static ImagePlus createUnsignedShortImage(String string, int n, int n2, int n3, int n4) {
        return NewImage.createShortImage(string, n, n2, n3, n4);
    }

    public static ImagePlus createFloatImage(String string, int n, int n2, int n3, int n4) {
        float[] fArray = new float[n * n2];
        switch (n4) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                int n5 = 0;
                while (n5 < n2) {
                    int n6 = 0;
                    while (n6 < n) {
                        fArray[n5 * n + n6] = (float)((double)n6 * 1.0 / (double)(n - 1));
                        ++n6;
                    }
                    ++n5;
                }
                break;
            }
        }
        FloatProcessor floatProcessor = new FloatProcessor(n, n2, fArray, null);
        ImagePlus imagePlus = NewImage.createImagePlus();
        imagePlus.setProcessor(string, floatProcessor);
        if (n3 > 1) {
            NewImage.createStack(imagePlus, floatProcessor, n3, 2);
        }
        return imagePlus;
    }

    public static void open(String string, int n, int n2, int n3, int n4, int n5) {
        ImagePlus imagePlus = null;
        switch (n4) {
            case 0: {
                imagePlus = NewImage.createByteImage(string, n, n2, n3, n5);
                break;
            }
            case 1: {
                imagePlus = NewImage.createShortImage(string, n, n2, n3, n5);
                break;
            }
            case 2: {
                imagePlus = NewImage.createFloatImage(string, n, n2, n3, n5);
                break;
            }
            case 3: {
                imagePlus = NewImage.createRGBImage(string, n, n2, n3, n5);
                break;
            }
        }
        if (imagePlus != null) {
            imagePlus.show();
        }
    }

    void showClipboard() {
        ImagePlus imagePlus = ImageWindow.getClipboard();
        if (imagePlus != null) {
            imagePlus.show();
        } else {
            IJ.error("The clipboard is empty.");
        }
    }

    boolean showDialog() {
        GenericDialog genericDialog = new GenericDialog("New...", IJ.getInstance());
        genericDialog.addStringField("Name:", name, 12);
        genericDialog.addChoice("Type:", types, types[type]);
        genericDialog.addChoice("Fill With:", fill, fill[fillWith]);
        genericDialog.addNumericField("Width (pixels):", width, 0);
        genericDialog.addNumericField("Height (pixels):", height, 0);
        genericDialog.addNumericField("Slices:", slices, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        name = genericDialog.getNextString();
        type = genericDialog.getNextChoiceIndex();
        fillWith = genericDialog.getNextChoiceIndex();
        width = (int)genericDialog.getNextNumber();
        height = (int)genericDialog.getNextNumber();
        slices = (int)genericDialog.getNextNumber();
        return true;
    }

    void openImage() {
        if (!this.showDialog()) {
            return;
        }
        if (fillWith > 2) {
            this.showClipboard();
            return;
        }
        try {
            NewImage.open(name, width, height, slices, type, fillWith);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IJ.outOfMemory("New...");
        }
    }

    public NewImage() {
        this.openImage();
    }
}

