/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;

public class MultiLineLabel
extends Canvas {
    String[] lines;
    int num_lines;
    int margin_width = 6;
    int margin_height = 6;
    int line_height;
    int line_ascent;
    int[] line_widths;
    int max_width;

    protected void measure() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return;
        }
        this.line_height = fontMetrics.getHeight();
        this.line_ascent = fontMetrics.getAscent();
        this.max_width = 0;
        int n = 0;
        while (n < this.num_lines) {
            this.line_widths[n] = fontMetrics.stringWidth(this.lines[n]);
            if (this.line_widths[n] > this.max_width) {
                this.max_width = this.line_widths[n];
            }
            ++n;
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.measure();
        this.repaint();
    }

    public void addNotify() {
        super.addNotify();
        this.measure();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.max_width + 2 * this.margin_width, this.num_lines * this.line_height + 2 * this.margin_height);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.max_width, this.num_lines * this.line_height);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = this.line_ascent + (dimension.height - this.num_lines * this.line_height) / 2;
        int n2 = 0;
        while (n2 < this.num_lines) {
            int n3 = this.margin_width;
            graphics.drawString(this.lines[n2], n3, n);
            ++n2;
            n += this.line_height;
        }
    }

    public MultiLineLabel(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        this.num_lines = stringTokenizer.countTokens();
        this.lines = new String[this.num_lines];
        this.line_widths = new int[this.num_lines];
        int n = 0;
        while (n < this.num_lines) {
            this.lines[n] = stringTokenizer.nextToken();
            ++n;
        }
    }
}

