/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Menus;
import ij.Undo;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageLayout;
import ij.gui.Roi;
import ij.gui.SaveChangesDialog;
import ij.gui.StackWindow;
import ij.gui.Toolbar;
import ij.io.FileSaver;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class ImageWindow
extends Frame
implements FocusListener,
WindowListener {
    protected static ImagePlus clipboard;
    private static final int XINC = 8;
    private static final int YINC = 12;
    private static final int TEXT_GAP = 10;
    private static int xbase;
    private static int ybase;
    private static int xloc;
    private static int yloc;
    private static int count;
    protected ImagePlus imp;
    protected ImageJ ij;
    protected ImageCanvas ic;
    private int originalScale = 1;
    protected boolean closed;
    public boolean running;
    private int j = 0;

    private void setLocationAndSize() {
        Point point;
        int n = this.imp.getWidth();
        int n2 = this.imp.getHeight();
        Point point2 = point = this.ij != null ? this.ij.getPreferredLocation() : new Point(10, 32);
        if (xbase == -1) {
            xbase = 5;
            ybase = point.y;
            xloc = xbase;
            yloc = ybase;
        }
        if (xloc + n > point.x && yloc < ybase + 20) {
            yloc = ybase + 20;
        }
        int n3 = xloc;
        int n4 = yloc;
        ((Component)this).setLocation(n3, n4);
        xloc += 8;
        yloc += 12;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (++count % 6 == 0) {
            xloc = xbase;
            yloc = ybase;
        }
        int n5 = 1;
        while (xbase + 32 + n / n5 > dimension.width || ybase + 48 + n2 / n5 > dimension.height) {
            n5 *= 2;
        }
        this.ic.setMagnification(1.0 / (double)n5);
        if (n5 > 1) {
            this.originalScale = n5;
            this.ic.setDrawingSize(n / n5, n2 / n5);
        }
    }

    public int getOriginalScale() {
        return this.originalScale;
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top + 10, insets.left, insets.bottom, insets.right);
    }

    public void drawInfo(Graphics graphics) {
        int n;
        String string = "";
        Insets insets = super.getInsets();
        int n2 = this.imp.getStackSize();
        if (n2 > 1) {
            ImageStack imageStack = this.imp.getStack();
            int n3 = this.imp.getCurrentSlice();
            string = string + n3 + "/" + n2;
            n = 0;
            String string2 = imageStack.getSliceLabel(n3);
            if (string2 != null && string2.length() > 0) {
                string = string + " (" + string2 + ")";
            }
            if (this instanceof StackWindow && this.running) {
                graphics.drawString(string, 5, insets.top + 10);
                return;
            }
            string = string + "; ";
        }
        int n4 = this.imp.getType();
        Calibration calibration = this.imp.getCalibration();
        string = calibration.pixelWidth != 1.0 || calibration.pixelHeight != 1.0 ? string + IJ.d2s((double)this.imp.getWidth() * calibration.pixelWidth, 2) + "x" + IJ.d2s((double)this.imp.getHeight() * calibration.pixelHeight, 2) + " " + calibration.getUnits() + " (" + this.imp.getWidth() + "x" + this.imp.getHeight() + "); " : string + this.imp.getWidth() + "x" + this.imp.getHeight() + " pixels; ";
        n = this.imp.getWidth() * this.imp.getHeight() * this.imp.getStackSize() / 1024;
        switch (n4) {
            case 0: {
                string = string + "8-bit grayscale";
                break;
            }
            case 1: {
                string = string + "16-bit grayscale";
                n *= 2;
                break;
            }
            case 2: {
                string = string + "32-bit grayscale";
                n *= 4;
                break;
            }
            case 3: {
                string = string + "8-bit color";
                break;
            }
            case 4: {
                string = string + "RGB";
                n *= 4;
                break;
            }
        }
        string = string + "; " + n + "K";
        graphics.drawString(string, 5, insets.top + 10);
    }

    public void paint(Graphics graphics) {
        this.drawInfo(graphics);
        Point point = this.ic.getLocation();
        Dimension dimension = this.ic.getSize();
        graphics.drawRect(point.x - 1, point.y - 1, dimension.width + 1, dimension.height + 1);
    }

    public boolean close() {
        boolean bl = this.running;
        this.running = false;
        if (bl) {
            IJ.wait(500);
        }
        if (this.imp.changes && IJ.getApplet() == null) {
            FileSaver fileSaver;
            SaveChangesDialog saveChangesDialog = new SaveChangesDialog((Frame)IJ.getInstance(), this.imp.getTitle());
            if (saveChangesDialog.cancelPressed()) {
                return false;
            }
            if (saveChangesDialog.savePressed() && !(fileSaver = new FileSaver(this.imp)).save()) {
                return false;
            }
        }
        if (WindowManager.getWindowCount() == 0) {
            xloc = 0;
            yloc = 0;
        }
        this.closed = true;
        WindowManager.removeWindow(this);
        ((Component)this).setVisible(false);
        this.dispose();
        this.imp.flush();
        return true;
    }

    public ImagePlus getImagePlus() {
        return this.imp;
    }

    void setImagePlus(ImagePlus imagePlus) {
        this.imp = imagePlus;
        this.repaint();
    }

    public ImageCanvas getCanvas() {
        return this.ic;
    }

    static ImagePlus getClipboard() {
        return clipboard;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void focusGained(FocusEvent focusEvent) {
        if (IJ.debugMode) {
            IJ.write(this.imp.getTitle() + ": Got focus");
        }
        WindowManager.setCurrentWindow(this);
    }

    public void windowActivated(WindowEvent windowEvent) {
        if (IJ.isMacintosh()) {
            this.setMenuBar(Menus.getMenuBar());
        }
        if (IJ.debugMode) {
            IJ.write(this.imp.getTitle() + ": Activated");
        }
        if (!this.closed) {
            WindowManager.setCurrentWindow(this);
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (IJ.getInstance() != null) {
            IJ.doCommand("Close");
        } else {
            ((Component)this).setVisible(false);
            this.dispose();
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void copy(boolean bl) {
        String string;
        Roi roi = this.imp.getRoi();
        String string2 = string = bl ? "Cut" : "Copy";
        if (roi != null && roi.getType() != 0) {
            IJ.error("Cut/Copy of non-rectangular ROIs not supported.");
            return;
        }
        IJ.showStatus(string + "ing...");
        ImageProcessor imageProcessor = this.imp.getProcessor();
        ImageProcessor imageProcessor2 = imageProcessor.crop();
        clipboard = new ImagePlus("Clipboard", imageProcessor2);
        if (bl) {
            imageProcessor.snapshot();
            imageProcessor.setColor(Toolbar.getBackgroundColor());
            imageProcessor.fill();
            this.imp.setColor(Toolbar.getForegroundColor());
            Undo.setup(1, this.imp);
            this.imp.updateAndDraw();
        }
        int n = 1;
        switch (clipboard.getType()) {
            case 1: {
                n = 2;
                break;
            }
            case 2: 
            case 4: {
                n = 4;
            }
        }
        IJ.showStatus(string + ": " + clipboard.getWidth() * clipboard.getHeight() * n / 1024 + "k");
    }

    public void paste() {
        if (clipboard == null) {
            return;
        }
        int n = clipboard.getType();
        int n2 = this.imp.getType();
        boolean bl = false;
        if (n == 0 | n == 3 && n2 == 0 | n2 == 3) {
            bl = true;
        } else if (n == 4 | n == 0 | n == 3 && n2 == 4) {
            bl = true;
        } else if (n == 1 && n2 == 1) {
            bl = true;
        } else if (n == 2 && n2 == 2) {
            bl = true;
        }
        if (!bl) {
            IJ.error("Images must be the same type to paste.");
            return;
        }
        int n3 = clipboard.getWidth();
        int n4 = clipboard.getHeight();
        if (n3 > this.imp.getWidth() || n4 > this.imp.getHeight()) {
            IJ.error("Image is too large to paste.");
            return;
        }
        Roi roi = this.imp.getRoi();
        Rectangle rectangle = null;
        if (roi != null) {
            rectangle = roi.getBoundingRect();
        }
        if (rectangle == null || rectangle != null && (n3 != rectangle.width || n4 != rectangle.height)) {
            Rectangle rectangle2 = this.ic.getSrcRect();
            int n5 = rectangle2.x + rectangle2.width / 2;
            int n6 = rectangle2.y + rectangle2.height / 2;
            this.imp.setRoi(n5 - n3 / 2, n6 - n4 / 2, n3, n4);
            roi = this.imp.getRoi();
        }
        roi.startPaste(clipboard);
        Undo.setup(3, this.imp);
    }

    public void mouseMoved(int n, int n2) {
        this.imp.mouseMoved(n, n2);
    }

    public ImageWindow(ImagePlus imagePlus) {
        this(imagePlus, new ImageCanvas(imagePlus));
    }

    public ImageWindow(ImagePlus imagePlus, ImageCanvas imageCanvas) {
        super(imagePlus.getTitle());
        ((Component)this).setBackground(Color.white);
        this.setForeground(Color.black);
        this.ij = IJ.getInstance();
        this.imp = imagePlus;
        this.ic = imageCanvas;
        ImageWindow imageWindow = imagePlus.getWindow();
        this.setLayout(new ImageLayout(imageCanvas));
        this.add(imageCanvas);
        this.addFocusListener(this);
        this.addWindowListener(this);
        this.setResizable(true);
        WindowManager.addWindow(this);
        imagePlus.setWindow(this);
        if (imageWindow != null) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            if (imagePlus.getWidth() < dimension.width && imagePlus.getHeight() < dimension.height) {
                Point point = imageWindow.getLocation();
                ((Component)this).setLocation(point.x, point.y);
            } else {
                this.setLocationAndSize();
            }
            this.pack();
            ((Component)this).setVisible(true);
            boolean bl = imagePlus.lockSilently();
            imagePlus.changes = false;
            imageWindow.close();
            if (bl) {
                imagePlus.unlock();
            }
            WindowManager.setCurrentWindow(this);
        } else {
            Image image;
            this.setLocationAndSize();
            if (this.ij != null && (image = this.ij.getIconImage()) != null) {
                this.setIconImage(image);
            }
            this.pack();
            ((Component)this).setVisible(true);
        }
    }

    static {
        xbase = -1;
        count = 0;
    }
}

