/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.gui.ImageWindow;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.gui.Wand;
import ij.process.ImageProcessor;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.IndexColorModel;

public class ImageCanvas
extends Canvas
implements MouseListener,
MouseMotionListener,
Cloneable {
    protected static Cursor defaultCursor = new Cursor(0);
    protected static Cursor handCursor = new Cursor(12);
    protected static Cursor moveCursor = new Cursor(13);
    protected static Cursor crosshairCursor = new Cursor(1);
    public static boolean usePointer = Prefs.getBoolean("pcursor", false);
    protected ImagePlus imp;
    protected boolean imageUpdated;
    private ImageJ ij;
    private int imageWidth;
    private int imageHeight;
    private double magnification;
    private Rectangle srcRect;
    private int dstWidth;
    private int dstHeight;
    private int xMouseStart = 0;
    private int yMouseStart = 0;
    private int xSrcStart = 0;
    private int ySrcStart = 0;
    private int xMouse = -1;
    private int yMouse = -1;
    int count;

    public void setDrawingSize(int n, int n2) {
        this.dstWidth = n;
        this.dstHeight = n2;
        this.setSize(this.dstWidth, this.dstHeight);
    }

    public void setImageUpdated() {
        this.imageUpdated = true;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void print(Graphics graphics, double d) {
        graphics.drawImage(this.imp.getImage(), 0, 0, (int)((double)this.imageWidth * d), (int)((double)this.imageHeight * d), 0, 0, this.imageWidth, this.imageHeight, null);
    }

    public void paint(Graphics graphics) {
        Roi roi = this.imp.getRoi();
        if (roi != null) {
            roi.updatePaste();
        }
        try {
            Image image;
            if (this.imageUpdated) {
                this.imageUpdated = false;
                this.imp.updateImage();
            }
            if ((image = this.imp.getImage()) != null) {
                graphics.drawImage(image, 0, 0, (int)((double)this.srcRect.width * this.magnification), (int)((double)this.srcRect.height * this.magnification), this.srcRect.x, this.srcRect.y, this.srcRect.x + this.srcRect.width, this.srcRect.y + this.srcRect.height, null);
            }
            if (roi != null) {
                roi.draw(graphics);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IJ.outOfMemory("Paint");
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.dstWidth, this.dstHeight);
    }

    public Point getCursorLoc() {
        return new Point(this.xMouse, this.yMouse);
    }

    public void setCursor(int n, int n2) {
        if (n != -1) {
            this.xMouse = n;
        }
        if (n2 != -1) {
            this.yMouse = n2;
        }
        Roi roi = this.imp.getRoi();
        ImageWindow imageWindow = this.imp.getWindow();
        if (imageWindow == null) {
            return;
        }
        if (IJ.spaceBarDown()) {
            this.setCursor(handCursor);
            return;
        }
        switch (Toolbar.getToolId()) {
            case 11: {
                if (IJ.isMacintosh()) {
                    this.setCursor(defaultCursor);
                    break;
                }
                this.setCursor(moveCursor);
                break;
            }
            case 12: {
                this.setCursor(handCursor);
                break;
            }
            default: {
                if (usePointer || roi != null && roi.getState() != Roi.CONSTRUCTING && roi.contains(n, n2)) {
                    this.setCursor(defaultCursor);
                    break;
                }
                this.setCursor(crosshairCursor);
            }
        }
    }

    public int offScreenX(int n) {
        return this.srcRect.x + (int)((double)n / this.magnification);
    }

    public int offScreenY(int n) {
        return this.srcRect.y + (int)((double)n / this.magnification);
    }

    public int screenX(int n) {
        return (int)((double)(n - this.srcRect.x) * this.magnification);
    }

    public int screenY(int n) {
        return (int)((double)(n - this.srcRect.y) * this.magnification);
    }

    public double getMagnification() {
        return this.magnification;
    }

    public void setMagnification(double d) {
        this.magnification = d;
        ImageWindow imageWindow = this.imp.getWindow();
        if (d > 1.0) {
            imageWindow.setTitle(this.imp.getTitle() + " (" + (int)d + ":1)");
        } else if (d < 1.0) {
            imageWindow.setTitle(this.imp.getTitle() + " (1:" + (int)(1.0 / d) + ")");
        } else {
            imageWindow.setTitle(this.imp.getTitle());
        }
    }

    public Rectangle getSrcRect() {
        return this.srcRect;
    }

    void resizeCanvas(int n, int n2) {
        if (this.srcRect.width < this.imageWidth || this.srcRect.height < this.imageHeight) {
            if ((double)n > (double)this.imageWidth * this.magnification) {
                n = (int)((double)this.imageWidth * this.magnification);
            }
            if ((double)n2 > (double)this.imageHeight * this.magnification) {
                n2 = (int)((double)this.imageHeight * this.magnification);
            }
            this.setDrawingSize(n, n2);
            this.srcRect.width = (int)((double)this.dstWidth / this.magnification);
            this.srcRect.height = (int)((double)this.dstHeight / this.magnification);
            if (this.srcRect.x + this.srcRect.width > this.imageWidth) {
                this.srcRect.x = this.imageWidth - this.srcRect.width;
            }
            if (this.srcRect.y + this.srcRect.height > this.imageHeight) {
                this.srcRect.y = this.imageHeight - this.srcRect.height;
            }
            this.repaint();
        }
    }

    public void zoomIn(int n, int n2) {
        if (this.magnification >= 32.0) {
            return;
        }
        double d = this.magnification * 2.0;
        if (1.0 / d == (double)this.imp.getWindow().getOriginalScale()) {
            this.unzoom();
            return;
        }
        int n3 = this.dstWidth * 2;
        int n4 = this.dstHeight * 2;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ImageWindow imageWindow = this.imp.getWindow();
        Point point = imageWindow.getLocationOnScreen();
        if (point.x + 50 + n3 < dimension.width && point.y + 50 + n4 < dimension.height) {
            this.setDrawingSize(n3, n4);
            imageWindow.pack();
        } else {
            int n5;
            int n6 = (int)Math.round((double)this.dstWidth / d);
            if ((double)n6 * d < (double)this.dstWidth) {
                ++n6;
            }
            if ((double)(n5 = (int)Math.round((double)this.dstHeight / d)) * d < (double)this.dstHeight) {
                ++n5;
            }
            n = this.offScreenX(n);
            n2 = this.offScreenY(n2);
            Rectangle rectangle = new Rectangle(n - n6 / 2, n2 - n5 / 2, n6, n5);
            if (rectangle.x < 0) {
                rectangle.x = 0;
            }
            if (rectangle.y < 0) {
                rectangle.y = 0;
            }
            if (rectangle.x + n6 > this.imageWidth) {
                rectangle.x = this.imageWidth - n6;
            }
            if (rectangle.y + n5 > this.imageHeight) {
                rectangle.y = this.imageHeight - n5;
            }
            this.srcRect = rectangle;
        }
        this.setMagnification(d);
        this.repaint();
    }

    public void zoomOut(int n, int n2) {
        if (this.magnification <= 0.03125) {
            return;
        }
        double d = this.magnification / 2.0;
        if (d == 1.0) {
            this.unzoom();
            return;
        }
        if (this.srcRect.width <= this.imageWidth / 2) {
            int n3;
            int n4 = (int)Math.round((double)this.dstWidth / d);
            if ((double)n4 * d < (double)this.dstWidth) {
                ++n4;
            }
            if ((double)(n3 = (int)Math.round((double)this.dstHeight / d)) * d < (double)this.dstHeight) {
                ++n3;
            }
            n = this.offScreenX(n);
            n2 = this.offScreenY(n2);
            Rectangle rectangle = new Rectangle(n - n4 / 2, n2 - n3 / 2, n4, n3);
            if (rectangle.x < 0) {
                rectangle.x = 0;
            }
            if (rectangle.y < 0) {
                rectangle.y = 0;
            }
            if (rectangle.x + n4 > this.imageWidth) {
                rectangle.x = this.imageWidth - n4;
            }
            if (rectangle.y + n3 > this.imageHeight) {
                rectangle.y = this.imageHeight - n3;
            }
            this.srcRect = rectangle;
        } else {
            this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
            this.setDrawingSize((int)((double)this.imageWidth * d), (int)((double)this.imageHeight * d));
            this.imp.getWindow().pack();
        }
        this.setMagnification(d);
        this.repaint();
    }

    void unzoom() {
        if (this.magnification == 1.0) {
            return;
        }
        this.setMagnification(1.0);
        this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
        ImageWindow imageWindow = this.imp.getWindow();
        int n = imageWindow.getOriginalScale();
        this.setMagnification(1.0 / (double)n);
        this.setDrawingSize(this.imageWidth / n, this.imageHeight / n);
        imageWindow.pack();
        this.repaint();
    }

    void scroll(int n, int n2) {
        int n3 = this.xSrcStart + (int)((double)n / this.magnification);
        int n4 = this.ySrcStart + (int)((double)n2 / this.magnification);
        int n5 = this.xSrcStart + (this.xMouseStart - n3);
        int n6 = this.ySrcStart + (this.yMouseStart - n4);
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n5 + this.srcRect.width > this.imageWidth) {
            n5 = this.imageWidth - this.srcRect.width;
        }
        if (n6 + this.srcRect.height > this.imageHeight) {
            n6 = this.imageHeight - this.srcRect.height;
        }
        this.srcRect.x = n5;
        this.srcRect.y = n6;
        this.imp.draw();
        Thread.yield();
    }

    Color getColor(int n) {
        IndexColorModel indexColorModel = (IndexColorModel)this.imp.getProcessor().getColorModel();
        return new Color(indexColorModel.getRGB(n));
    }

    protected void setDrawingColor(int n, int n2, boolean bl) {
        Color color;
        int n3 = this.imp.getType();
        int[] nArray = this.imp.getPixel(n, n2);
        switch (n3) {
            case 0: {
                if (bl) {
                    Toolbar.setBackgroundColor(this.getColor(nArray[0]));
                    break;
                }
                Toolbar.setForegroundColor(this.getColor(nArray[0]));
                break;
            }
            case 1: 
            case 2: {
                double d = this.imp.getProcessor().getMin();
                double d2 = this.imp.getProcessor().getMax();
                double d3 = n3 == 2 ? Float.intBitsToFloat(nArray[0]) : (float)nArray[0];
                int n4 = (int)(255.0 * ((d3 - d) / (d2 - d)));
                if (n4 < 0) {
                    n4 = 0;
                }
                if (n4 > 255) {
                    n4 = 255;
                }
                if (bl) {
                    Toolbar.setBackgroundColor(this.getColor(n4));
                    break;
                }
                Toolbar.setForegroundColor(this.getColor(n4));
                break;
            }
            case 3: 
            case 4: {
                Color color2 = new Color(nArray[0], nArray[1], nArray[2]);
                if (bl) {
                    Toolbar.setBackgroundColor(color2);
                    break;
                }
                Toolbar.setForegroundColor(color2);
                break;
            }
        }
        if (bl) {
            color = Toolbar.getBackgroundColor();
        } else {
            color = Toolbar.getForegroundColor();
            this.imp.setColor(color);
        }
        IJ.showStatus("(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")");
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.ij == null) {
            return;
        }
        int n = Toolbar.getToolId();
        ImageWindow imageWindow = this.imp.getWindow();
        if (imageWindow != null && imageWindow.running && n != 11) {
            imageWindow.running = false;
            return;
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        int n4 = mouseEvent.getModifiers();
        if (IJ.debugMode) {
            IJ.write("Mouse pressed: (" + n2 + "," + n3 + ")" + ImageJ.modifiers(n4));
        }
        if (n != 11 && (mouseEvent.isPopupTrigger() || (n4 & InputEvent.META_MASK) != 0)) {
            PopupMenu popupMenu;
            if (IJ.debugMode) {
                IJ.write("show popup: " + (mouseEvent.isPopupTrigger() ? "true" : "false"));
            }
            if ((popupMenu = Menus.getPopupMenu()) != null) {
                this.add(popupMenu);
                popupMenu.show(this, n2, n3);
            }
            return;
        }
        int n5 = this.offScreenX(n2);
        int n6 = this.offScreenY(n3);
        if (IJ.spaceBarDown()) {
            this.xMouseStart = n5;
            this.yMouseStart = n6;
            this.xSrcStart = this.srcRect.x;
            this.ySrcStart = this.srcRect.y;
            return;
        }
        if ((n4 & 8) != 0 && n != 11 && n != 13) {
            this.setDrawingColor(n5, n6, false);
            return;
        }
        switch (n) {
            case 11: {
                if ((n4 & 0xE) != 0) {
                    this.zoomOut(n2, n3);
                    break;
                }
                this.zoomIn(n2, n3);
                break;
            }
            case 12: {
                this.xMouseStart = n5;
                this.yMouseStart = n6;
                this.xSrcStart = this.srcRect.x;
                this.ySrcStart = this.srcRect.y;
                break;
            }
            case 13: {
                this.setDrawingColor(n5, n6, IJ.altKeyDown());
                break;
            }
            case 7: {
                this.xMouse = n5;
                this.yMouse = n6;
                IJ.doCommand("Measure");
                break;
            }
            case 8: {
                Object object;
                Roi roi = this.imp.getRoi();
                if (roi != null && roi.contains(n5, n6)) {
                    object = roi.getBoundingRect();
                    if (((Rectangle)object).width == this.imageWidth && ((Rectangle)object).height == this.imageHeight) {
                        this.imp.killRoi();
                    } else {
                        this.handleRoiMouseDown(n2, n3);
                        return;
                    }
                }
                if (this.imp.getType() == 1 || this.imp.getType() == 2) {
                    IJ.error("The wand tool does not work with 16 and 32-bit grayscale images.");
                    return;
                }
                object = this.imp.getProcessor();
                Wand wand = new Wand((ImageProcessor)object);
                double d = ((ImageProcessor)object).getMinThreshold();
                if (d == ImageProcessor.NO_THRESHOLD) {
                    wand.autoOutline(n5, n6);
                } else {
                    wand.autoOutline(n5, n6, (int)d, (int)((ImageProcessor)object).getMaxThreshold());
                }
                if (wand.npoints <= 0) break;
                roi = new PolygonRoi(wand.xpoints, wand.ypoints, wand.npoints, this.imp, 4);
                this.imp.setRoi(roi);
                break;
            }
            default: {
                this.handleRoiMouseDown(n2, n3);
            }
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        ImageWindow imageWindow = this.imp.getWindow();
        if (imageWindow != null) {
            this.setCursor(defaultCursor);
        }
        this.xMouse = -1;
        this.yMouse = -1;
        IJ.showStatus("");
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (Toolbar.getToolId() == 12 || IJ.spaceBarDown()) {
            this.scroll(n, n2);
        } else {
            Roi roi = this.imp.getRoi();
            if (roi != null) {
                roi.handleMouseDrag(n, n2, (mouseEvent.getModifiers() & InputEvent.SHIFT_MASK) != 0);
            }
        }
    }

    void handleRoiMouseDown(int n, int n2) {
        int n3 = this.offScreenX(n);
        int n4 = this.offScreenY(n2);
        Roi roi = this.imp.getRoi();
        if (roi != null) {
            Rectangle rectangle = roi.getBoundingRect();
            int n5 = roi.getType();
            if (n5 == 0 && rectangle.width == this.imp.getWidth() && rectangle.height == this.imp.getHeight()) {
                this.imp.killRoi();
                return;
            }
            if (roi.contains(n3, n4)) {
                roi.handleMouseDown(n, n2);
                return;
            }
            if ((roi.getType() == 2 || roi.getType() == 6) && roi.getState() == Roi.CONSTRUCTING) {
                return;
            }
        }
        this.imp.createNewRoi(n3, n4);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Roi roi = this.imp.getRoi();
        if (roi != null) {
            Rectangle rectangle = roi.getBoundingRect();
            if ((rectangle.width == 0 || rectangle.height == 0) && roi.getType() != 2 && roi.getType() != 6 && roi.getState() == Roi.CONSTRUCTING) {
                this.imp.killRoi();
            } else {
                roi.handleMouseUp(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.ij == null) {
            return;
        }
        int n = this.offScreenX(mouseEvent.getX());
        int n2 = this.offScreenY(mouseEvent.getY());
        this.setCursor(n, n2);
        Roi roi = this.imp.getRoi();
        if (roi != null && (roi.getType() == 2 || roi.getType() == 6) && roi.getState() == Roi.CONSTRUCTING) {
            PolygonRoi polygonRoi = (PolygonRoi)roi;
            polygonRoi.handleMouseMove(n, n2);
        } else if (n < this.imageWidth && n2 < this.imageHeight) {
            ImageWindow imageWindow = this.imp.getWindow();
            if (imageWindow != null) {
                imageWindow.mouseMoved(n, n2);
            }
        } else {
            IJ.showStatus("");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public ImageCanvas(ImagePlus imagePlus) {
        this.imp = imagePlus;
        this.ij = IJ.getInstance();
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        this.imageWidth = n;
        this.imageHeight = n2;
        this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
        this.setDrawingSize(n, n2);
        this.magnification = 1.0;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this.ij);
    }
}

