/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.gui.GUI;
import ij.gui.ImageWindow;
import ij.measure.Measurements;
import ij.plugin.filter.Analyzer;
import ij.process.ImageStatistics;
import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.CharArrayWriter;
import java.io.PrintWriter;

public class HistogramWindow
extends ImageWindow
implements Measurements,
ActionListener,
ClipboardOwner {
    static final int WIN_WIDTH = 300;
    static final int WIN_HEIGHT = 240;
    static final int HIST_WIDTH = 256;
    static final int HIST_HEIGHT = 128;
    static final int BAR_HEIGHT = 12;
    static final int XMARGIN = 20;
    static final int YMARGIN = 10;
    protected static String defaultDirectory = null;
    public static int nBins = 256;
    protected ImageStatistics stats;
    protected float[] cTable;
    protected int[] histogram;
    protected LookUpTable lut;
    protected Rectangle frame = null;
    protected Image img;
    protected Button list;
    protected Button save;
    protected Button copy;
    protected Label value;
    protected Label count;
    protected int decimalPlaces;

    public void showHistogram(ImagePlus imagePlus, int n) {
        this.setup();
        this.stats = imagePlus.getStatistics(27, n);
        this.histogram = this.stats.histogram;
        this.lut = imagePlus.createLut();
        this.img = this.imp.getImage();
        int n2 = imagePlus.getType();
        this.cTable = imagePlus.getCalibration().getCTable();
        boolean bl = n2 == 0 || n2 == 3 || n2 == 4;
        Graphics graphics = this.img.getGraphics();
        if (graphics != null) {
            this.drawHistogram(graphics, bl);
            graphics.dispose();
        }
        this.imp.setImage(this.img);
        this.imp.draw();
    }

    public void setup() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(2));
        this.list = new Button(" List ");
        this.list.addActionListener(this);
        panel.add(this.list);
        this.copy = new Button("Copy...");
        this.copy.addActionListener(this);
        panel.add(this.copy);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(2, 1));
        this.value = new Label("                     ");
        this.value.setFont(new Font("Monospaced", 0, 12));
        panel2.add(this.value);
        this.count = new Label("                     ");
        this.count.setFont(new Font("Monospaced", 0, 12));
        panel2.add(this.count);
        panel.add(panel2);
        this.add(panel);
        this.pack();
    }

    public void mouseMoved(int n, int n2) {
        if (this.value == null || this.count == null) {
            return;
        }
        if (this.frame != null && n >= this.frame.x && n <= this.frame.x + this.frame.width) {
            double d;
            if ((n -= this.frame.x) > 255) {
                n = 255;
            }
            int n3 = (int)((double)n * (double)this.histogram.length / 256.0);
            double d2 = d = this.cTable != null && this.cTable.length == 256 ? (double)this.cTable[n3] : this.stats.histMin + (double)n3 * this.stats.binSize;
            if (this.stats.binSize != 1.0) {
                d += this.stats.binSize / 2.0;
            }
            if (d == (double)((int)d)) {
                this.value.setText("  Value: " + (int)d);
            } else {
                this.value.setText("  Value: " + IJ.d2s(d, this.decimalPlaces));
            }
            this.count.setText("  Count: " + this.histogram[n3]);
        } else {
            this.value.setText("");
            this.count.setText("");
        }
    }

    protected void drawHistogram(Graphics graphics, boolean bl) {
        int n = 0;
        int n2 = 0;
        graphics.setColor(Color.black);
        this.decimalPlaces = Analyzer.getPrecision();
        int n3 = this.histogram[this.stats.mode];
        int n4 = 0;
        while (n4 < this.histogram.length) {
            if (this.histogram[n4] > n && n4 != this.stats.mode) {
                n = this.histogram[n4];
                n2 = n4;
            }
            ++n4;
        }
        int n5 = this.stats.maxCount;
        if (n5 > n * 2 && n != 0) {
            this.histogram[this.stats.mode] = n5 = (int)((double)n * 1.5);
        }
        this.frame = new Rectangle(20, 10, 256, 128);
        graphics.drawRect(this.frame.x, this.frame.y, this.frame.width, this.frame.height);
        int n6 = 21;
        int n7 = 0;
        while (n7 < 256) {
            int n8 = (int)((double)n7 * (double)this.histogram.length / 256.0);
            n4 = this.histogram[n8];
            graphics.drawLine(n7 + 20, 138, n7 + 20, 138 - 128 * n4 / n5);
            ++n7;
        }
        this.histogram[this.stats.mode] = n3;
        int n9 = 140;
        this.lut.drawUnscaledColorBar(graphics, n6, n9, 256, 12);
        n9 += 12;
        n9 += 15;
        double d = this.stats.histMin;
        double d2 = this.stats.histMax;
        if (this.cTable != null && this.cTable.length == 256) {
            d = this.cTable[(int)d];
            d2 = this.cTable[(int)d2];
        }
        graphics.drawString(this.d2s(d), n6 - 4, n9);
        graphics.drawString(this.d2s(d2), n6 + 256 - this.getWidth(d2, graphics) + 10, n9);
        boolean bl2 = this.stats.nBins != 256 || !bl;
        int n10 = 25;
        int n11 = 148;
        int n12 = n9 + 25;
        if (bl2) {
            n12 -= 8;
        }
        int n13 = n12 + 15;
        int n14 = n13 + 15;
        int n15 = n14 + 15;
        graphics.drawString("Count: " + this.stats.pixelCount, n10, n12);
        graphics.drawString("Mean: " + this.d2s(this.stats.mean), n10, n13);
        graphics.drawString("StdDev: " + this.d2s(this.stats.stdDev), n10, n14);
        graphics.drawString("Mode: " + this.d2s(this.stats.dmode) + " (" + this.stats.maxCount + ")", n11, n14);
        graphics.drawString("Min: " + this.d2s(this.stats.min), n11, n12);
        graphics.drawString("Max: " + this.d2s(this.stats.max), n11, n13);
        if (bl2) {
            graphics.drawString("Bins: " + this.d2s(this.stats.nBins), n10, n15);
            graphics.drawString("Bin Width: " + this.d2s(this.stats.binSize), n11, n15);
        }
    }

    String d2s(double d) {
        if ((double)((int)d) == d) {
            return IJ.d2s(d, 0);
        }
        return IJ.d2s(d, this.decimalPlaces);
    }

    int getWidth(double d, Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        return fontMetrics.stringWidth(this.d2s(d));
    }

    void showList() {
        IJ.setColumnHeadings("value\tcount");
        if (this.stats.binSize == 1.0) {
            int n = 0;
            while (n < this.stats.nBins) {
                IJ.write(n + "\t" + this.histogram[n]);
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.stats.nBins) {
                IJ.write(IJ.d2s(this.stats.histMin + (double)n * this.stats.binSize + this.stats.binSize / 2.0, this.decimalPlaces) + "\t" + this.histogram[n]);
                ++n;
            }
        }
    }

    void copyToClipboard() {
        int n;
        Clipboard clipboard = null;
        try {
            clipboard = this.getToolkit().getSystemClipboard();
        }
        catch (Exception exception) {
            clipboard = null;
        }
        if (clipboard == null) {
            IJ.error("Unable to copy to Clipboard.");
            return;
        }
        IJ.showStatus("Copying histogram values...");
        CharArrayWriter charArrayWriter = new CharArrayWriter(this.stats.nBins * 4);
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        if (this.stats.binSize == 1.0) {
            n = 0;
            while (n < this.stats.nBins) {
                printWriter.print(n + "\t" + this.histogram[n] + "\n");
                ++n;
            }
        } else {
            n = 0;
            while (n < this.stats.nBins) {
                printWriter.print(IJ.d2s(this.stats.histMin + (double)n * this.stats.binSize + this.stats.binSize / 2.0, this.decimalPlaces) + "\t" + this.histogram[n] + "\n");
                ++n;
            }
        }
        String string = charArrayWriter.toString();
        printWriter.close();
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, this);
        IJ.showStatus(string.length() + " characters copied to Clipboard");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.list) {
            this.showList();
        } else {
            this.copyToClipboard();
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public HistogramWindow(ImagePlus imagePlus) {
        super(new ImagePlus("Histogram", GUI.createBlankImage(300, 240)));
        this.showHistogram(imagePlus, nBins);
    }

    public HistogramWindow(String string, ImagePlus imagePlus, int n) {
        super(new ImagePlus(string, GUI.createBlankImage(300, 240)));
        this.showHistogram(imagePlus, n);
    }
}

