/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.MultiLineLabel;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class GenericDialog
extends Dialog
implements ActionListener {
    public static final int MAX_ITEMS = 20;
    private TextField[] numberField;
    private double[] defaultValues;
    private String[] defaultText;
    private TextField[] stringField;
    private Checkbox[] checkbox;
    private Choice[] choice;
    private Button cancel;
    private Button okay;
    private TextArea textArea1;
    private TextArea textArea2;
    private boolean wasCanceled;
    private int y;
    private int nfIndex;
    private int sfIndex;
    private int cbIndex;
    private int choiceIndex;
    private GridBagLayout grid = new GridBagLayout();
    private GridBagConstraints c = new GridBagConstraints();
    private boolean firstNumericField = true;
    private boolean firstStringField = true;
    private boolean firstCheckbox = true;
    private boolean firstChoice = true;
    private boolean invalidNumber;
    private boolean firstPaint = true;

    public void addNumericField(String string, double d, int n) {
        Label label = this.makeLabel(string);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        this.c.insets = this.firstNumericField ? new Insets(5, 0, 3, 0) : new Insets(0, 0, 3, 0);
        this.grid.setConstraints(label, this.c);
        this.add(label);
        if (this.numberField == null) {
            this.numberField = new TextField[20];
            this.defaultValues = new double[20];
            this.defaultText = new String[20];
        }
        this.numberField[this.nfIndex] = new TextField(IJ.d2s(d, n), 6);
        this.numberField[this.nfIndex].addActionListener(this);
        this.defaultValues[this.nfIndex] = d;
        this.defaultText[this.nfIndex] = this.numberField[this.nfIndex].getText();
        this.c.gridx = 1;
        this.c.gridy = this.y;
        this.c.anchor = 17;
        this.grid.setConstraints(this.numberField[this.nfIndex], this.c);
        this.numberField[this.nfIndex].setEditable(true);
        if (this.firstNumericField) {
            this.numberField[this.nfIndex].selectAll();
        }
        this.firstNumericField = false;
        this.add(this.numberField[this.nfIndex]);
        ++this.y;
        ++this.nfIndex;
    }

    private Label makeLabel(String string) {
        if (IJ.isMacintosh()) {
            string = string + " ";
        }
        return new Label(string);
    }

    public void addStringField(String string, String string2) {
        this.addStringField(string, string2, 8);
    }

    public void addStringField(String string, String string2, int n) {
        Label label = this.makeLabel(string);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        this.c.insets = this.firstStringField ? new Insets(5, 0, 5, 0) : new Insets(0, 0, 5, 0);
        this.grid.setConstraints(label, this.c);
        this.add(label);
        if (this.stringField == null) {
            this.stringField = new TextField[20];
        }
        this.stringField[this.sfIndex] = new TextField(string2, n);
        this.stringField[this.sfIndex].addActionListener(this);
        this.c.gridx = 1;
        this.c.gridy = this.y++;
        this.c.anchor = 17;
        this.grid.setConstraints(this.stringField[this.sfIndex], this.c);
        this.stringField[this.sfIndex].setEditable(true);
        this.add(this.stringField[this.sfIndex]);
        ++this.sfIndex;
    }

    public void addCheckbox(String string, boolean bl) {
        if (this.checkbox == null) {
            this.checkbox = new Checkbox[20];
        }
        this.checkbox[this.cbIndex] = new Checkbox(string);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.c.insets = this.firstCheckbox ? new Insets(15, 20, 0, 0) : new Insets(0, 20, 0, 0);
        this.firstCheckbox = false;
        this.grid.setConstraints(this.checkbox[this.cbIndex], this.c);
        this.checkbox[this.cbIndex].setState(bl);
        this.add(this.checkbox[this.cbIndex]);
        ++this.y;
        ++this.cbIndex;
    }

    public void addCheckboxGroup(int n, int n2, String[] stringArray, boolean[] blArray) {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(n, n2, 10, 0));
        int n3 = this.cbIndex;
        int n4 = 0;
        int[] nArray = new int[stringArray.length];
        if (this.checkbox == null) {
            this.checkbox = new Checkbox[20];
        }
        int n5 = 0;
        while (n5 < n) {
            int n6 = 0;
            while (n6 < n2) {
                int n7 = n6 * n + n5;
                if (n7 >= stringArray.length) break;
                nArray[n4] = n7;
                this.checkbox[this.cbIndex] = new Checkbox(stringArray[n4]);
                this.checkbox[this.cbIndex].setState(blArray[n4]);
                ++this.cbIndex;
                ++n4;
                ++n6;
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < n4) {
            panel.add(this.checkbox[n3 + nArray[n5]]);
            ++n5;
        }
        this.c.gridx = 0;
        this.c.gridy = this.y++;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(10, 0, 0, 0);
        this.grid.setConstraints(panel, this.c);
        this.add(panel);
    }

    public void addChoice(String string, String[] stringArray, String string2) {
        Label label = this.makeLabel(string);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        this.c.insets = this.firstChoice ? new Insets(5, 0, 5, 0) : new Insets(0, 0, 5, 0);
        this.grid.setConstraints(label, this.c);
        this.add(label);
        if (this.choice == null) {
            this.choice = new Choice[20];
        }
        this.choice[this.choiceIndex] = new Choice();
        int n = 0;
        while (n < stringArray.length) {
            this.choice[this.choiceIndex].addItem(stringArray[n]);
            ++n;
        }
        this.choice[this.choiceIndex].select(string2);
        this.c.gridx = 1;
        this.c.gridy = this.y++;
        this.c.anchor = 17;
        this.grid.setConstraints(this.choice[this.choiceIndex], this.c);
        this.firstChoice = false;
        this.add(this.choice[this.choiceIndex]);
        ++this.choiceIndex;
    }

    public void addMessage(String string) {
        Component component = string.indexOf(10) >= 0 ? new MultiLineLabel(string) : new Label(string);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(string.equals("") ? 0 : 10, 20, 0, 0);
        this.grid.setConstraints(component, this.c);
        this.add(component);
        ++this.y;
    }

    public void addTextAreas(String string, String string2, int n, int n2) {
        if (this.textArea1 != null) {
            return;
        }
        Panel panel = new Panel();
        this.textArea1 = new TextArea(string, n, n2, 3);
        panel.add(this.textArea1);
        if (string2 != null) {
            this.textArea2 = new TextArea(string2, n, n2, 3);
            panel.add(this.textArea2);
        }
        this.c.gridx = 0;
        this.c.gridy = this.y++;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(15, 20, 0, 0);
        this.grid.setConstraints(panel, this.c);
        this.add(panel);
    }

    public boolean wasCanceled() {
        return this.wasCanceled;
    }

    public double getNextNumber() {
        Double d;
        if (this.numberField == null || this.numberField[this.nfIndex] == null) {
            return -1.0;
        }
        String string = this.numberField[this.nfIndex].getText();
        String string2 = this.defaultText[this.nfIndex];
        double d2 = this.defaultValues[this.nfIndex];
        ++this.nfIndex;
        if (string.equals(string2)) {
            return d2;
        }
        try {
            d = new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        this.invalidNumber = true;
        return 0.0;
    }

    public boolean invalidNumber() {
        boolean bl = this.invalidNumber;
        this.invalidNumber = false;
        return bl;
    }

    public String getNextString() {
        if (this.stringField == null || this.stringField[this.sfIndex] == null) {
            return "";
        }
        return this.stringField[this.sfIndex++].getText();
    }

    public boolean getNextBoolean() {
        if (this.checkbox == null || this.checkbox[this.cbIndex] == null) {
            return false;
        }
        return this.checkbox[this.cbIndex++].getState();
    }

    public String getNextChoice() {
        if (this.choice == null || this.choice[this.choiceIndex] == null) {
            return "";
        }
        return this.choice[this.choiceIndex++].getSelectedItem();
    }

    public int getNextChoiceIndex() {
        if (this.choice == null || this.choice[this.choiceIndex] == null) {
            return -1;
        }
        return this.choice[this.choiceIndex++].getSelectedIndex();
    }

    public String getNextText() {
        String string;
        if (this.textArea1 != null) {
            this.textArea1.selectAll();
            string = this.textArea1.getText();
            this.textArea1 = null;
        } else if (this.textArea2 != null) {
            this.textArea2.selectAll();
            string = this.textArea2.getText();
            this.textArea2 = null;
        } else {
            string = null;
        }
        return string;
    }

    public void showDialog() {
        if (this.stringField != null && this.stringField[0] != null && this.numberField == null) {
            this.stringField[0].selectAll();
        }
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1, 5, 0));
        this.cancel = new Button("Cancel");
        this.cancel.addActionListener(this);
        panel.add(this.cancel);
        this.okay = new Button("  OK  ");
        this.okay.addActionListener(this);
        panel.add(this.okay);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 2;
        this.c.insets = new Insets(20, 0, 0, 0);
        this.grid.setConstraints(panel, this.c);
        this.add(panel);
        this.nfIndex = 0;
        this.sfIndex = 0;
        this.cbIndex = 0;
        this.choiceIndex = 0;
        this.pack();
        GUI.center(this);
        ((Component)this).setVisible(true);
        IJ.wait(250);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.wasCanceled = actionEvent.getSource() == this.cancel;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public Insets getInsets() {
        return new Insets(40, 20, 20, 20);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.firstPaint && this.numberField != null && this.numberField[0] != null) {
            this.numberField[0].requestFocus();
        }
        this.firstPaint = false;
    }

    public GenericDialog(String string) {
        super(WindowManager.getCurrentImage() != null ? WindowManager.getCurrentImage().getWindow() : IJ.getInstance(), string, true);
        this.setLayout(this.grid);
    }

    public GenericDialog(String string, Frame frame) {
        super(frame, string, true);
        this.setLayout(this.grid);
    }
}

