/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.Converter;
import ij.IJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Undo;
import ij.gui.ImageWindow;
import java.awt.CheckboxMenuItem;
import java.awt.MenuItem;
import java.util.Vector;

public class WindowManager {
    private static Vector windowList = new Vector();
    private static ImageWindow currentWindow = null;

    public static synchronized void setCurrentWindow(ImageWindow imageWindow) {
        ImagePlus imagePlus;
        if (imageWindow == currentWindow || imageWindow == null || windowList.size() == 0) {
            return;
        }
        if (IJ.debugMode && imageWindow != null) {
            IJ.write(imageWindow.getImagePlus().getTitle() + ": setCurrentWindow (previous=" + (currentWindow != null ? currentWindow.getImagePlus().getTitle() : "null") + ")");
        }
        if (currentWindow != null && (imagePlus = currentWindow.getImagePlus()) != null && imagePlus.lockSilently()) {
            imagePlus.trimProcessor();
            if (!Converter.newWindowCreated) {
                imagePlus.saveRoi();
            }
            Converter.newWindowCreated = false;
            imagePlus.unlock();
        }
        Undo.reset();
        currentWindow = !imageWindow.isClosed() && imageWindow.getImagePlus() != null ? imageWindow : null;
        Menus.updateMenus();
    }

    public static ImageWindow getCurrentWindow() {
        if (IJ.debugMode) {
            IJ.write("ImageWindow.getCurrentWindow");
        }
        return currentWindow;
    }

    static int getCurrentIndex() {
        return windowList.indexOf(currentWindow);
    }

    public static synchronized ImagePlus getCurrentImage() {
        if (IJ.debugMode) {
            IJ.write("ImageWindow.getCurrentImage");
        }
        if (currentWindow != null) {
            return currentWindow.getImagePlus();
        }
        return null;
    }

    public static int getWindowCount() {
        return windowList.size();
    }

    public static synchronized int[] getIDList() {
        int n = windowList.size();
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            ImageWindow imageWindow = (ImageWindow)windowList.elementAt(n2);
            nArray[n2] = imageWindow.getImagePlus().getID();
            ++n2;
        }
        return nArray;
    }

    public static synchronized ImagePlus getImage(int n) {
        if (IJ.debugMode) {
            IJ.write("ImageWindow.getImage");
        }
        if (n >= 0) {
            return null;
        }
        ImagePlus imagePlus = null;
        int n2 = 0;
        while (n2 < windowList.size()) {
            ImageWindow imageWindow = (ImageWindow)windowList.elementAt(n2);
            ImagePlus imagePlus2 = imageWindow.getImagePlus();
            if (n == imagePlus2.getID()) {
                imagePlus = imagePlus2;
                break;
            }
            ++n2;
        }
        return imagePlus;
    }

    public static synchronized void addWindow(ImageWindow imageWindow) {
        if (IJ.debugMode) {
            IJ.write(imageWindow.getImagePlus().getTitle() + ": addWindow");
        }
        windowList.addElement(imageWindow);
        Menus.extendWindowMenu(imageWindow.getImagePlus());
        WindowManager.setCurrentWindow(imageWindow);
    }

    public static synchronized void removeWindow(ImageWindow imageWindow) {
        int n;
        int n2;
        if (IJ.debugMode) {
            IJ.write(imageWindow.getImagePlus().getTitle() + ": removeWindow (" + windowList.size() + ")");
        }
        if ((n2 = windowList.indexOf(imageWindow)) == -1) {
            return;
        }
        if (windowList.size() > 1) {
            n = n2 - 1;
            if (n < 0) {
                n = windowList.size() - 1;
            }
            WindowManager.setCurrentWindow((ImageWindow)windowList.elementAt(n));
        } else {
            currentWindow = null;
        }
        Menus.trimWindowMenu(windowList.size() - n2);
        windowList.removeElementAt(n2);
        n = n2;
        while (n < windowList.size()) {
            ImageWindow imageWindow2 = (ImageWindow)windowList.elementAt(n);
            Menus.extendWindowMenu(imageWindow2.getImagePlus());
            ++n;
        }
        Menus.updateMenus();
        Undo.reset();
    }

    public static synchronized boolean closeAllWindows() {
        while (windowList.size() > 0) {
            ImagePlus imagePlus = ((ImageWindow)windowList.elementAt(0)).getImagePlus();
            if (!((ImageWindow)windowList.elementAt(0)).close()) {
                return false;
            }
            IJ.wait(100);
        }
        return true;
    }

    public static void putBehind() {
        if (IJ.debugMode) {
            IJ.write("putBehind");
        }
        if (windowList.size() < 1 || currentWindow == null) {
            return;
        }
        int n = windowList.indexOf(currentWindow);
        if (--n < 0) {
            n = windowList.size() - 1;
        }
        ImageWindow imageWindow = (ImageWindow)windowList.elementAt(n);
        WindowManager.setCurrentWindow(imageWindow);
        imageWindow.toFront();
        Menus.updateMenus();
    }

    static synchronized void activateWindow(String string, MenuItem menuItem) {
        int n = 0;
        while (n < windowList.size()) {
            ImageWindow imageWindow = (ImageWindow)windowList.elementAt(n);
            if (string.startsWith(imageWindow.getImagePlus().getTitle())) {
                WindowManager.setCurrentWindow(imageWindow);
                imageWindow.toFront();
                int n2 = windowList.indexOf(imageWindow);
                int n3 = Menus.window.getItemCount();
                int n4 = 3;
                while (n4 < n3) {
                    MenuItem menuItem2 = Menus.window.getItem(n4);
                    ((CheckboxMenuItem)menuItem2).setState(n4 - 3 == n2);
                    ++n4;
                }
                break;
            }
            ++n;
        }
    }

    static void showList() {
        if (IJ.debugMode) {
            int n = 0;
            while (n < windowList.size()) {
                ImageWindow imageWindow = (ImageWindow)windowList.elementAt(n);
                ImagePlus imagePlus = imageWindow.getImagePlus();
                IJ.write(n + " " + imagePlus.getTitle() + (imageWindow == currentWindow ? "*" : ""));
                ++n;
            }
            IJ.write(" ");
        }
    }
}

