/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Roi;
import java.awt.Image;

public class Undo {
    public static final int NOTHING = 0;
    public static final int FILTER = 1;
    public static final int TYPE_CONVERSION = 2;
    public static final int PASTE = 3;
    public static final int TRANSFORMATION = 4;
    private static int whatToUndo = 0;
    private static ImagePlus imp = null;
    private static Image imageCopy = null;

    public static void setup(int n, ImagePlus imagePlus) {
        whatToUndo = n;
        imp = imagePlus;
        imageCopy = n == 2 ? imp.getImage() : null;
        if (IJ.debugMode) {
            IJ.write(imp.getTitle() + ": set up undo (" + n + ")");
        }
    }

    public static void reset() {
        whatToUndo = 0;
        if (imp != null) {
            imp.trimProcessor();
        }
        imp = null;
        imageCopy = null;
        if (IJ.debugMode) {
            IJ.write("Undo: reset");
        }
    }

    public static void undo() {
        if (imp != WindowManager.getCurrentImage() && whatToUndo != 4) {
            imp = null;
        }
        if (imp == null) {
            Undo.reset();
            return;
        }
        switch (whatToUndo) {
            case 1: {
                imp.undoFilter();
                break;
            }
            case 2: {
                imp.setImage(imageCopy);
                imp.repaintWindow();
                if (!IJ.debugMode) break;
                IJ.write(imp.getTitle() + ": undo type conversion");
                break;
            }
            case 3: {
                Roi roi = imp.getRoi();
                if (roi == null) break;
                roi.abortPaste();
                break;
            }
            case 4: {
                ImagePlus imagePlus = WindowManager.getCurrentImage();
                if (imagePlus != null && !imagePlus.changes) {
                    imagePlus.getWindow().close();
                }
                new ImagePlus(imp.getTitle(), imp.getProcessor()).show();
                break;
            }
        }
        Undo.reset();
    }
}

