/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.util.StringSorter;
import java.applet.Applet;
import java.awt.CheckboxMenuItem;
import java.awt.Font;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.PopupMenu;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class Menus {
    public static final char PLUGINS_MENU = 'p';
    public static final char IMPORT_MENU = 'i';
    public static final char SAVE_AS_MENU = 's';
    public static final char SHORTCUTS_MENU = 'h';
    public static final char ABOUT_MENU = 'a';
    public static final char FILTERS_MENU = 'f';
    public static final char TOOLS_MENU = 't';
    public static final char UTILITIES_MENU = 'u';
    public static final int WINDOW_MENU_ITEMS = 3;
    public static final int NORMAL_RETURN = 0;
    public static final int COMMAND_IN_USE = -1;
    public static final int INVALID_SHORTCUT = -2;
    public static final int SHORTCUT_IN_USE = -3;
    public static final int NOT_INSTALLED = -4;
    public static final int COMMAND_NOT_FOUND = -5;
    private static MenuBar mbar;
    private static CheckboxMenuItem gray8Item;
    private static CheckboxMenuItem gray16Item;
    private static CheckboxMenuItem gray32Item;
    private static CheckboxMenuItem color256Item;
    private static CheckboxMenuItem colorRGBItem;
    private static CheckboxMenuItem RGBStackItem;
    private static CheckboxMenuItem HSBStackItem;
    private static PopupMenu popup;
    private static ImageJ ij;
    private static Applet applet;
    private static Hashtable demoImagesTable;
    private static String pluginsPath;
    private static Menu pluginsMenu;
    private static Menu importMenu;
    private static Menu saveAsMenu;
    private static Menu shortcutsMenu;
    private static Menu aboutMenu;
    private static Menu filtersMenu;
    private static Menu toolsMenu;
    private static Menu utilitiesMenu;
    private static Hashtable pluginsTable;
    static Menu window;
    static int nPlugins;
    private static Hashtable shortcuts;
    private static Vector pluginsPrefs;
    private static Font font;
    static String submenuName;
    static Menu submenu;
    static final int RGB_STACK = 10;
    static final int HSB_STACK = 11;

    Menu createMenu(String string) {
        Menu menu = new Menu(string);
        if (font != null) {
            menu.setFont(font);
        }
        return menu;
    }

    void addMenuBar() {
        Menu menu = this.createMenu("File");
        this.addItem(menu, "New...", 78, false);
        this.addItem(menu, "Open...", 79, false);
        this.addSubMenu(menu, "Open Samples");
        importMenu = this.addSubMenu(menu, "Import");
        menu.addSeparator();
        this.addItem(menu, "Close", 87, false);
        this.addItem(menu, "Save", 83, false);
        saveAsMenu = this.addSubMenu(menu, "Save As");
        this.addItem(menu, "Revert", 82, false);
        menu.addSeparator();
        this.addPlugInItem(menu, "Page Setup...", "ij.plugin.filter.Printer(\"setup\")", 0, false);
        this.addPlugInItem(menu, "Print...", "ij.plugin.filter.Printer(\"print\")", 80, false);
        menu.addSeparator();
        this.addItem(menu, "Quit", 0, false);
        Menu menu2 = this.createMenu("Edit");
        this.addItem(menu2, "Undo", 90, false);
        menu2.addSeparator();
        this.addItem(menu2, "Cut", 88, false);
        this.addItem(menu2, "Copy", 67, false);
        this.addItem(menu2, "Paste", 86, false);
        this.addPlugInItem(menu2, "Paste Control...", "ij.plugin.frame.PasteController", 0, false);
        this.addPlugInItem(menu2, "Clear", "ij.plugin.filter.Filler(\"clear\")", 0, false);
        this.addPlugInItem(menu2, "Clear Outside", "ij.plugin.filter.Filler(\"outside\")", 0, false);
        menu2.addSeparator();
        this.addItem(menu2, "Select All", 65, false);
        this.addItem(menu2, "Select None", 65, true);
        this.addItem(menu2, "Restore Selection", 69, true);
        menu2.addSeparator();
        this.addPlugInItem(menu2, "Fill", "ij.plugin.filter.Filler(\"fill\")", 70, false);
        this.addPlugInItem(menu2, "Draw", "ij.plugin.filter.Filler(\"draw\")", 68, false);
        this.addPlugInItem(menu2, "Invert", "ij.plugin.filter.Filters(\"invert\")", 73, true);
        menu2.addSeparator();
        this.addSubMenu(menu2, "Options");
        Menu menu3 = this.createMenu("Image");
        Menu menu4 = this.createMenu("Type");
        gray8Item = new CheckboxMenuItem("8-bit");
        menu4.add(gray8Item);
        gray8Item.addItemListener(ij);
        gray8Item.setState(false);
        gray16Item = new CheckboxMenuItem("16-bit");
        menu4.add(gray16Item);
        gray16Item.addItemListener(ij);
        gray16Item.setState(false);
        gray32Item = new CheckboxMenuItem("32-bit");
        menu4.add(gray32Item);
        gray32Item.addItemListener(ij);
        gray32Item.setState(false);
        menu4.add(new MenuItem("-"));
        color256Item = new CheckboxMenuItem("8-bit Color");
        menu4.add(color256Item);
        color256Item.addItemListener(ij);
        color256Item.setState(false);
        colorRGBItem = new CheckboxMenuItem("RGB Color");
        menu4.add(colorRGBItem);
        colorRGBItem.addItemListener(ij);
        colorRGBItem.setState(false);
        menu4.add(new MenuItem("-"));
        RGBStackItem = new CheckboxMenuItem("RGB Stack");
        menu4.add(RGBStackItem);
        RGBStackItem.addItemListener(ij);
        RGBStackItem.setState(false);
        HSBStackItem = new CheckboxMenuItem("HSB Stack");
        menu4.add(HSBStackItem);
        HSBStackItem.addItemListener(ij);
        HSBStackItem.setState(false);
        menu3.add(menu4);
        menu3.addSeparator();
        this.addSubMenu(menu3, "Adjust");
        this.addPlugInItem(menu3, "Show Info...", "ij.plugin.filter.Info", 73, false);
        this.addSubMenu(menu3, "Benchmarks");
        this.addSubMenu(menu3, "Stacks");
        menu3.addSeparator();
        this.addPlugInItem(menu3, "Crop", "ij.plugin.filter.Resizer(\"crop\")", 0, false);
        this.addPlugInItem(menu3, "Duplicate...", "ij.plugin.filter.Duplicater", 68, true);
        this.addPlugInItem(menu3, "Scale...", "ij.plugin.filter.Scaler", 69, false);
        this.addSubMenu(menu3, "Rotate");
        menu3.addSeparator();
        this.addSubMenu(menu3, "Lookup Tables");
        this.addPlugInItem(menu3, "Colors...", "ij.plugin.Colors", 0, false);
        Menu menu5 = this.createMenu("Process");
        this.addPlugInItem(menu5, "Smooth", "ij.plugin.filter.Filters(\"smooth\")", 83, true);
        this.addPlugInItem(menu5, "Sharpen", "ij.plugin.filter.Filters(\"sharpen\")", 0, false);
        this.addPlugInItem(menu5, "Find Edges", "ij.plugin.filter.Filters(\"edge\")", 70, true);
        this.addPlugInItem(menu5, "Equalize", "ij.plugin.filter.Equalizer", 0, false);
        this.addSubMenu(menu5, "Noise");
        this.addSubMenu(menu5, "Shadows");
        this.addSubMenu(menu5, "Binary");
        this.addSubMenu(menu5, "Math");
        filtersMenu = this.addSubMenu(menu5, "Filters");
        menu5.addSeparator();
        this.addPlugInItem(menu5, "Image Calculator...", "ij.plugin.ImageCalculator", 0, false);
        this.addPlugInItem(menu5, "Subtract Background...", "ij.plugin.filter.BackgroundSubtracter", 0, false);
        this.addItem(menu5, "Repeat Command", 82, true);
        Menu menu6 = this.createMenu("Analyze");
        this.addPlugInItem(menu6, "Measure", "ij.plugin.filter.Analyzer", 77, false);
        this.addPlugInItem(menu6, "Analyze Particles...", "ij.plugin.filter.ParticleAnalyzer", 0, false);
        this.addPlugInItem(menu6, "Summarize", "ij.plugin.filter.Analyzer(\"sum\")", 0, false);
        this.addPlugInItem(menu6, "Clear Results", "ij.plugin.filter.Analyzer(\"clear\")", 0, false);
        this.addPlugInItem(menu6, "Set Measurements...", "ij.plugin.filter.Analyzer(\"set\")", 0, false);
        menu6.addSeparator();
        this.addPlugInItem(menu6, "Set Scale...", "ij.plugin.filter.ScaleDialog", 0, false);
        this.addPlugInItem(menu6, "Calibrate...", "ij.plugin.filter.Calibrator", 0, false);
        this.addItem(menu6, "Histogram", 72, false);
        this.addPlugInItem(menu6, "Plot Profile", "ij.plugin.filter.Profiler(\"plot\")", 75, false);
        this.addPlugInItem(menu6, "Show LUT", "ij.plugin.filter.LutViewer", 0, false);
        this.addSubMenu(menu6, "Gels");
        toolsMenu = this.addSubMenu(menu6, "Tools");
        window = this.createMenu("Window");
        this.addItem(window, "ImageJ [enter]", 0, false);
        this.addItem(window, "Put Behind [tab]", 0, false);
        window.addSeparator();
        Menu menu7 = this.createMenu("Help");
        this.addItem(menu7, "About ImageJ...", 0, false);
        menu7.addSeparator();
        aboutMenu = this.addSubMenu(menu7, "About Plugins");
        this.addPluginsMenu();
        if (applet == null) {
            this.installPlugins();
        }
        mbar = new MenuBar();
        mbar.add(menu);
        mbar.add(menu2);
        mbar.add(menu3);
        mbar.add(menu5);
        mbar.add(menu6);
        mbar.add(pluginsMenu);
        mbar.add(window);
        mbar.setHelpMenu(menu7);
        ij.setMenuBar(mbar);
    }

    void addItem(Menu menu, String string, int n, boolean bl) {
        MenuItem menuItem;
        if (menu == null) {
            return;
        }
        if (n == 0) {
            menuItem = new MenuItem(string);
        } else if (bl) {
            menuItem = new MenuItem(string, new MenuShortcut(n, true));
            shortcuts.put(new Integer(n + 200), string);
        } else {
            menuItem = new MenuItem(string, new MenuShortcut(n));
            shortcuts.put(new Integer(n), string);
        }
        if (font != null) {
            menuItem.setFont(font);
        }
        menu.add(menuItem);
        menuItem.addActionListener(ij);
    }

    void addPlugInItem(Menu menu, String string, String string2, int n, boolean bl) {
        pluginsTable.put(string, string2);
        ++nPlugins;
        this.addItem(menu, string, n, bl);
    }

    Menu addSubMenu(Menu menu, String string) {
        String string2 = string.toLowerCase();
        Menu menu2 = this.createMenu(string);
        int n = string2.indexOf(32);
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        int n2 = 1;
        while (n2 < 100) {
            String string3 = Prefs.getString(string2 + n2 / 10 % 10 + n2 % 10);
            if (string3 == null) break;
            if (n2 == 1) {
                menu.add(menu2);
            }
            if (string3.equals("-")) {
                menu2.addSeparator();
            } else {
                this.addPluginItem(menu2, string3);
            }
            ++n2;
        }
        return menu2;
    }

    void addPluginItem(Menu menu, String string) {
        int n;
        int n2 = string.lastIndexOf(44);
        if (n2 <= 0) {
            return;
        }
        String string2 = string.substring(1, n2 - 1);
        int n3 = 0;
        boolean bl = false;
        if (string2.endsWith("]") && (n = string2.lastIndexOf(91)) > 0) {
            boolean bl2;
            String string3 = string2.substring(n + 1, string2.length() - 1);
            n3 = Menus.convertShortcutToCode(string3);
            boolean bl3 = bl2 = n3 >= 112 && n3 <= 123;
            if (n3 > 0 && !bl2) {
                string2 = string2.substring(0, n);
            }
        }
        if (n3 >= 112 && n3 <= 123) {
            shortcuts.put(new Integer(n3), string2);
            n3 = 0;
        } else if (n3 > 200) {
            n3 -= 200;
            bl = true;
        }
        this.addItem(menu, string2, n3, bl);
        String string4 = string.substring(n2 + 1, string.length());
        pluginsTable.put(string2, string4);
        ++nPlugins;
    }

    void addPluginsMenu() {
        pluginsMenu = this.createMenu("Plugins");
        int n = 1;
        while (n < 100) {
            String string = Prefs.getString("plug-in" + n / 10 % 10 + n % 10);
            if (string == null) break;
            char c = string.charAt(0);
            if (c == '-') {
                pluginsMenu.addSeparator();
            } else if (c == '>') {
                String string2 = string.substring(2, string.length() - 1);
                Menu menu = this.addSubMenu(pluginsMenu, string2);
                if (string2.equals("Shortcuts")) {
                    shortcutsMenu = menu;
                } else if (string2.equals("Utilities")) {
                    utilitiesMenu = menu;
                }
            } else {
                this.addPluginItem(pluginsMenu, string);
            }
            ++n;
        }
    }

    void installPlugins() {
        String[] stringArray = this.getPlugins();
        String[] stringArray2 = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 0;
        while (n < 100) {
            int n2;
            Menu menu;
            String string = Prefs.getString("plugin" + n / 10 % 10 + n % 10);
            if (string == null) break;
            char c = string.charAt(0);
            switch (c) {
                default: {
                    menu = pluginsMenu;
                    break;
                }
                case 'i': {
                    menu = importMenu;
                    break;
                }
                case 's': {
                    menu = saveAsMenu;
                    break;
                }
                case 'h': {
                    menu = shortcutsMenu;
                    break;
                }
                case 'a': {
                    menu = aboutMenu;
                    break;
                }
                case 'f': {
                    menu = filtersMenu;
                    break;
                }
                case 't': {
                    menu = toolsMenu;
                    break;
                }
                case 'u': {
                    menu = utilitiesMenu;
                    break;
                }
            }
            String string2 = string;
            string = string.substring(2, string.length());
            String string3 = string.substring(string.lastIndexOf(44) + 1, string.length());
            boolean bl = string3.startsWith("ij.");
            if (!bl && stringArray != null) {
                if (stringArray2 == null) {
                    stringArray2 = this.getStrippedPlugins(stringArray);
                }
                n2 = 0;
                while (n2 < stringArray2.length) {
                    if (string3.startsWith(stringArray2[n2])) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (bl) {
                this.addPluginItem(menu, string);
                pluginsPrefs.addElement(string2);
                if (string3.endsWith("\")") && (n2 = string3.lastIndexOf("(\"")) > 0) {
                    string3 = string3.substring(0, n2);
                }
                hashtable.put(string3, "");
            }
            ++n;
        }
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                if (!hashtable.containsKey(stringArray[n])) {
                    this.installUserPlugin(stringArray[n]);
                }
                ++n;
            }
        }
    }

    String[] getStrippedPlugins(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray2.length) {
            stringArray2[n] = stringArray[n];
            int n2 = stringArray2[n].lastIndexOf(47);
            if (n2 >= 0) {
                stringArray2[n] = stringArray[n].substring(n2 + 1, stringArray2[n].length());
            }
            ++n;
        }
        return stringArray2;
    }

    String[] getPlugins() {
        Object object;
        String string = Prefs.getHomeDir();
        if (string == null) {
            return null;
        }
        if (string.endsWith("plugins")) {
            pluginsPath = string;
        } else {
            object = Prefs.getFileSeparator();
            pluginsPath = string + (String)object + "plugins" + (String)object;
        }
        object = new File(pluginsPath);
        Object[] objectArray = ((File)object).list();
        if (objectArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < objectArray.length) {
            String string2 = objectArray[n];
            boolean bl = string2.endsWith(".class");
            if (string2.indexOf(95) >= 0 && bl && string2.indexOf(36) < 0) {
                string2 = string2.substring(0, string2.length() - 6);
                vector.addElement(string2);
            } else if (!bl) {
                this.checkSubdirectory(pluginsPath, string2, vector);
            }
            ++n;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        StringSorter.sort((String[])objectArray);
        return objectArray;
    }

    void checkSubdirectory(String string, String string2, Vector vector) {
        if (string2.endsWith(".java")) {
            return;
        }
        File file = new File(string, string2);
        if (!file.isDirectory()) {
            return;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        string2 = string2 + "/";
        int n = 0;
        while (n < stringArray.length) {
            String string3 = stringArray[n];
            if (string3.indexOf(95) >= 0 && string3.endsWith(".class") && string3.indexOf(36) < 0) {
                string3 = string3.substring(0, string3.length() - 6);
                vector.addElement(string2 + string3);
            }
            ++n;
        }
    }

    void installUserPlugin(String string) {
        String string2;
        Menu menu = pluginsMenu;
        int n = string.indexOf(47);
        if (n > 0) {
            string2 = string.substring(0, n);
            string = string.substring(n + 1, string.length());
            if (submenu == null || !submenuName.equals(string2)) {
                submenuName = string2;
                submenu = this.createMenu(submenuName);
                pluginsMenu.add(submenu);
            }
            menu = submenu;
        }
        string2 = string.replace('_', ' ');
        string2.trim();
        MenuItem menuItem = new MenuItem(string2);
        if (font != null) {
            menuItem.setFont(font);
        }
        menu.add(menuItem);
        menuItem.addActionListener(ij);
        pluginsTable.put(string2, string);
        ++nPlugins;
    }

    void installPopupMenu(ImageJ imageJ) {
        String string;
        int n = 0;
        popup = new PopupMenu("");
        while ((string = Prefs.getString("popup" + ++n / 10 % 10 + n % 10)) != null) {
            if (string.equals("-")) {
                popup.addSeparator();
                continue;
            }
            if (string.equals("")) continue;
            MenuItem menuItem = new MenuItem(string);
            menuItem.addActionListener(imageJ);
            popup.add(menuItem);
        }
    }

    public static MenuBar getMenuBar() {
        return mbar;
    }

    static void updateMenus() {
        if (ij == null) {
            return;
        }
        gray8Item.setState(false);
        gray16Item.setState(false);
        gray32Item.setState(false);
        color256Item.setState(false);
        colorRGBItem.setState(false);
        RGBStackItem.setState(false);
        HSBStackItem.setState(false);
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            return;
        }
        int n = imagePlus.getType();
        if (imagePlus.getStackSize() > 1) {
            ImageStack imageStack = imagePlus.getStack();
            if (imageStack.isRGB()) {
                n = 10;
            } else if (imageStack.isHSB()) {
                n = 11;
            }
        }
        switch (n) {
            case 0: {
                gray8Item.setState(true);
                break;
            }
            case 1: {
                gray16Item.setState(true);
                break;
            }
            case 2: {
                gray32Item.setState(true);
                break;
            }
            case 3: {
                color256Item.setState(true);
                break;
            }
            case 4: {
                colorRGBItem.setState(true);
                break;
            }
            case 10: {
                RGBStackItem.setState(true);
                break;
            }
            case 11: {
                HSBStackItem.setState(true);
                break;
            }
        }
        int n2 = window.getItemCount();
        int n3 = WindowManager.getCurrentIndex() + 3;
        int n4 = 3;
        while (n4 < n2) {
            CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)window.getItem(n4);
            checkboxMenuItem.setState(n4 == n3);
            ++n4;
        }
    }

    public static String getPlugInsPath() {
        return pluginsPath;
    }

    public static Hashtable getCommands() {
        return pluginsTable;
    }

    public static Hashtable getShortcuts() {
        return shortcuts;
    }

    static synchronized void trimWindowMenu(int n) {
        int n2 = window.getItemCount();
        if (n <= n2 - 3) {
            int n3 = 0;
            while (n3 < n) {
                window.remove(--n2);
                ++n3;
            }
        }
    }

    static synchronized void extendWindowMenu(ImagePlus imagePlus) {
        if (ij == null) {
            return;
        }
        String string = imagePlus.getTitle();
        int n = imagePlus.getWidth() * imagePlus.getHeight() * imagePlus.getStackSize() / 1024;
        switch (imagePlus.getType()) {
            case 2: 
            case 4: {
                n *= 4;
                break;
            }
            case 1: {
                n *= 2;
                break;
            }
        }
        CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(string + " " + n + "K");
        window.add(checkboxMenuItem);
        checkboxMenuItem.addItemListener(ij);
    }

    public static PopupMenu getPopupMenu() {
        return popup;
    }

    public static int installPlugin(String string, char c, String string2, String string3, ImageJ imageJ) {
        MenuItem menuItem;
        boolean bl;
        Menu menu;
        if (string2.equals("")) {
            return 0;
        }
        if (Menus.commandInUse(string2)) {
            return -1;
        }
        if (!Menus.validShortcut(string3)) {
            return -2;
        }
        if (Menus.shortcutInUse(string3)) {
            return -3;
        }
        switch (c) {
            case 'p': {
                menu = pluginsMenu;
                break;
            }
            case 'i': {
                menu = importMenu;
                break;
            }
            case 's': {
                menu = saveAsMenu;
                break;
            }
            case 'h': {
                menu = shortcutsMenu;
                break;
            }
            case 'a': {
                menu = aboutMenu;
                break;
            }
            case 'f': {
                menu = filtersMenu;
                break;
            }
            case 't': {
                menu = toolsMenu;
                break;
            }
            case 'u': {
                menu = utilitiesMenu;
                break;
            }
            default: {
                return 0;
            }
        }
        int n = Menus.convertShortcutToCode(string3);
        boolean bl2 = bl = n >= 112 && n <= 123;
        if (n == 0) {
            menuItem = new MenuItem(string2);
        } else if (bl) {
            string2 = string2 + " [F" + (n - 112 + 1) + "]";
            shortcuts.put(new Integer(n), string2);
            menuItem = new MenuItem(string2);
        } else {
            shortcuts.put(new Integer(n), string2);
            int n2 = n;
            boolean bl3 = false;
            if (n2 > 200) {
                n2 -= 200;
                bl3 = true;
            }
            menuItem = new MenuItem(string2, new MenuShortcut(n2, bl3));
        }
        menu.add(menuItem);
        menuItem.addActionListener(imageJ);
        pluginsTable.put(string2, string);
        string3 = n > 0 && !bl ? "[" + string3 + "]" : "";
        pluginsPrefs.addElement(c + ",\"" + string2 + string3 + "\"," + string);
        return 0;
    }

    public static int uninstallPlugin(String string) {
        boolean bl = false;
        Enumeration enumeration = pluginsPrefs.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.indexOf(string) <= 0) continue;
            pluginsPrefs.removeElement(string2);
            bl = true;
            break;
        }
        if (bl) {
            return 0;
        }
        return -5;
    }

    public static boolean commandInUse(String string) {
        return pluginsTable.get(string) != null;
    }

    static int convertShortcutToCode(String string) {
        int n = 0;
        int n2 = string.length();
        if (n2 == 2 && string.startsWith("F")) {
            n = 112 + string.charAt(1) - 49;
            if (n >= 112 && n <= 120) {
                return n;
            }
            return 0;
        }
        if (n2 == 3 && string.startsWith("F")) {
            n = 121 + string.charAt(2) - 48;
            if (n >= 121 && n <= 123) {
                return n;
            }
            return 0;
        }
        if (n2 != 1) {
            return 0;
        }
        char c = string.charAt(0);
        if (c >= 'A' && c <= 'Z') {
            n = 65 + c - 65 + 200;
        } else if (c >= 'a' && c <= 'z') {
            n = 65 + c - 97;
        } else if (c >= '0' && c <= '9') {
            n = 48 + c - 48;
        }
        return n;
    }

    static boolean validShortcut(String string) {
        int n = string.length();
        if (string.equals("")) {
            return true;
        }
        if (n == 1) {
            return true;
        }
        return string.startsWith("F") && (n == 2 || n == 3);
    }

    public static boolean shortcutInUse(String string) {
        int n = Menus.convertShortcutToCode(string);
        return shortcuts.get(new Integer(n)) != null;
    }

    public static void savePreferences(Properties properties) {
        int n = 0;
        Enumeration enumeration = pluginsPrefs.elements();
        while (enumeration.hasMoreElements()) {
            String string = "plugin" + n / 10 % 10 + n % 10;
            ((Hashtable)properties).put(string, (String)enumeration.nextElement());
            ++n;
        }
    }

    Menus(ImageJ imageJ, Applet applet) {
        ij = imageJ;
        Menus.applet = applet;
    }

    static {
        demoImagesTable = new Hashtable();
        pluginsTable = new Hashtable();
        shortcuts = new Hashtable();
        pluginsPrefs = new Vector();
    }
}

