/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImageJ;
import ij.ImageStack;
import ij.LookUpTable;
import ij.Menus;
import ij.gui.FreehandRoi;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.OvalRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.StackWindow;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.Opener;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.util.Hashtable;
import java.util.Properties;

public class ImagePlus
implements ImageObserver,
Measurements {
    public static final int GRAY8 = 0;
    public static final int GRAY16 = 1;
    public static final int GRAY32 = 2;
    public static final int COLOR_256 = 3;
    public static final int COLOR_RGB = 4;
    private static int currentID = -1;
    private static Component comp;
    private static Calibration globalCalibration;
    static int counter;
    public boolean changes;
    public double pixelWidth = 1.0;
    public double pixelHeight = 1.0;
    public double pixelDepth = 1.0;
    public String unit = "pixel";
    public String units = "pixels";
    public boolean sCalibrated;
    protected Image img;
    protected ImageProcessor ip;
    protected ImageWindow win;
    private ImageJ ij = IJ.getInstance();
    private String title;
    private String url;
    private FileInfo fileInfo;
    protected int width;
    protected int height;
    private int imageType = 0;
    private ImageStack stack;
    private int currentSlice;
    private Roi roi;
    protected boolean locked = false;
    private int ID;
    private boolean imageLoaded;
    private int imageUpdateY;
    private int imageUpdateW;
    private Properties properties;
    private long startTime;
    private Calibration calibration;
    private int[] pvalue = new int[4];

    public synchronized boolean lock() {
        if (this.locked) {
            IJ.beep();
            IJ.showStatus("\"" + this.title + "\" is locked");
            return false;
        }
        this.locked = true;
        if (IJ.debugMode) {
            IJ.write(this.title + ": lock");
        }
        return true;
    }

    public synchronized boolean lockSilently() {
        if (this.locked) {
            return false;
        }
        this.locked = true;
        return true;
    }

    public synchronized void unlock() {
        this.locked = false;
        if (IJ.debugMode) {
            IJ.write(this.title + ": unlock");
        }
    }

    private void waitForImage(Image image) {
        if (comp == null && (comp = IJ.getInstance()) == null) {
            comp = new Frame();
        }
        this.imageLoaded = false;
        if (!comp.prepareImage(image, this)) {
            while (!this.imageLoaded) {
                IJ.wait(50);
                if (this.imageUpdateW <= 1) continue;
                double d = (double)this.imageUpdateY / (double)this.imageUpdateW;
                if (!(d < 1.0) && (d = 1.0 - (d - 1.0)) < 0.0) {
                    d = 0.9;
                }
                IJ.showProgress(d);
            }
            IJ.showProgress(1.0);
        }
    }

    public void draw() {
        if (this.win != null) {
            this.win.getCanvas().repaint();
        }
    }

    public void draw(int n, int n2, int n3, int n4) {
        if (this.win != null) {
            ImageCanvas imageCanvas = this.win.getCanvas();
            double d = imageCanvas.getMagnification();
            n = imageCanvas.screenX(n);
            n2 = imageCanvas.screenY(n2);
            n3 = (int)((double)n3 * d);
            n4 = (int)((double)n4 * d);
            imageCanvas.repaint(n, n2, n3, n4);
        }
    }

    public void updateAndDraw() {
        if (this.ip == null) {
            return;
        }
        if (this.win != null) {
            this.win.getCanvas().setImageUpdated();
        }
        this.draw();
        Thread.yield();
    }

    public void repaintWindow() {
        if (this.win != null) {
            this.draw();
            this.win.repaint();
        }
    }

    public void updateAndRepaintWindow() {
        if (this.win != null) {
            this.updateAndDraw();
            this.win.repaint();
        }
    }

    public void updateImage() {
        if (this.ip != null) {
            if (this.img == null) {
                this.img = this.ip.createImage();
            } else {
                this.img.flush();
                if (this.img.getSource() != this.ip.getImageSource()) {
                    this.img = this.ip.createImage();
                }
            }
        }
    }

    public void hide() {
        if (this.win == null) {
            return;
        }
        boolean bl = this.lockSilently();
        this.changes = false;
        this.win.close();
        this.win = null;
        if (bl) {
            this.unlock();
        }
    }

    public void show() {
        this.show("");
    }

    public void show(String string) {
        if (this.win != null) {
            return;
        }
        if (this.img == null && this.ip != null) {
            this.img = this.ip.createImage();
        }
        if (this.img != null && this.width >= 0 && this.height >= 0) {
            this.win = this.stack != null && this.stack.getSize() > 1 ? new StackWindow(this) : new ImageWindow(this);
            this.draw();
            IJ.showStatus(string);
        }
    }

    public Image getImage() {
        if (this.img == null && this.ip != null) {
            this.img = this.ip.createImage();
        }
        return this.img;
    }

    public int getID() {
        return this.ID;
    }

    public void setImage(Image image) {
        this.roi = null;
        this.waitForImage(image);
        this.img = image;
        this.width = image.getWidth(this.ij);
        this.height = image.getHeight(this.ij);
        this.ip = null;
        LookUpTable lookUpTable = new LookUpTable(image);
        int n = lookUpTable.getMapSize() > 0 ? (lookUpTable.isGrayscale() ? 0 : 3) : 4;
        this.setType(n);
    }

    public void setProcessor(String string, ImageProcessor imageProcessor) {
        boolean bl;
        if (string != null) {
            this.title = string;
        }
        this.ip = imageProcessor;
        if (this.ij != null) {
            imageProcessor.setProgressBar(this.ij.getProgressBar());
        }
        this.roi = null;
        this.img = imageProcessor.createImage();
        boolean bl2 = bl = this.width != imageProcessor.getWidth() || this.height != imageProcessor.getHeight();
        int n = imageProcessor instanceof ByteProcessor ? 0 : (imageProcessor instanceof ColorProcessor ? 4 : (imageProcessor instanceof ShortProcessor ? 1 : 2));
        if (this.width == 0) {
            this.imageType = n;
        } else {
            this.setType(n);
        }
        this.width = imageProcessor.getWidth();
        this.height = imageProcessor.getHeight();
        if (this.win != null && bl) {
            this.win = new ImageWindow(this);
        }
    }

    public void setStack(String string, ImageStack imageStack) {
        this.currentSlice = 1;
        ImageProcessor imageProcessor = imageStack.getProcessor(this.currentSlice);
        this.stack = imageStack;
        this.setProcessor(string, imageProcessor);
        if (this.win != null && this.win instanceof StackWindow) {
            ((StackWindow)this.win).showSlice(1);
        }
    }

    public void setFileInfo(FileInfo fileInfo) {
        fileInfo.pixels = null;
        this.fileInfo = fileInfo;
    }

    public ImageWindow getWindow() {
        return this.win;
    }

    public void setWindow(ImageWindow imageWindow) {
        this.win = imageWindow;
    }

    public void setColor(Color color) {
        if (this.ip != null) {
            this.ip.setColor(color);
        }
    }

    void setupProcessor() {
        if (this.imageType == 4) {
            if (this.ip == null || this.ip instanceof ByteProcessor) {
                this.ip = new ColorProcessor(this.img);
                if (IJ.debugMode) {
                    IJ.write(this.title + ": new ColorProcessor");
                }
            }
        } else if (this.ip == null || this.ip instanceof ColorProcessor) {
            this.ip = new ByteProcessor(this.img);
            if (IJ.debugMode) {
                IJ.write(this.title + ": new ByteProcessor");
            }
        }
        if (this.roi != null && this.roi.getType() < 5) {
            this.ip.setRoi(this.roi.getBoundingRect());
        } else {
            this.ip.setRoi(null);
        }
    }

    public boolean isProcessor() {
        return this.ip != null;
    }

    public ImageProcessor getProcessor() {
        if (this.ip == null && this.img == null) {
            return null;
        }
        this.setupProcessor();
        this.ip.setLineWidth(Line.getWidth());
        if (this.ij != null) {
            this.ip.setProgressBar(this.ij.getProgressBar());
        }
        return this.ip;
    }

    public synchronized void trimProcessor() {
        if (this.ip != null && !this.locked) {
            if (this.ip != null && IJ.debugMode) {
                IJ.write(this.title + ": trimProcessor");
            }
            this.ip.setPixels(this.ip.getPixels());
        }
    }

    public void killProcessor() {
    }

    public int[] getMask() {
        if (this.roi != null && this.roi.getType() < 5) {
            return this.roi.getMask();
        }
        return null;
    }

    public ImageStatistics getStatistics() {
        return this.getStatistics(27);
    }

    public ImageStatistics getStatistics(int n) {
        return this.getStatistics(n, 256);
    }

    public ImageStatistics getStatistics(int n, int n2) {
        this.setupProcessor();
        this.ip.setMask(this.getMask());
        this.ip.setHistogramSize(n2);
        ImageStatistics imageStatistics = ImageStatistics.getStatistics(this.ip, n, this.getCalibration());
        this.ip.setHistogramSize(256);
        return imageStatistics;
    }

    public String getTitle() {
        if (this.title == null) {
            return "";
        }
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
        if (this.win != null) {
            this.win.setTitle(string);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getStackSize() {
        if (this.stack == null) {
            return 1;
        }
        int n = this.stack.getSize();
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    public int getType() {
        return this.imageType;
    }

    protected void setType(int n) {
        if (n < 0 || n > 4) {
            return;
        }
        int n2 = this.imageType;
        this.imageType = n;
        if (this.win == null || this.imageType != n2) {
            // empty if block
        }
        Menus.updateMenus();
    }

    public void setProperty(String string, Object object) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        ((Hashtable)this.properties).put(string, object);
    }

    public Object getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return ((Hashtable)this.properties).get(string);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public LookUpTable createLut() {
        if (this.img != null) {
            return new LookUpTable(this.img);
        }
        return null;
    }

    public boolean isInvertedLut() {
        if (this.ip == null) {
            if (this.img == null) {
                return false;
            }
            this.setupProcessor();
        }
        return this.ip.isInvertedLut();
    }

    public int[] getPixel(int n, int n2) {
        this.pvalue[3] = 0;
        this.pvalue[2] = 0;
        this.pvalue[1] = 0;
        this.pvalue[0] = 0;
        if (this.img == null) {
            return this.pvalue;
        }
        switch (this.imageType) {
            case 0: 
            case 3: {
                Object[] objectArray;
                Object object;
                int n3;
                if (this.ip != null) {
                    n3 = this.ip.getPixel(n, n2);
                } else {
                    object = new PixelGrabber(this.img, n, n2, 1, 1, false);
                    try {
                        ((PixelGrabber)object).grabPixels();
                    }
                    catch (InterruptedException interruptedException) {
                        return this.pvalue;
                    }
                    objectArray = (byte[])((PixelGrabber)object).getPixels();
                    int n4 = n3 = objectArray != null ? objectArray[0] & 0xFF : 0;
                }
                if (this.imageType != 3) {
                    this.pvalue[0] = n3;
                    return this.pvalue;
                }
                this.pvalue[3] = n3;
            }
            case 4: {
                Object[] objectArray = new int[1];
                if (this.win == null) break;
                Object object = this.win.getCanvas();
                PixelGrabber pixelGrabber = new PixelGrabber(this.img, n, n2, 1, 1, (int[])objectArray, 0, this.width);
                try {
                    pixelGrabber.grabPixels();
                }
                catch (InterruptedException interruptedException) {
                    return this.pvalue;
                }
                int n5 = objectArray[0];
                int n6 = (n5 & 0xFF0000) >> 16;
                int n7 = (n5 & 0xFF00) >> 8;
                int n8 = n5 & 0xFF;
                this.pvalue[0] = n6;
                this.pvalue[1] = n7;
                this.pvalue[2] = n8;
                break;
            }
            case 1: 
            case 2: {
                if (this.ip == null) break;
                this.pvalue[0] = this.ip.getPixel(n, n2);
                break;
            }
        }
        return this.pvalue;
    }

    public ImageStack createEmptyStack() {
        ColorModel colorModel = this.ip != null ? this.ip.getColorModel() : this.createLut().getColorModel();
        return new ImageStack(this.width, this.height, colorModel);
    }

    public ImageStack getStack() {
        ImageStack imageStack;
        if (this.stack == null) {
            imageStack = this.createEmptyStack();
            imageStack.addSlice(null, this.getProcessor());
        } else {
            imageStack = this.stack;
            if (this.ip != null) {
                imageStack.update(this.ip);
            }
        }
        if (this.roi != null) {
            imageStack.setRoi(this.roi.getBoundingRect());
        }
        return imageStack;
    }

    public int getCurrentSlice() {
        if (this.currentSlice == 0) {
            return 1;
        }
        return this.currentSlice;
    }

    public void killStack() {
        this.stack = null;
        this.trimProcessor();
    }

    public synchronized void setSlice(int n) {
        if (this.stack == null || n == this.currentSlice) {
            this.updateAndRepaintWindow();
            return;
        }
        if (n >= 1 && n <= this.stack.getSize()) {
            Roi roi = this.getRoi();
            if (roi != null) {
                roi.endPaste();
            }
            if (this.isProcessor()) {
                this.stack.setPixels(this.ip.getPixels(), this.currentSlice);
            }
            this.ip = this.getProcessor();
            this.currentSlice = n;
            Object object = this.stack.getPixels(this.currentSlice);
            if (object != null) {
                this.ip.setPixels(object);
            }
            if (this.win != null && this.win instanceof StackWindow) {
                ((StackWindow)this.win).updateSliceSelector();
            }
            if (IJ.spaceBarDown() && (this.imageType == 1 || this.imageType == 2)) {
                this.ip.resetMinAndMax();
                IJ.showStatus(n + ": min=" + this.ip.getMin() + ", max=" + this.ip.getMax());
            }
            this.updateAndRepaintWindow();
        }
    }

    void undoFilter() {
        if (this.ip != null) {
            this.ip.reset();
            this.updateAndDraw();
            if (IJ.debugMode) {
                IJ.write(this.getTitle() + ": undo filter");
            }
        }
    }

    public Roi getRoi() {
        return this.roi;
    }

    public void setRoi(Roi roi) {
        this.killRoi();
        this.roi = roi;
        if (this.ip != null) {
            this.ip.setRoi(roi.getBoundingRect());
            this.ip.setMask(null);
        }
        this.roi.setImage(this);
        this.draw();
    }

    public void setRoi(int n, int n2, int n3, int n4) {
        this.setRoi(new Rectangle(n, n2, n3, n4));
    }

    public void setRoi(Rectangle rectangle) {
        if (rectangle == null) {
            this.killRoi();
            return;
        }
        this.killRoi();
        this.roi = new Roi(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
        if (this.ip != null) {
            this.ip.setRoi(rectangle);
            this.ip.setMask(null);
        }
        this.draw();
    }

    public void createNewRoi(int n, int n2) {
        this.killRoi();
        switch (Toolbar.getToolId()) {
            case 0: {
                this.roi = new Roi(n, n2, this);
                break;
            }
            case 1: {
                this.roi = new OvalRoi(n, n2, this);
                break;
            }
            case 2: 
            case 5: {
                this.roi = new PolygonRoi(n, n2, this);
                break;
            }
            case 3: 
            case 6: {
                this.roi = new FreehandRoi(n, n2, this);
                break;
            }
            case 4: {
                this.roi = new Line(n, n2, this);
                break;
            }
            case 9: {
                this.roi = new TextRoi(n, n2, this);
                break;
            }
        }
    }

    public void killRoi() {
        if (this.roi != null) {
            this.saveRoi();
            this.roi = null;
            if (this.ip != null) {
                this.ip.setRoi(null);
            }
            this.draw();
        }
    }

    void saveRoi() {
        if (this.roi != null) {
            this.roi.endPaste();
            Rectangle rectangle = this.roi.getBoundingRect();
            if (rectangle.width > 0 && rectangle.height > 0) {
                Roi.previousRoi = this.roi;
                if (IJ.debugMode) {
                    IJ.write("saveRoi: " + this.roi);
                }
            }
        }
    }

    void restoreRoi() {
        if (Roi.previousRoi != null) {
            Roi roi = Roi.previousRoi;
            Rectangle rectangle = roi.getBoundingRect();
            if (rectangle.width <= this.width || rectangle.height <= this.height) {
                this.roi = (Roi)roi.clone();
                this.roi.setImage(this);
                if (rectangle.x + rectangle.width > this.width || rectangle.y + rectangle.height > this.height) {
                    this.roi.setLocation((this.width - rectangle.width) / 2, (this.height - rectangle.height) / 2);
                }
                this.draw();
            }
        }
    }

    void revert() {
        if (this.getStackSize() > 1) {
            return;
        }
        this.trimProcessor();
        FileInfo fileInfo = this.getOriginalFileInfo();
        if (fileInfo != null && fileInfo.fileFormat != 0) {
            new FileOpener(fileInfo).revertToSaved(this);
        } else if (this.url != null) {
            IJ.showStatus("Loading: " + this.url);
            Opener opener = new Opener();
            try {
                ImagePlus imagePlus = opener.openURL(this.url);
                if (imagePlus != null) {
                    this.setProcessor(imagePlus.getTitle(), imagePlus.getProcessor());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.getType() == 4 && this.getTitle().endsWith(".jpg")) {
                Opener.convertGrayJpegTo8Bits(this);
            }
        }
        this.repaintWindow();
        IJ.showStatus("");
    }

    public FileInfo getFileInfo() {
        FileInfo fileInfo = new FileInfo();
        fileInfo.width = this.width;
        fileInfo.height = this.height;
        fileInfo.nImages = this.getStackSize();
        fileInfo.whiteIsZero = this.isInvertedLut();
        fileInfo.intelByteOrder = false;
        this.setupProcessor();
        fileInfo.pixels = fileInfo.nImages == 1 ? this.ip.getPixels() : this.stack.getImageArray();
        Calibration calibration = this.getCalibration();
        if (calibration.scaled()) {
            fileInfo.pixelWidth = calibration.pixelWidth;
            fileInfo.pixelHeight = calibration.pixelHeight;
            fileInfo.pixelDepth = calibration.pixelDepth;
            fileInfo.unit = calibration.getUnit();
        }
        if (calibration.calibrated()) {
            fileInfo.calibrationFunction = calibration.getFunction();
            fileInfo.coefficients = calibration.getCoefficients();
            fileInfo.valueUnit = calibration.getValueUnit();
        }
        switch (this.imageType) {
            case 0: 
            case 3: {
                LookUpTable lookUpTable = this.createLut();
                fileInfo.fileType = this.imageType == 3 || !lookUpTable.isGrayscale() ? 5 : 0;
                fileInfo.lutSize = lookUpTable.getMapSize();
                fileInfo.reds = lookUpTable.getReds();
                fileInfo.greens = lookUpTable.getGreens();
                fileInfo.blues = lookUpTable.getBlues();
                break;
            }
            case 1: {
                fileInfo.fileType = FileInfo.GRAY16_UNSIGNED;
                break;
            }
            case 2: {
                fileInfo.fileType = FileInfo.GRAY32_FLOAT;
                break;
            }
            case 4: {
                fileInfo.fileType = FileInfo.RGB;
                break;
            }
        }
        return fileInfo;
    }

    public FileInfo getOriginalFileInfo() {
        return this.fileInfo;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        this.imageUpdateY = n3;
        this.imageUpdateW = n4;
        this.imageLoaded = (n & 0xB0) != 0;
        return !this.imageLoaded;
    }

    public void flush() {
        Object[] objectArray;
        if (this.locked) {
            return;
        }
        if (this.ip != null) {
            this.ip.setPixels(null);
            this.ip = null;
        }
        if (this.stack != null && (objectArray = this.stack.getImageArray()) != null) {
            int n = 0;
            while (n < objectArray.length) {
                objectArray[n] = null;
                ++n;
            }
        }
        if (this.img != null) {
            this.img.flush();
            this.img = null;
        }
        System.gc();
    }

    public ImagePlus createImagePlus() {
        ImagePlus imagePlus = new ImagePlus();
        imagePlus.setCalibration(this.getCalibration());
        return imagePlus;
    }

    public void copyScale(ImagePlus imagePlus) {
        if (imagePlus != null && globalCalibration == null) {
            this.setCalibration(imagePlus.getCalibration());
        }
    }

    public void startTiming() {
        this.startTime = System.currentTimeMillis();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Calibration getCalibration() {
        if (globalCalibration != null) {
            return globalCalibration;
        }
        if (this.calibration == null) {
            this.calibration = new Calibration(this);
        }
        return this.calibration;
    }

    public void setCalibration(Calibration calibration) {
        this.calibration = calibration == null ? null : calibration.copy();
    }

    public void setGlobalCalibration(Calibration calibration) {
        globalCalibration = calibration == null ? null : calibration.copy();
    }

    public void mouseMoved(int n, int n2) {
        Calibration calibration = this.getCalibration();
        if (calibration.scaled()) {
            IJ.showStatus("Location = (" + IJ.d2s(calibration.getX(n)) + "," + IJ.d2s(calibration.getY(n2)) + ")" + this.showValue(n, n2, calibration));
        } else {
            IJ.showStatus("Location = (" + n + "," + n2 + ")" + this.showValue(n, n2, calibration));
        }
    }

    private String showValue(int n, int n2, Calibration calibration) {
        int[] nArray = this.getPixel(n, n2);
        switch (this.getType()) {
            case 0: 
            case 1: {
                double d = calibration.getCValue(nArray[0]);
                if (d == (double)nArray[0]) {
                    return ", value=" + nArray[0];
                }
                return ", value=" + IJ.d2s(d) + " (" + nArray[0] + ")";
            }
            case 2: {
                return ", value=" + Float.intBitsToFloat(nArray[0]);
            }
            case 3: {
                return ", index=" + nArray[3] + ", value=" + nArray[0] + "," + nArray[1] + "," + nArray[2];
            }
            case 4: {
                return ", value=" + nArray[0] + "," + nArray[1] + "," + nArray[2];
            }
        }
        return "";
    }

    public ImagePlus() {
        this.ID = --currentID;
        this.title = "null";
    }

    public ImagePlus(String string, Image image) {
        this.title = string;
        this.ID = --currentID;
        if (image != null) {
            this.setImage(image);
        }
    }

    public ImagePlus(String string, ImageProcessor imageProcessor) {
        this.setProcessor(string, imageProcessor);
        this.ID = --currentID;
    }

    public ImagePlus(String string) {
        Opener opener = new Opener();
        ImagePlus imagePlus = opener.openURL(string);
        if (imagePlus != null) {
            if (imagePlus.getStackSize() > 1) {
                this.setStack(imagePlus.getTitle(), imagePlus.getStack());
            } else {
                this.setProcessor(imagePlus.getTitle(), imagePlus.getProcessor());
            }
            this.url = string;
            this.ID = --currentID;
        }
    }

    public ImagePlus(String string, ImageStack imageStack) {
        this.setStack(string, imageStack);
        this.ID = --currentID;
    }
}

