/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.Executer;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Menus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.MessageDialog;
import ij.gui.ProgressBar;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.io.PluginClassLoader;
import ij.plugin.PlugIn;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.text.TextPanel;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ImageProducer;
import java.net.URL;
import java.util.Vector;

public class ImageJ
extends Frame
implements ActionListener,
MouseListener,
KeyListener,
WindowListener,
ItemListener {
    public static final String VERSION = "1.22d";
    private static PluginClassLoader classLoader;
    private static boolean wasMaximized;
    private Toolbar toolbar;
    private Panel statusBar;
    private ProgressBar progressBar;
    private Label statusLine;
    private TextPanel textPanel;
    private boolean firstTime = true;
    private Applet applet;
    private Vector classes = new Vector();
    private boolean notVerified = true;

    void setIcon() {
        URL uRL = this.getClass().getResource("/microscope.gif");
        if (uRL == null) {
            return;
        }
        Image image = null;
        try {
            image = this.createImage((ImageProducer)uRL.getContent());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (image != null) {
            this.setIconImage(image);
        }
    }

    public Point getPreferredLocation() {
        int n;
        int n2 = Toolkit.getDefaultToolkit().getScreenSize().width;
        Dimension dimension = this.toolbar.getPreferredSize();
        double d = n2 > 832 ? 0.8 : 0.9;
        int n3 = (int)(d * (double)(n2 - (n = dimension.width + 10)));
        if (n3 < 10) {
            n3 = 10;
        }
        int n4 = 32;
        return new Point(n3, n4);
    }

    void showStatus(String string) {
        this.statusLine.setText(string);
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    void doCommand(String string) {
        new Executer(string, WindowManager.getCurrentImage());
    }

    void wrongType(int n) {
        String string = "This command requires an image of type:\n \n";
        if ((n & 1) != 0) {
            string = string + "    8-bit grayscale\n";
        }
        if ((n & 2) != 0) {
            string = string + "    8-bit color\n";
        }
        if ((n & 4) != 0) {
            string = string + "    16-bit grayscale\n";
        }
        if ((n & 8) != 0) {
            string = string + "    32-bit (float) grayscale\n";
        }
        if ((n & 0x10) != 0) {
            string = string + "    RGB color\n";
        }
        IJ.error(string);
    }

    public void runFilterPlugIn(Object object, String string, String string2) {
        ImageWindow imageWindow;
        boolean bl;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        int n = ((PlugInFilter)object).setup(string2, imagePlus);
        if ((n & 0x1000) != 0) {
            return;
        }
        if ((n & 0x200) != 0) {
            ((PlugInFilter)object).run(null);
            return;
        }
        if (imagePlus == null) {
            IJ.noImage();
            return;
        }
        if ((n & 0x400) != 0 && imagePlus.getRoi() == null) {
            IJ.error("Selection required");
            return;
        }
        if ((n & 0x800) != 0 && imagePlus.getStackSize() == 1) {
            IJ.error("Stack required");
            return;
        }
        int n2 = imagePlus.getType();
        switch (n2) {
            case 0: {
                if ((n & 1) != 0) break;
                this.wrongType(n);
                return;
            }
            case 3: {
                if ((n & 2) != 0) break;
                this.wrongType(n);
                return;
            }
            case 1: {
                if ((n & 4) != 0) break;
                this.wrongType(n);
                return;
            }
            case 2: {
                if ((n & 8) != 0) break;
                this.wrongType(n);
                return;
            }
            case 4: {
                if ((n & 0x10) != 0) break;
                this.wrongType(n);
                return;
            }
        }
        int n3 = imagePlus.getStackSize();
        boolean bl2 = bl = (n & 0x20) != 0;
        if (!imagePlus.lock()) {
            return;
        }
        imagePlus.startTiming();
        IJ.showStatus(string + "...");
        ImageStack imageStack = null;
        if (n3 > 1) {
            imageStack = imagePlus.getStack();
        }
        if (n3 == 1 || !bl || imageStack != null && (imageStack.isRGB() || imageStack.isHSB())) {
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            if ((n & 0x100) != 0) {
                Undo.reset();
            } else {
                Undo.setup(1, imagePlus);
                imageProcessor.snapshot();
            }
            ((PlugInFilter)object).run(imageProcessor);
            if ((n & 0x40) != 0) {
                imageProcessor.reset(imagePlus.getMask());
            }
        } else {
            Undo.reset();
            int n4 = imageStack.getSize();
            int n5 = imagePlus.getCurrentSlice();
            int n6 = 1;
            while (n6 <= n4) {
                ImageProcessor imageProcessor = imageStack.getProcessor(n6);
                ((PlugInFilter)object).run(imageProcessor);
                IJ.showProgress((double)n6 / (double)n4);
                System.gc();
                Thread.yield();
                ++n6;
            }
            n6 = imagePlus.getCurrentSlice();
            imagePlus.setProcessor(null, imageStack.getProcessor(n6));
            IJ.showProgress(1.0);
        }
        IJ.showTime(imagePlus, imagePlus.getStartTime(), string + ": ");
        if ((n & 0x80) == 0) {
            imagePlus.changes = true;
            imagePlus.updateAndDraw();
        }
        if ((imageWindow = imagePlus.getWindow()) != null) {
            imageWindow.running = false;
        }
        imagePlus.unlock();
    }

    public Object runUserPlugIn(String string, String string2, String string3, boolean bl) {
        PluginClassLoader pluginClassLoader;
        if (this.applet != null) {
            return null;
        }
        if (this.notVerified) {
            IJ.runPlugIn("ij.plugin.Verifier", "");
            this.notVerified = false;
        }
        if (bl) {
            pluginClassLoader = new PluginClassLoader(Menus.getPlugInsPath());
        } else {
            if (classLoader == null) {
                classLoader = new PluginClassLoader(Menus.getPlugInsPath());
            }
            pluginClassLoader = classLoader;
        }
        Object var6_6 = null;
        try {
            var6_6 = pluginClassLoader.loadClass(string2).newInstance();
            if (var6_6 instanceof PlugIn) {
                ((PlugIn)var6_6).run(string3);
            } else if (var6_6 instanceof PlugInFilter) {
                this.runFilterPlugIn(var6_6, string, string3);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            IJ.write("PlugIn not found: " + string2);
        }
        catch (InstantiationException instantiationException) {
            IJ.write("Unable to load plugin (ins)");
        }
        catch (IllegalAccessException illegalAccessException) {
            IJ.write("Unable to load plugin (acc)");
        }
        return var6_6;
    }

    public static String modifiers(int n) {
        String string = " [ ";
        if (n == 0) {
            return "";
        }
        if ((n & 1) != 0) {
            string = string + "Shift ";
        }
        if ((n & 2) != 0) {
            string = string + "Control ";
        }
        if ((n & 4) != 0) {
            string = string + "Meta ";
        }
        if ((n & 8) != 0) {
            string = string + "Alt ";
        }
        string = string + "] ";
        return string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string != null) {
                this.doCommand(string);
            }
            if (IJ.debugMode) {
                IJ.write("actionPerformed: " + string);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        MenuItem menuItem = (MenuItem)itemEvent.getSource();
        MenuComponent menuComponent = (MenuComponent)((Object)menuItem.getParent());
        String string = itemEvent.getItem().toString();
        if ((Menu)menuComponent == Menus.window) {
            WindowManager.activateWindow(string, menuItem);
        } else {
            this.doCommand(string);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Undo.reset();
        IJ.showStatus(IJ.freeMemory());
        if (IJ.debugMode) {
            IJ.write("Windows: " + WindowManager.getWindowCount());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Cloneable cloneable;
        boolean bl;
        int n = keyEvent.getKeyCode();
        IJ.setKeyDown(n);
        if (n == KeyEvent.VK_CONTROL || n == KeyEvent.VK_SHIFT) {
            return;
        }
        char c = keyEvent.getKeyChar();
        int n2 = keyEvent.getModifiers();
        if (IJ.debugMode) {
            IJ.write("keyCode=" + n + " (" + KeyEvent.getKeyText(n) + ") keyChar=\"" + c + "\" (" + c + ") " + KeyEvent.getKeyModifiersText(n2));
        }
        boolean bl2 = (n2 & InputEvent.SHIFT_MASK) != 0;
        boolean bl3 = (n2 & InputEvent.CTRL_MASK) != 0;
        String string = "";
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        boolean bl4 = bl = imagePlus != null && imagePlus.getStackSize() > 1;
        if (imagePlus != null && !bl3 && (c >= ' ' && c <= '\u007f' || c == '\b' || c == '\n') && (cloneable = imagePlus.getRoi()) instanceof TextRoi) {
            ((TextRoi)cloneable).addChar(c);
            return;
        }
        cloneable = Menus.getShortcuts();
        string = bl2 ? (String)cloneable.get(new Integer(n + 200)) : (String)cloneable.get(new Integer(n));
        if (string == null) {
            switch (n) {
                case 9: {
                    WindowManager.putBehind();
                    return;
                }
                case 8: {
                    string = "Clear";
                    break;
                }
                case 61: 
                case 187: {
                    string = "Start Animation [=]";
                    break;
                }
                case 47: 
                case 191: {
                    string = "Reslice [/]...";
                    break;
                }
                case 44: 
                case 188: {
                    string = "Previous Slice [<]";
                    break;
                }
                case 46: 
                case 190: {
                    string = "Next Slice [>]";
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    Roi roi = null;
                    if (imagePlus != null) {
                        roi = imagePlus.getRoi();
                    }
                    if (roi == null) {
                        return;
                    }
                    if ((n2 & 8) != 0) {
                        roi.nudgeCorner(n);
                    } else {
                        roi.nudge(n);
                    }
                    return;
                }
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: {
                    ImageWindow imageWindow;
                    Toolbar.getInstance().selectTool(n);
                    if (imagePlus == null || (imageWindow = imagePlus.getWindow()) == null) break;
                    ImageCanvas imageCanvas = imageWindow.getCanvas();
                    Point point = imageCanvas.getCursorLoc();
                    if (point.x <= 0 || point.y <= 0) break;
                    imageCanvas.setCursor(point.x, point.y);
                    break;
                }
                case 27: {
                    if (imagePlus != null) {
                        imagePlus.getWindow().running = false;
                    }
                    return;
                }
                case 10: {
                    this.toFront();
                    return;
                }
            }
        }
        if (string != null && !string.equals("")) {
            this.doCommand(string);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        IJ.setKeyUp(keyEvent.getKeyCode());
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.doCommand("Quit");
    }

    public void windowActivated(WindowEvent windowEvent) {
        boolean bl;
        if (IJ.isMacintosh()) {
            this.setMenuBar(Menus.getMenuBar());
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (IJ.debugMode) {
            IJ.write("screen: " + dimension);
        }
        if (IJ.debugMode) {
            IJ.write("Window: " + dimension2);
        }
        boolean bl2 = bl = dimension2.width >= dimension.width;
        if (bl && !wasMaximized) {
            wasMaximized = true;
            IJ.beep();
            IJ.showMessage("Error", "The \"ImageJ\" window should not be maximized!\nInstead, make it as small as possible and position\nit so as to minimize overlap of image windows.");
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public int copyText(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.getFocusOwner() != null;
        if (!bl2) {
            return 0;
        }
        int n = this.textPanel.copySelection();
        if (bl && n > 0) {
            this.textPanel.clearSelection();
        }
        this.textPanel.resetSelection();
        return n;
    }

    public boolean clearText() {
        boolean bl;
        boolean bl2 = bl = this.getFocusOwner() != null;
        if (!bl) {
            return false;
        }
        this.textPanel.clearSelection();
        return true;
    }

    void showAboutBox() {
        MessageDialog messageDialog = new MessageDialog((Frame)this, "About ImageJ...", "         ImageJ 1.22d\n \nWayne Rasband (wayne@codon.nih.gov)\nNational Institutes of Health, USA\nhttp://rsb.info.nih.gov/ij/\n \nImageJ is in the public domain.");
    }

    public void register(Class clazz) {
        if (!this.classes.contains(clazz)) {
            this.classes.addElement(clazz);
        }
    }

    void quit() {
        if (this.applet == null) {
            Prefs.savePreferences();
        }
        if (!WindowManager.closeAllWindows()) {
            return;
        }
        ((Component)this).setVisible(false);
        this.dispose();
        if (this.applet == null) {
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        new ImageJ(null);
    }

    public ImageJ() {
        this((Applet)null);
    }

    public ImageJ(Applet applet) {
        super("ImageJ");
        this.applet = applet;
        String string = Prefs.load(this, applet);
        Menus menus = new Menus(this, applet);
        menus.addMenuBar();
        menus.installPopupMenu(this);
        this.notVerified = true;
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 1));
        this.toolbar = new Toolbar();
        this.toolbar.addKeyListener(this);
        panel.add(this.toolbar);
        this.statusBar = new Panel();
        this.statusBar.setLayout(new BorderLayout());
        this.statusBar.setForeground(Color.black);
        this.statusBar.setBackground(Color.lightGray);
        this.statusLine = new Label();
        this.statusLine.addKeyListener(this);
        this.statusLine.addMouseListener(this);
        this.statusBar.add("Center", this.statusLine);
        this.progressBar = new ProgressBar(90, 16);
        this.progressBar.addKeyListener(this);
        this.progressBar.addMouseListener(this);
        this.statusBar.add("East", this.progressBar);
        panel.add(this.statusBar);
        this.add("North", panel);
        this.textPanel = new TextPanel();
        this.textPanel.setTitle("results.txt");
        this.textPanel.setBackground(Color.white);
        this.textPanel.setFont(new Font("Monospaced", 0, 12));
        this.textPanel.addKeyListener(this);
        this.add("Center", this.textPanel);
        IJ.init(this, applet, this.textPanel);
        IJ.write("ImageJ 1.22d");
        if (!string.equals("")) {
            IJ.write("<<" + string + ">>");
        }
        IJ.showStatus("  " + Menus.nPlugins + " plugin commands installed");
        this.addKeyListener(this);
        this.addWindowListener(this);
        this.setResizable(true);
        Point point = this.getPreferredLocation();
        Dimension dimension = this.toolbar.getPreferredSize();
        ((Component)this).setBounds(point.x, point.y, dimension.width + 10, 230);
        ((Component)this).setCursor(Cursor.getDefaultCursor());
        this.setIcon();
        ((Component)this).setVisible(true);
        this.requestFocus();
    }
}

