/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.Executer;
import ij.ImageJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.MessageDialog;
import ij.gui.ProgressBar;
import ij.gui.YesNoCancelDialog;
import ij.plugin.PlugIn;
import ij.text.TextPanel;
import java.applet.Applet;
import java.awt.Frame;
import java.awt.Toolkit;
import java.text.DecimalFormat;

public class IJ {
    public static boolean debugMode = false;
    private static ImageJ ij;
    private static Applet applet;
    private static ProgressBar progressBar;
    private static TextPanel textPanel;
    private static boolean isMac;
    private static boolean altDown;
    private static boolean spaceDown;
    public static final int CANCELED = Integer.MIN_VALUE;
    private static DecimalFormat df;
    private static int dfDigits;

    static void init(ImageJ imageJ, Applet applet, TextPanel textPanel) {
        ij = imageJ;
        IJ.applet = applet;
        progressBar = ij.getProgressBar();
        IJ.textPanel = textPanel;
    }

    public static ImageJ getInstance() {
        return ij;
    }

    public static Object runPlugIn(String string, String string2) {
        return IJ.runPlugIn("", string, string2);
    }

    static Object runPlugIn(String string, String string2, String string3) {
        if (!string2.startsWith("ij")) {
            boolean bl = IJ.altKeyDown();
            return ij.runUserPlugIn(string, string2, string3, bl);
        }
        Object var3_4 = null;
        try {
            Class<?> clazz = Class.forName(string2);
            var3_4 = clazz.newInstance();
            if (var3_4 instanceof PlugIn) {
                ((PlugIn)var3_4).run(string3);
            } else {
                ij.runFilterPlugIn(var3_4, string, string3);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            IJ.write("Plugin not found: " + string2);
        }
        catch (InstantiationException instantiationException) {
            IJ.write("Unable to load plugin (ins)");
        }
        catch (IllegalAccessException illegalAccessException) {
            IJ.write("Unable to load plugin (acc)");
        }
        return var3_4;
    }

    public static void doCommand(String string) {
        if (ij != null) {
            ij.doCommand(string);
        }
    }

    public static void run(String string) {
        Executer executer = new Executer(string);
        executer.run();
    }

    public static Applet getApplet() {
        return applet;
    }

    public static void showStatus(String string) {
        if (ij != null) {
            ij.showStatus(string);
        }
    }

    public static void write(String string) {
        if (textPanel != null) {
            textPanel.append(string);
        } else {
            System.out.println(string);
        }
    }

    public static void setColumnHeadings(String string) {
        if (textPanel != null) {
            textPanel.setColumnHeadings(string);
        }
    }

    public static TextPanel getTextPanel() {
        return textPanel;
    }

    public static void noImage() {
        IJ.showMessage("No Image", "There are no images open.");
    }

    public static void outOfMemory(String string) {
        IJ.write("<<" + string + ": out of memory>>");
    }

    public static void showProgress(double d) {
        if (progressBar != null) {
            progressBar.show(d);
        }
    }

    public static void showMessage(String string, String string2) {
        if (ij != null) {
            new MessageDialog((Frame)ij, string, string2);
        } else {
            System.out.println(string2);
        }
    }

    public static void showMessage(String string) {
        IJ.showMessage("Message", string);
    }

    public static void error(String string) {
        if (ij != null) {
            new MessageDialog((Frame)ij, "ImageJ", string);
        } else {
            System.out.println(string);
        }
    }

    public static boolean showMessageWithCancel(String string, String string2) {
        GenericDialog genericDialog = new GenericDialog(string);
        genericDialog.addMessage(string2);
        genericDialog.showDialog();
        return !genericDialog.wasCanceled();
    }

    public static double getNumber(String string, double d) {
        Frame frame = WindowManager.getCurrentWindow();
        if (frame == null) {
            frame = ij;
        }
        GenericDialog genericDialog = new GenericDialog("Enter a Number", frame);
        genericDialog.addNumericField(string, d, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return -2.147483648E9;
        }
        return genericDialog.getNextNumber();
    }

    public static String getString(String string, String string2) {
        Frame frame = WindowManager.getCurrentWindow();
        if (frame == null) {
            frame = ij;
        }
        GenericDialog genericDialog = new GenericDialog("Enter a String", frame);
        genericDialog.addStringField(string, string2, 20);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return "";
        }
        return genericDialog.getNextString();
    }

    public static synchronized void wait(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static String freeMemory() {
        System.gc();
        long l = Runtime.getRuntime().freeMemory();
        long l2 = Runtime.getRuntime().totalMemory();
        return "Memory: " + (l2 - l) / 1024L + "K";
    }

    public static void showTime(ImagePlus imagePlus, long l, String string) {
        long l2 = System.currentTimeMillis() - l;
        double d = (double)l2 / 1000.0;
        long l3 = imagePlus.getWidth() * imagePlus.getHeight();
        int n = (int)((double)l3 / d);
        String string2 = n > 1000000000 ? "" : (n < 1000000 ? ", " + n + " pixels/second" : ", " + IJ.d2s((double)n / 1000000.0, 1) + " million pixels/second");
        IJ.showStatus(string + d + " seconds" + string2);
    }

    public static String d2s(double d) {
        return IJ.d2s(d, 2);
    }

    public static String d2s(double d, int n) {
        boolean bl;
        if (d == 3.4028234663852886E38) {
            return "3.4e38";
        }
        boolean bl2 = bl = d < 0.0;
        if (bl) {
            d = -d;
        }
        double d2 = Math.round(d * Math.pow(10.0, n));
        double d3 = d2 / Math.pow(10.0, n);
        if (bl) {
            d3 = -d3;
        }
        if (n != dfDigits) {
            switch (n) {
                case 0: {
                    df.applyPattern("0");
                    dfDigits = 0;
                    break;
                }
                case 1: {
                    df.applyPattern("0.0");
                    dfDigits = 1;
                    break;
                }
                case 2: {
                    df.applyPattern("0.00");
                    dfDigits = 2;
                    break;
                }
                case 3: {
                    df.applyPattern("0.000");
                    dfDigits = 3;
                    break;
                }
                case 4: {
                    df.applyPattern("0.0000");
                    dfDigits = 4;
                    break;
                }
                case 5: {
                    df.applyPattern("0.00000");
                    dfDigits = 5;
                    break;
                }
                case 6: {
                    df.applyPattern("0.000000");
                    dfDigits = 6;
                    break;
                }
                case 7: {
                    df.applyPattern("0.0000000");
                    dfDigits = 7;
                    break;
                }
                case 8: {
                    df.applyPattern("0.00000000");
                    dfDigits = 8;
                    break;
                }
            }
        }
        String string = df.format(d3);
        return string;
    }

    public static void register(Class clazz) {
        if (ij != null) {
            ij.register(clazz);
        }
    }

    public static boolean spaceBarDown() {
        return spaceDown;
    }

    public static boolean altKeyDown() {
        return altDown;
    }

    static void setKeyDown(int n) {
        switch (n) {
            case 18: {
                altDown = true;
                break;
            }
            case 32: {
                spaceDown = true;
                ImageWindow imageWindow = WindowManager.getCurrentWindow();
                if (imageWindow == null) break;
                imageWindow.getCanvas().setCursor(-1, -1);
                break;
            }
        }
    }

    static void setKeyUp(int n) {
        switch (n) {
            case 18: {
                altDown = false;
                break;
            }
            case 32: {
                spaceDown = false;
                ImageWindow imageWindow = WindowManager.getCurrentWindow();
                if (imageWindow == null) break;
                imageWindow.getCanvas().setCursor(-1, -1);
                break;
            }
        }
    }

    public static boolean isMacintosh() {
        return isMac && ij != null;
    }

    public static boolean versionLessThan(String string) {
        boolean bl;
        boolean bl2 = bl = "1.22d".compareTo(string) < 0;
        if (bl) {
            IJ.error("This plugin requires ImageJ " + string + " or later.");
        }
        return bl;
    }

    public static int setupDialog(ImagePlus imagePlus, int n) {
        if (imagePlus == null) {
            return n;
        }
        int n2 = imagePlus.getStackSize();
        if (n2 > 1) {
            YesNoCancelDialog yesNoCancelDialog = new YesNoCancelDialog((Frame)IJ.getInstance(), "Process Stack?", "Process all " + n2 + " slices?  There is\n" + "no Undo if you select \"Yes\".");
            if (yesNoCancelDialog.cancelPressed()) {
                return 4096;
            }
            if (yesNoCancelDialog.yesPressed()) {
                return n + 32;
            }
        }
        return n;
    }

    static {
        isMac = System.getProperty("os.name").startsWith("Mac");
        df = new DecimalFormat("0.00");
        dfDigits = 2;
    }
}

