/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.Converter;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Undo;
import ij.WindowManager;
import ij.gui.HistogramWindow;
import ij.gui.ImageWindow;
import ij.gui.NewImage;
import ij.io.FileSaver;
import ij.io.Opener;
import ij.util.Tools;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.Hashtable;

public class Executer
implements Runnable {
    private static String previousCommand;
    private String command;
    private ImagePlus iplus;
    private ImageJ ij;
    private Thread thread;

    public void run() {
        if (this.command == null) {
            return;
        }
        ImagePlus imagePlus = this.iplus;
        this.iplus = null;
        try {
            this.runCommand(this.command, imagePlus);
        }
        catch (Throwable throwable) {
            IJ.showStatus("");
            IJ.showProgress(1.0);
            if (imagePlus != null) {
                imagePlus.unlock();
            }
            if (throwable instanceof OutOfMemoryError) {
                IJ.outOfMemory(this.command);
            }
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            PrintWriter printWriter = new PrintWriter(charArrayWriter);
            throwable.printStackTrace(printWriter);
            String string = charArrayWriter.toString();
            if (IJ.isMacintosh()) {
                string = Tools.fixNewLines(string);
            }
            IJ.write(string);
        }
    }

    public void runCommand(String string, ImagePlus imagePlus) {
        if (string.equals("New...")) {
            new NewImage();
        } else if (string.equals("Open...")) {
            new Opener().openImage();
        } else if (string.equals("Close")) {
            this.closeImage(imagePlus);
        } else if (string.equals("About ImageJ...")) {
            this.ij.showAboutBox();
        } else if (string.equals("Cut")) {
            this.copy(imagePlus, true);
        } else if (string.equals("Copy")) {
            this.copy(imagePlus, false);
        } else if (string.equals("ImageJ [enter]")) {
            this.ij.toFront();
        } else if (string.equals("Put Behind [tab]")) {
            WindowManager.putBehind();
        } else if (string.equals("Quit")) {
            IJ.getInstance().quit();
        } else {
            Hashtable hashtable = Menus.getCommands();
            String string2 = (String)hashtable.get(string);
            if (string2 != null) {
                this.runPlugIn(string, string2);
            } else {
                this.runImageCommand(string, imagePlus);
            }
        }
    }

    public void runImageCommand(String string, ImagePlus imagePlus) {
        ImageWindow imageWindow = null;
        if (imagePlus != null) {
            if (!imagePlus.lock()) {
                return;
            }
            imageWindow = imagePlus.getWindow();
        }
        if (string.equals("Revert")) {
            if (imageWindow != null) {
                imagePlus.revert();
            } else {
                IJ.noImage();
            }
        } else if (string.equals("Save")) {
            if (imageWindow != null) {
                new FileSaver(imagePlus).save();
            } else {
                IJ.noImage();
            }
        } else if (string.equals("Paste")) {
            if (imageWindow != null) {
                imageWindow.paste();
            } else {
                IJ.noImage();
            }
        } else if (string.equals("Select All")) {
            if (imageWindow != null) {
                imagePlus.setRoi(0, 0, imagePlus.getWidth(), imagePlus.getHeight());
            } else {
                IJ.noImage();
            }
        } else if (string.equals("Select None")) {
            if (imageWindow != null) {
                imagePlus.killRoi();
            } else {
                IJ.noImage();
            }
        } else if (this.isConversionCommand(string)) {
            if (imageWindow != null) {
                new Converter(imagePlus).convert(string);
            } else {
                IJ.noImage();
            }
        } else if (string.equals("Histogram")) {
            if (imageWindow != null) {
                new HistogramWindow(imagePlus);
            } else {
                IJ.noImage();
            }
        } else if (string.startsWith("Restore")) {
            if (imageWindow != null) {
                imagePlus.restoreRoi();
            } else {
                IJ.noImage();
            }
        } else if (string.equals("Undo")) {
            if (imageWindow != null) {
                Undo.undo();
            } else {
                IJ.noImage();
            }
        } else {
            IJ.error("Unrecognized command: " + string);
        }
        if (imagePlus != null) {
            imagePlus.unlock();
        }
    }

    private boolean isConversionCommand(String string) {
        return string.equals("8-bit") || string.equals("16-bit") || string.equals("32-bit") || string.equals("8-bit Color") || string.equals("RGB Color") || string.equals("RGB Stack") || string.equals("HSB Stack");
    }

    void runPlugIn(String string, String string2) {
        int n;
        String string3 = "";
        if (string2.endsWith("\")") && (n = string2.lastIndexOf("(\"")) > 0) {
            string3 = string2.substring(n + 2, string2.length() - 2);
            string2 = string2.substring(0, n);
        }
        IJ.runPlugIn(string, string2, string3);
    }

    void roiRequired() {
        IJ.error("Selection required");
    }

    void copy(ImagePlus imagePlus, boolean bl) {
        if (this.ij.copyText(bl) > 0) {
            return;
        }
        if (imagePlus == null) {
            IJ.noImage();
            return;
        }
        imagePlus.getWindow().copy(bl);
    }

    void closeImage(ImagePlus imagePlus) {
        if (imagePlus == null) {
            IJ.noImage();
        } else {
            ImageWindow imageWindow = imagePlus.getWindow();
            if (imageWindow != null) {
                imageWindow.close();
            }
        }
    }

    public static String getCommand() {
        return previousCommand;
    }

    Executer(String string) {
        this.command = string;
        this.iplus = WindowManager.getCurrentImage();
        this.ij = IJ.getInstance();
    }

    Executer(String string, ImagePlus imagePlus) {
        this.iplus = imagePlus;
        if (string.startsWith("Repeat")) {
            this.command = previousCommand;
        } else {
            this.command = string;
            if (!string.equals("Undo") && !string.equals("Close")) {
                previousCommand = string;
            }
        }
        this.ij = IJ.getInstance();
        this.thread = new Thread((Runnable)this, string);
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }
}

