/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Menus;
import ij.Undo;
import ij.gui.ImageWindow;
import ij.gui.StackWindow;
import ij.process.ImageConverter;
import ij.process.StackConverter;

public class Converter {
    static boolean newWindowCreated;
    ImagePlus imp;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void convert(String string) {
        int n = this.imp.getType();
        ImageStack imageStack = null;
        if (this.imp.getStackSize() > 1) {
            imageStack = this.imp.getStack();
        }
        String string2 = "Converting to " + string;
        IJ.showStatus(string2 + "...");
        long l = System.currentTimeMillis();
        boolean bl = this.imp.getRoi() != null;
        this.imp.killRoi();
        boolean bl2 = this.imp.changes;
        this.imp.changes = IJ.getApplet() == null;
        newWindowCreated = false;
        try {
            if (imageStack != null) {
                if (imageStack.isRGB() && string.equals("RGB Color")) {
                    new ImageConverter(this.imp).convertRGBStackToRGB();
                    newWindowCreated = true;
                    new ImageWindow(this.imp);
                } else if (imageStack.isHSB() && string.equals("RGB Color")) {
                    new ImageConverter(this.imp).convertHSBToRGB();
                    newWindowCreated = true;
                    new ImageWindow(this.imp);
                } else if (string.equals("8-bit")) {
                    new StackConverter(this.imp).convertToGray8();
                } else if (string.equals("32-bit")) {
                    new StackConverter(this.imp).convertToGray32();
                } else {
                    if (!string.equals("RGB Color")) throw new IllegalArgumentException();
                    new StackConverter(this.imp).convertToRGB();
                }
            } else {
                Undo.setup(2, this.imp);
                ImageConverter imageConverter = new ImageConverter(this.imp);
                if (string.equals("8-bit")) {
                    imageConverter.convertToGray8();
                } else if (string.equals("16-bit")) {
                    imageConverter.convertToGray16();
                } else if (string.equals("32-bit")) {
                    imageConverter.convertToGray32();
                } else if (string.equals("RGB Stack")) {
                    Undo.reset();
                    imageConverter.convertToRGBStack();
                    newWindowCreated = true;
                    new StackWindow(this.imp);
                } else if (string.equals("HSB Stack")) {
                    Undo.reset();
                    imageConverter.convertToHSB();
                    newWindowCreated = true;
                    new StackWindow(this.imp);
                } else if (string.equals("RGB Color")) {
                    imageConverter.convertToRGB();
                } else if (string.equals("8-bit Color")) {
                    int n2 = 256;
                    if (n == 4) {
                        n2 = (int)IJ.getNumber("Number of Colors (2-256):", 256.0);
                    }
                    l = System.currentTimeMillis();
                    if (n2 != Integer.MIN_VALUE) {
                        imageConverter.convertRGBtoIndexedColor(n2);
                    }
                } else {
                    this.imp.changes = bl2;
                    return;
                }
                IJ.showProgress(1.0);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.unsupportedConversion(this.imp);
            IJ.showStatus("");
            Undo.reset();
            this.imp.changes = bl2;
            Menus.updateMenus();
            return;
        }
        if (bl) {
            this.imp.restoreRoi();
        }
        IJ.showTime(this.imp, l, "");
        this.imp.repaintWindow();
        Menus.updateMenus();
    }

    void unsupportedConversion(ImagePlus imagePlus) {
        IJ.showMessage("Converter", "Supported Conversions:\n \n8-bit -> 16-bit\n8-bit -> 32-bit*\n8-bit -> RGB Color*\n16-bit -> 8-bit*\n16-bit -> 32-bit*\n16-bit -> RGB Color*\n32-bit -> 8-bit*\n32-bit -> 16-bit\n32-bit -> RGB Color*\n8-bit Color -> 8-bit (grayscale)*\n8-bit Color -> RGB Color\nRGB Color -> 8-bit (grayscale)*\nRGB Color -> 8-bit Color\nRGB Color -> RGB Stack\nRGB Color -> HSB Stack\nRGB Stack -> RGB Color\nHSB Stack -> RGB Color\n \n* works with stacks\n");
    }

    public Converter(ImagePlus imagePlus) {
        this.imp = imagePlus;
    }
}

