/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas.adde;

import edu.wisc.ssec.mcidas.adde.AddeURLConnection;
import edu.wisc.ssec.mcidas.adde.AddeURLException;
import java.io.DataInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;

public class ReadTextFile {
    private int status = 0;
    private String statusString = "OK";
    private boolean debug = false;
    private Vector linesOfText = null;
    private URLConnection urlc;
    private DataInputStream dis;

    public String getStatus() {
        return this.statusString;
    }

    public int getStatusCode() {
        return this.status;
    }

    public Vector getText() {
        return this.linesOfText;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray.length == 0 ? "adde://adde.ucar.edu/text?file=PUBLIC.SRV" : stringArray[0];
        ReadTextFile readTextFile = new ReadTextFile(string);
        String string2 = readTextFile.getStatus();
        System.out.println("Status = " + string2);
        if (string2.equals("OK")) {
            Vector vector = readTextFile.getText();
            int n = 0;
            while (n < vector.size()) {
                System.out.println((String)vector.elementAt(n));
                ++n;
            }
        }
    }

    public ReadTextFile(String string) {
        Object object;
        try {
            URL uRL = new URL(string);
            if (this.debug) {
                System.out.println("Request: " + string);
            }
            this.urlc = uRL.openConnection();
            object = this.urlc.getInputStream();
            this.dis = new DataInputStream((InputStream)object);
        }
        catch (AddeURLException addeURLException) {
            this.status = -1;
            this.statusString = "No file found";
            object = addeURLException.toString();
            if (((String)object).indexOf(" Accounting ") != -1) {
                this.statusString = "No accounting data";
                this.status = -3;
            }
            if (this.debug) {
                System.out.println("ReadText AF Exception:" + (String)object);
            }
        }
        catch (Exception exception) {
            this.status = -2;
            if (this.debug) {
                System.out.println("ReadText Exception:" + exception);
            }
            this.statusString = "Error opening connection: " + exception;
        }
        this.linesOfText = new Vector();
        if (this.status == 0) {
            try {
                int n = ((AddeURLConnection)this.urlc).getInitialRecordSize();
                if (this.debug) {
                    System.out.println("ReadTextFile: initial numBytes = " + n);
                }
                n = this.dis.readInt();
                while ((n = this.dis.readInt()) != 0) {
                    if (this.debug) {
                        System.out.println("ReadTextFile: numBytes = " + n);
                    }
                    object = new byte[n];
                    this.dis.readFully((byte[])object, 0, n);
                    String string2 = new String((byte[])object);
                    if (this.debug) {
                        System.out.println(string2);
                    }
                    this.linesOfText.addElement(string2);
                }
            }
            catch (Exception exception) {
                this.statusString = " " + exception;
                System.out.println(" " + exception);
            }
            if (this.linesOfText.size() < 1) {
                this.statusString = "No data read";
            }
            this.status = this.linesOfText.size();
        }
    }

    static {
        try {
            String string = System.getProperty("java.protocol.handler.pkgs");
            String string2 = null;
            if (string == null) {
                string2 = "edu.wisc.ssec.mcidas";
            } else if (string.indexOf("edu.wisc.ssec.mcidas") < 0) {
                string2 = "edu.wisc.ssec.mcidas | " + string;
            }
            if (string2 != null) {
                System.setProperty("java.protocol.handler.pkgs", string2);
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to set System Property: java.protocol.handler.pkgs");
        }
    }
}

