/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas.adde;

import edu.wisc.ssec.mcidas.AreaDirectory;
import edu.wisc.ssec.mcidas.adde.AddeSatBands;
import edu.wisc.ssec.mcidas.adde.AddeServerInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GetAreaGUI
extends JDialog {
    AddeServerInfo asi;
    String[] sl;
    String selectedServer;
    String selectedGroup;
    String selectedDescr;
    String selectedDateTime;
    String coordType;
    String actionButtonString;
    String userName;
    String projectNumber;
    boolean serverUpdated;
    boolean groupUpdated;
    boolean descrUpdated;
    boolean multipleImages;
    ActionListener al = null;
    int baseNumLines;
    int baseNumEles;
    double resLat;
    double resLon;
    int[] bandListIndex;
    String[] bandList;
    String selectedBand;
    String selectedUnit;
    int selectedBandIndex;
    String[][][] calInfo = null;
    boolean doingRes;
    NumberFormat nf3;
    Properties dataProp;
    StringBuffer serverList;
    AreaDirectory[][] ad;
    int areaIndex;
    String[] bandNames;
    AddeSatBands asb;
    boolean closeOnAction = true;
    boolean useDefaults = true;
    boolean gotUserDefaults = false;
    private JPanel PanelSGD;
    private JPanel PanelSG;
    private JPanel PanelServer;
    private JLabel ServerLabel;
    private JComboBox ServerSelector;
    private JPanel PanelGroup;
    private JLabel jLabel2;
    private JComboBox GroupSelector;
    private JPanel PanelDescr;
    private JLabel jLabel3;
    private JComboBox DescrSelector;
    private JPanel PanelListMag;
    private JPanel PanelMag;
    private JPanel jPanel13;
    private JPanel jPanel9;
    private JSlider LMagSlider;
    private JLabel LMagLabel;
    private JPanel jPanel10;
    private JLabel EMagLabel;
    private JSlider EMagSlider;
    private JLabel DateTimeLabel;
    private JPanel PanelList;
    private JScrollPane DateTimeScrollPanel;
    private JList DateTimeList;
    private JPanel LinesElesPanel;
    private JLabel SizeLabel;
    private JPanel jPanel7;
    private JLabel NumLinesLabel;
    private JTextField NumLinesText;
    private JLabel NumElesLabel;
    private JTextField NumElesText;
    private JCheckBox userDefaultsCheckBox;
    private JPanel PanelBandUnit;
    private JPanel BandPanel;
    private JLabel BandLabel;
    private JComboBox BandBox;
    private JPanel UnitsPanel;
    private JLabel UnitLabel;
    private JComboBox UnitBox;
    private JPanel UserActionPanel;
    private JButton userActionButton;
    private JPanel PanelStatus;
    private JTextField statusLabel;
    private JPanel PanelLoc;
    private JPanel jPanel11;
    private JLabel PlaceLabel;
    private JRadioButton LatLonButton;
    private JRadioButton LinEleButton;
    private JRadioButton IDButton;
    private JPanel jPanel12;
    private JLabel LatLineLabel;
    private JLabel LonEleLabel;
    private JTextField LatLineText;
    private JTextField LonEleText;
    private ButtonGroup buttGroupLoc;
    private int LMagValue;
    private int EMagValue;
    private String calText = null;

    private void setupGUI(String string, boolean bl, boolean bl2) {
        Object object;
        this.setDefaultCloseOperation(0);
        this.serverUpdated = false;
        this.groupUpdated = false;
        this.descrUpdated = false;
        this.bandNames = null;
        this.closeOnAction = bl2;
        this.selectedUnit = " ";
        this.selectedBand = " ";
        this.selectedBandIndex = -1;
        this.doingRes = false;
        this.asb = null;
        this.multipleImages = bl;
        this.nf3 = NumberFormat.getNumberInstance();
        this.nf3.setMaximumFractionDigits(3);
        this.actionButtonString = string;
        this.asi = new AddeServerInfo();
        String[] stringArray = this.asi.getServerList();
        this.dataProp = new Properties();
        try {
            object = new FileInputStream("GetAreaGUI.properties");
            this.dataProp.load((InputStream)object);
            ((FileInputStream)object).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = (String)((Hashtable)this.dataProp).get("user|server|list");
        this.serverList = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < stringArray.length) {
            arrayList.add(stringArray[n]);
            ++n;
        }
        if (object != null) {
            this.serverList.append((String)object);
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",");
            int n2 = stringTokenizer.countTokens();
            int n3 = 0;
            while (n3 < n2) {
                arrayList.add(stringTokenizer.nextToken());
                ++n3;
            }
        }
        this.sl = new String[arrayList.size()];
        int n4 = 0;
        while (n4 < arrayList.size()) {
            this.sl[n4] = (String)arrayList.get(n4);
            ++n4;
        }
        this.selectedServer = null;
        this.selectedGroup = null;
        this.selectedDescr = null;
        this.selectedDateTime = null;
        this.baseNumLines = -1;
        this.baseNumEles = -1;
        this.initComponents();
        this.buttGroupLoc = new ButtonGroup();
        this.buttGroupLoc.add(this.LatLonButton);
        this.buttGroupLoc.add(this.LinEleButton);
        this.buttGroupLoc.add(this.IDButton);
        this.pack();
    }

    public void setServer(String string) {
        this.selectedServer = string;
    }

    public String getServer() {
        return this.selectedServer;
    }

    public void setGroup(String string) {
        this.selectedGroup = string;
    }

    public String getGroup() {
        return this.selectedGroup;
    }

    public void setDescr(String string) {
        this.selectedDescr = string;
    }

    public String getDescr() {
        return this.selectedDescr;
    }

    public void setMag(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            int n = Integer.parseInt(stringTokenizer.nextToken().trim());
            int n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
            this.setLineMag(n);
            this.setEleMag(n2);
        } else {
            this.setLineMag(1);
            this.setEleMag(1);
        }
    }

    public String getMag() {
        return this.LMagValue + " " + this.EMagValue;
    }

    public void setLineMag(int n) {
        this.LMagValue = n;
        if (this.LMagValue > -2 && this.LMagValue < 2) {
            this.LMagValue = 1;
        }
        this.LMagSlider.setValue(this.LMagValue + 50);
        if (this.doingRes) {
            double d = this.resLat / (double)this.LMagValue;
            if (this.LMagValue < 0) {
                d = -(this.resLat * (double)this.LMagValue);
            }
            this.LMagLabel.setText("Line Resolution = " + this.nf3.format(d));
        } else {
            this.LMagLabel.setText("Line Magnification = " + this.LMagValue);
        }
    }

    public int getLinMag() {
        return this.LMagValue;
    }

    public void setEleMag(int n) {
        this.EMagValue = n;
        if (this.EMagValue > -2 && this.EMagValue < 2) {
            this.EMagValue = 1;
        }
        this.EMagSlider.setValue(this.EMagValue + 50);
        if (this.doingRes) {
            double d = this.resLon / (double)this.EMagValue;
            if (this.EMagValue < 0) {
                d = -(this.resLon * (double)this.EMagValue);
            }
            this.EMagLabel.setText("Element Resolution = " + this.nf3.format(d));
        } else {
            this.EMagLabel.setText("Element Magnification = " + this.EMagValue);
        }
    }

    public int getEleMag() {
        return this.EMagValue;
    }

    public void setCoordType(String string) {
        this.LatLonButton.setSelected(false);
        this.LinEleButton.setSelected(false);
        this.IDButton.setSelected(false);
        if (string.equalsIgnoreCase("E")) {
            this.LatLonButton.setSelected(true);
        }
        if (string.equalsIgnoreCase("I")) {
            this.LinEleButton.setSelected(true);
        }
        if (string.equalsIgnoreCase("S")) {
            this.IDButton.setSelected(true);
        }
        this.setLocButtonLabel();
    }

    public String getCoordType() {
        return this.coordType;
    }

    public void setLocationString(String string) {
        String string2 = " ";
        String string3 = " ";
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            string2 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
        }
        this.LatLineText.setText(string2);
        this.LonEleText.setText(string3);
    }

    public String getLocationString() {
        String string = this.LatLineText.getText() + " " + this.LonEleText.getText();
        return string;
    }

    public void setBand(String string) {
    }

    public String getBand() {
        return this.selectedBand;
    }

    public void setNumLinesEles(String string) {
        if (string == null || string.trim().length() < 3) {
            this.NumLinesText.setText(" ");
            this.NumElesText.setText(" ");
            this.baseNumLines = -1;
            this.baseNumEles = -1;
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        this.NumLinesText.setText(string2);
        this.NumElesText.setText(string3);
        this.baseNumLines = Integer.parseInt(string2.trim());
        this.baseNumEles = Integer.parseInt(string3.trim());
    }

    public String getNumLinesEles() {
        String string = this.NumLinesText.getText() + " " + this.NumElesText.getText();
        return string;
    }

    public String getDay() {
        int n;
        this.selectedDateTime = (String)this.DateTimeList.getSelectedValue();
        String string = null;
        if (this.selectedDateTime != null && (n = this.selectedDateTime.indexOf("/")) > 0) {
            string = this.selectedDateTime.substring(0, n).trim();
        }
        return string;
    }

    public void setDay(String string) {
        this.setDateTime(string, this.getTime());
    }

    public String getTime() {
        int n;
        this.selectedDateTime = (String)this.DateTimeList.getSelectedValue();
        String string = null;
        if (this.selectedDateTime != null && (n = this.selectedDateTime.indexOf("/")) > 0) {
            string = this.selectedDateTime.substring(n + 1).trim();
        }
        return string;
    }

    public void setTime(String string) {
        this.setDateTime(this.getDay(), string);
    }

    public void setDateTime(String string, String string2) {
        this.selectedDateTime = string + " / " + string2;
    }

    public void setUnit(String string) {
    }

    public String getUnit() {
        return this.selectedUnit;
    }

    public void setCal(String string) {
        this.calText = string;
    }

    public String getCal() {
        return this.calText;
    }

    public void setDoc(String string) {
        if (string == null || string.indexOf("1") <= -1) {
            // empty if block
        }
    }

    public String getDoc() {
        return "1";
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setProjectNumber(String string) {
        this.projectNumber = string;
    }

    public String getProjectNumber() {
        return this.projectNumber;
    }

    private void initComponents() {
        this.PanelSGD = new JPanel();
        this.PanelSG = new JPanel();
        this.PanelServer = new JPanel();
        this.ServerLabel = new JLabel();
        this.ServerSelector = new JComboBox();
        this.PanelGroup = new JPanel();
        this.jLabel2 = new JLabel();
        this.GroupSelector = new JComboBox();
        this.PanelDescr = new JPanel();
        this.jLabel3 = new JLabel();
        this.DescrSelector = new JComboBox();
        this.PanelListMag = new JPanel();
        this.PanelMag = new JPanel();
        this.jPanel13 = new JPanel();
        this.jPanel9 = new JPanel();
        this.LMagSlider = new JSlider();
        this.LMagLabel = new JLabel();
        this.jPanel10 = new JPanel();
        this.EMagLabel = new JLabel();
        this.EMagSlider = new JSlider();
        this.DateTimeLabel = new JLabel();
        this.PanelList = new JPanel();
        this.DateTimeScrollPanel = new JScrollPane();
        String[] stringArray = new String[]{"Date-times of available", "images will appear here"};
        this.DateTimeList = new JList<String>(stringArray);
        this.LinesElesPanel = new JPanel();
        this.SizeLabel = new JLabel();
        this.jPanel7 = new JPanel();
        this.NumLinesLabel = new JLabel();
        this.NumLinesText = new JTextField();
        this.NumElesLabel = new JLabel();
        this.NumElesText = new JTextField();
        this.userDefaultsCheckBox = new JCheckBox();
        this.PanelBandUnit = new JPanel();
        this.BandPanel = new JPanel();
        this.BandLabel = new JLabel();
        this.BandBox = new JComboBox();
        this.UnitsPanel = new JPanel();
        this.UnitLabel = new JLabel();
        this.UnitBox = new JComboBox();
        this.UserActionPanel = new JPanel();
        this.userActionButton = new JButton();
        this.PanelStatus = new JPanel();
        this.statusLabel = new JTextField();
        this.PanelLoc = new JPanel();
        this.jPanel11 = new JPanel();
        this.PlaceLabel = new JLabel();
        this.LatLonButton = new JRadioButton();
        this.LinEleButton = new JRadioButton();
        this.IDButton = new JRadioButton();
        this.jPanel12 = new JPanel();
        this.LatLineLabel = new JLabel();
        this.LonEleLabel = new JLabel();
        this.LatLineText = new JTextField();
        this.LonEleText = new JTextField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setFont(new Font("SansSerif", 0, 10));
        this.addWindowListener(new WindowAdapter(this){
            private final /* synthetic */ GetAreaGUI this$0;

            public void windowClosing(WindowEvent windowEvent) {
                GetAreaGUI.access$0(this.this$0, windowEvent);
            }
            {
                this.this$0 = getAreaGUI;
                this.constructor$0(getAreaGUI);
            }

            private final void constructor$0(GetAreaGUI getAreaGUI) {
            }
        });
        this.PanelSGD.setLayout(new BorderLayout());
        this.PanelSGD.setMaximumSize(new Dimension(500, 160));
        this.PanelServer.setLayout(new GridLayout(2, 1));
        this.PanelServer.setPreferredSize(new Dimension(180, 45));
        this.PanelServer.setBorder(new BevelBorder(0));
        this.ServerLabel.setText("Server");
        this.ServerLabel.setToolTipText("Select an ADDE Server from the list");
        this.ServerLabel.setHorizontalAlignment(0);
        this.PanelServer.add(this.ServerLabel);
        this.ServerSelector.setToolTipText("Select an ADDE Server from the list");
        this.ServerSelector.setBackground(Color.lightGray);
        this.ServerSelector.setEditable(true);
        this.ServerSelector.setActionCommand("serverSelected");
        this.replaceList(this.ServerSelector, this.sl, "Select ADDE server");
        this.ServerSelector.setSelectedIndex(0);
        this.ServerSelector.addActionListener(new ActionListener(this){
            private final /* synthetic */ GetAreaGUI this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                GetAreaGUI.access$1(this.this$0, actionEvent);
            }
            {
                this.this$0 = getAreaGUI;
                this.constructor$0(getAreaGUI);
            }

            private final void constructor$0(GetAreaGUI getAreaGUI) {
            }
        });
        this.PanelServer.add(this.ServerSelector);
        this.PanelSG.add(this.PanelServer);
        this.PanelGroup.setLayout(new GridLayout(2, 1));
        this.PanelGroup.setPreferredSize(new Dimension(160, 45));
        this.PanelGroup.setBorder(new BevelBorder(0));
        this.jLabel2.setText("Dataset");
        this.jLabel2.setToolTipText("Select a dataset from the list");
        this.jLabel2.setHorizontalAlignment(0);
        this.PanelGroup.add(this.jLabel2);
        this.GroupSelector.setToolTipText("Select an ADDE data group from the list");
        this.GroupSelector.setBackground(Color.lightGray);
        this.GroupSelector.setActionCommand("groupSelected");
        this.GroupSelector.addActionListener(new ActionListener(this){
            private final /* synthetic */ GetAreaGUI this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                GetAreaGUI.access$2(this.this$0, actionEvent);
            }
            {
                this.this$0 = getAreaGUI;
                this.constructor$0(getAreaGUI);
            }

            private final void constructor$0(GetAreaGUI getAreaGUI) {
            }
        });
        this.PanelGroup.add(this.GroupSelector);
        this.PanelSG.add(this.PanelGroup);
        this.PanelSGD.add((Component)this.PanelSG, "North");
        this.PanelDescr.setLayout(new BorderLayout());
        this.PanelDescr.setBorder(new BevelBorder(0));
        this.PanelDescr.setMaximumSize(new Dimension(400, 50));
        this.jLabel3.setText("Data Type");
        this.jLabel3.setToolTipText("Select a Data Type; available dates and times will appear below");
        this.jLabel3.setHorizontalAlignment(0);
        this.PanelDescr.add((Component)this.jLabel3, "North");
        this.DescrSelector.setName("descrType");
        this.DescrSelector.setToolTipText("Select an ADDE dataset; available dates and times will appear below");
        this.DescrSelector.setBackground(Color.lightGray);
        this.DescrSelector.setActionCommand("descrSelected");
        this.DescrSelector.setMaximumSize(new Dimension(500, 20));
        this.DescrSelector.addActionListener(new ActionListener(this){
            private final /* synthetic */ GetAreaGUI this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                GetAreaGUI.access$3(this.this$0, actionEvent);
            }
            {
                this.this$0 = getAreaGUI;
                this.constructor$0(getAreaGUI);
            }

            private final void constructor$0(GetAreaGUI getAreaGUI) {
            }
        });
        this.PanelDescr.add((Component)this.DescrSelector, "South");
        this.PanelSGD.add((Component)this.PanelDescr, "South");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.getContentPane().add((Component)this.PanelSGD, gridBagConstraints);
        this.PanelListMag.setLayout(new GridBagLayout());
        this.PanelListMag.setMinimumSize(new Dimension(400, 150));
        this.PanelMag.setLayout(new BorderLayout(10, 5));
        this.jPanel13.setLayout(new BorderLayout(10, 0));
        this.jPanel13.setBorder(new BevelBorder(0));
        this.jPanel9.setLayout(new BorderLayout());
        this.LMagSlider.setToolTipText("Slide to set line magnification factor");
        this.LMagSlider.addChangeListener(new ChangeListener(this){
            private final /* synthetic */ GetAreaGUI this$0;

            public void stateChanged(ChangeEvent changeEvent) {
                GetAreaGUI.access$4(this.this$0, changeEvent);
            }
            {
                this.this$0 = getAreaGUI;
                this.constructor$0(getAreaGUI);
            }

            private final void constructor$0(GetAreaGUI getAreaGUI) {
            }
        });
        this.jPanel9.add((Component)this.LMagSlider, "South");
        this.LMagLabel.setText("Line Magnification");
        this.LMagLabel.setHorizontalAlignment(0);
        this.jPanel9.add((Component)this.LMagLabel, "North");
        this.jPanel13.add((Component)this.jPanel9, "North");
        this.jPanel10.setLayout(new BorderLayout());
        this.EMagLabel.setText("Element Magnification");
        this.EMagLabel.setHorizontalAlignment(0);
        this.jPanel10.add((Component)this.EMagLabel, "North");
        this.EMagSlider.setToolTipText("Slide to select element magnification factor");
        this.EMagSlider.addChangeListener(new ChangeListener(this){
            private final /* synthetic */ GetAreaGUI this$0;

            public void stateChanged(ChangeEvent changeEvent) {
                GetAreaGUI.access$5(this.this$0, changeEvent);
            }
            {
                this.this$0 = getAreaGUI;
                this.constructor$0(getAreaGUI);
            }

            private final void constructor$0(GetAreaGUI getAreaGUI) {
            }
        });
        this.jPanel10.add((Component)this.EMagSlider, "South");
        this.jPanel13.add((Component)this.jPanel10, "South");
        this.PanelMag.add((Component)this.jPanel13, "North");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridheight = 3;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.anchor = 11;
        this.PanelListMag.add((Component)this.PanelMag, gridBagConstraints2);
        this.DateTimeLabel.setText("List of available Date / Times");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 15;
        this.PanelListMag.add((Component)this.DateTimeLabel, gridBagConstraints2);
        this.PanelList.setLayout(new BorderLayout(0, 10));
        this.PanelList.setPreferredSize(new Dimension(180, 150));
        this.PanelList.setMinimumSize(new Dimension(180, 150));
        this.DateTimeScrollPanel.setPreferredSize(new Dimension(180, 150));
        this.DateTimeScrollPanel.setMinimumSize(new Dimension(180, 150));
        this.DateTimeList.setToolTipText("Click on the date-time you want");
        this.DateTimeList.setBorder(new BevelBorder(0));
        this.DateTimeList.setName("");
        this.DateTimeList.setVisibleRowCount(10);
        this.DateTimeList.setSelectionMode(0);
        this.DateTimeList.addListSelectionListener(new ListSelectionListener(this){
            private final /* synthetic */ GetAreaGUI this$0;

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                GetAreaGUI.access$6(this.this$0, listSelectionEvent);
            }
            {
                this.this$0 = getAreaGUI;
                this.constructor$0(getAreaGUI);
            }

            private final void constructor$0(GetAreaGUI getAreaGUI) {
            }
        });
        this.DateTimeScrollPanel.setViewportView(this.DateTimeList);
        this.PanelList.add((Component)this.DateTimeScrollPanel, "Center");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridheight = 4;
        gridBagConstraints2.insets = new Insets(0, 3, 0, 0);
        gridBagConstraints2.anchor = 11;
        this.PanelListMag.add((Component)this.PanelList, gridBagConstraints2);
        this.LinesElesPanel.setLayout(new BorderLayout());
        this.LinesElesPanel.setBorder(new BevelBorder(0));
        this.SizeLabel.setText("Size of Image to Get");
        this.SizeLabel.setToolTipText("Enter the number of lines and elements for the image you want (def=480 x 640)");
        this.SizeLabel.setHorizontalAlignment(0);
        this.LinesElesPanel.add((Component)this.SizeLabel, "North");
        this.jPanel7.setLayout(new FlowLayout(1, 5, 0));
        this.NumLinesLabel.setText("Lines:");
        this.NumLinesLabel.setToolTipText("Enter the number of image lines you want");
        this.jPanel7.add(this.NumLinesLabel);
        this.NumLinesText.setToolTipText("Enter number of lines (def=480)");
        this.NumLinesText.setColumns(5);
        this.NumLinesText.setText(" ");
        this.jPanel7.add(this.NumLinesText);
        this.NumElesLabel.setText("       Elements:");
        this.NumElesLabel.setToolTipText("Enter the number of image Elements you want");
        this.jPanel7.add(this.NumElesLabel);
        this.NumElesText.setToolTipText("Enter number of elements (def=640)");
        this.NumElesText.setColumns(5);
        this.NumElesText.setText(" ");
        this.jPanel7.add(this.NumElesText);
        this.LinesElesPanel.add((Component)this.jPanel7, "South");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.insets = new Insets(2, 0, 2, 0);
        this.PanelListMag.add((Component)this.LinesElesPanel, gridBagConstraints2);
        this.userDefaultsCheckBox.setAlignmentX(0.5f);
        this.userDefaultsCheckBox.setToolTipText("Check this box to use your defaults for size and location");
        this.userDefaultsCheckBox.setSelected(true);
        this.userDefaultsCheckBox.setText("Use my defaults");
        this.userDefaultsCheckBox.addActionListener(new ActionListener(this){
            private final /* synthetic */ GetAreaGUI this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                GetAreaGUI.access$7(this.this$0, actionEvent);
            }
            {
                this.this$0 = getAreaGUI;
                this.constructor$0(getAreaGUI);
            }

            private final void constructor$0(GetAreaGUI getAreaGUI) {
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.anchor = 11;
        this.PanelListMag.add((Component)this.userDefaultsCheckBox, gridBagConstraints2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)this.PanelListMag, gridBagConstraints);
        this.PanelBandUnit.setLayout(new GridBagLayout());
        this.PanelBandUnit.setPreferredSize(new Dimension(500, 75));
        this.PanelBandUnit.setMinimumSize(new Dimension(300, 75));
        this.BandPanel.setLayout(new BorderLayout());
        this.BandPanel.setBorder(new SoftBevelBorder(0));
        this.BandLabel.setAlignmentX(0.5f);
        this.BandLabel.setText("Channel");
        this.BandLabel.setToolTipText("Select channel from list");
        this.BandLabel.setHorizontalAlignment(0);
        this.BandPanel.add((Component)this.BandLabel, "North");
        this.BandBox.setToolTipText("Select a band/channel number from the list or enter one");
        this.BandBox.setActionCommand("bandBoxChanged");
        this.BandBox.addActionListener(new ActionListener(this){
            private final /* synthetic */ GetAreaGUI this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                GetAreaGUI.access$8(this.this$0, actionEvent);
            }
            {
                this.this$0 = getAreaGUI;
                this.constructor$0(getAreaGUI);
            }

            private final void constructor$0(GetAreaGUI getAreaGUI) {
            }
        });
        this.BandPanel.add((Component)this.BandBox, "West");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridwidth = -1;
        gridBagConstraints3.ipady = 5;
        gridBagConstraints3.insets = new Insets(0, 5, 0, 5);
        this.PanelBandUnit.add((Component)this.BandPanel, gridBagConstraints3);
        this.UnitsPanel.setLayout(new BorderLayout());
        this.UnitsPanel.setBorder(new SoftBevelBorder(0));
        this.UnitLabel.setText("Unit");
        this.UnitLabel.setToolTipText("Select unit from list after selecting Band");
        this.UnitLabel.setHorizontalAlignment(0);
        this.UnitsPanel.add((Component)this.UnitLabel, "North");
        this.UnitBox.setToolTipText("Select a unit from the list or enter a units code");
        this.UnitBox.setActionCommand("unitBoxChanged");
        this.UnitBox.addActionListener(new ActionListener(this){
            private final /* synthetic */ GetAreaGUI this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                GetAreaGUI.access$9(this.this$0, actionEvent);
            }
            {
                this.this$0 = getAreaGUI;
                this.constructor$0(getAreaGUI);
            }

            private final void constructor$0(GetAreaGUI getAreaGUI) {
            }
        });
        this.UnitsPanel.add((Component)this.UnitBox, "West");
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridwidth = -1;
        gridBagConstraints3.ipadx = 2;
        gridBagConstraints3.ipady = 5;
        gridBagConstraints3.insets = new Insets(0, 4, 0, 4);
        this.PanelBandUnit.add((Component)this.UnitsPanel, gridBagConstraints3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.PanelBandUnit, gridBagConstraints);
        this.userActionButton.setToolTipText("Click button to " + this.actionButtonString);
        this.userActionButton.setLabel(this.actionButtonString);
        this.userActionButton.setActionCommand("user_action");
        this.userActionButton.setText(this.actionButtonString);
        this.userActionButton.addActionListener(new ActionListener(this){
            private final /* synthetic */ GetAreaGUI this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                GetAreaGUI.access$10(this.this$0, actionEvent);
            }
            {
                this.this$0 = getAreaGUI;
                this.constructor$0(getAreaGUI);
            }

            private final void constructor$0(GetAreaGUI getAreaGUI) {
            }
        });
        this.UserActionPanel.add(this.userActionButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.getContentPane().add((Component)this.UserActionPanel, gridBagConstraints);
        this.statusLabel.setPreferredSize(new Dimension(320, 20));
        this.statusLabel.setEditable(false);
        this.statusLabel.setColumns(40);
        this.statusLabel.setForeground(Color.white);
        this.statusLabel.setText("First pick an ADDE server");
        this.statusLabel.setBackground(Color.black);
        this.statusLabel.setMinimumSize(new Dimension(100, 20));
        this.PanelStatus.add(this.statusLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        this.getContentPane().add((Component)this.PanelStatus, gridBagConstraints);
        this.PanelLoc.setLayout(new BorderLayout());
        this.PanelLoc.setBorder(new BevelBorder(0));
        this.jPanel11.setLayout(new FlowLayout(1, 5, 0));
        this.PlaceLabel.setText("Location:");
        this.jPanel11.add(this.PlaceLabel);
        this.LatLonButton.setToolTipText("Click to select lat/lon coordinates");
        this.LatLonButton.setLabel("Lat/Lon");
        this.LatLonButton.setSelected(true);
        this.LatLonButton.setActionCommand("LatLonButt");
        this.LatLonButton.addChangeListener(new ChangeListener(this){
            private final /* synthetic */ GetAreaGUI this$0;

            public void stateChanged(ChangeEvent changeEvent) {
                GetAreaGUI.access$11(this.this$0, changeEvent);
            }
            {
                this.this$0 = getAreaGUI;
                this.constructor$0(getAreaGUI);
            }

            private final void constructor$0(GetAreaGUI getAreaGUI) {
            }
        });
        this.jPanel11.add(this.LatLonButton);
        this.LinEleButton.setToolTipText("Click to select line/element coordinates");
        this.LinEleButton.setLabel("Line/Ele");
        this.LinEleButton.setActionCommand("LineEleButt");
        this.LinEleButton.addChangeListener(new ChangeListener(this){
            private final /* synthetic */ GetAreaGUI this$0;

            public void stateChanged(ChangeEvent changeEvent) {
                GetAreaGUI.access$12(this.this$0, changeEvent);
            }
            {
                this.this$0 = getAreaGUI;
                this.constructor$0(getAreaGUI);
            }

            private final void constructor$0(GetAreaGUI getAreaGUI) {
            }
        });
        this.jPanel11.add(this.LinEleButton);
        this.IDButton.setToolTipText("Click to select a station ID (Note: RADAR DATA ONLY!)");
        this.IDButton.setLabel("Line/Ele");
        this.IDButton.setActionCommand("IDButt");
        this.IDButton.setText("Stn ID");
        this.IDButton.addChangeListener(new ChangeListener(this){
            private final /* synthetic */ GetAreaGUI this$0;

            public void stateChanged(ChangeEvent changeEvent) {
                GetAreaGUI.access$13(this.this$0, changeEvent);
            }
            {
                this.this$0 = getAreaGUI;
                this.constructor$0(getAreaGUI);
            }

            private final void constructor$0(GetAreaGUI getAreaGUI) {
            }
        });
        this.jPanel11.add(this.IDButton);
        this.PanelLoc.add((Component)this.jPanel11, "North");
        this.jPanel12.setLayout(new GridLayout(2, 2, 5, 0));
        this.LatLineLabel.setText("Latitude");
        this.LatLineLabel.setHorizontalAlignment(0);
        this.jPanel12.add(this.LatLineLabel);
        this.LonEleLabel.setText("Longitude");
        this.LonEleLabel.setHorizontalAlignment(0);
        this.jPanel12.add(this.LonEleLabel);
        this.LatLineText.setToolTipText("Enter latitude or line coordinate or Radar Station ID");
        this.LatLineText.setText("Lat or line or stn ID value");
        this.jPanel12.add(this.LatLineText);
        this.LonEleText.setToolTipText("Enter longitude or element coordinate value");
        this.LonEleText.setText("Long or Element value");
        this.jPanel12.add(this.LonEleText);
        this.PanelLoc.add((Component)this.jPanel12, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.getContentPane().add((Component)this.PanelLoc, gridBagConstraints);
    }

    private void userDefaultsCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.useDefaults = this.userDefaultsCheckBox.isSelected();
    }

    private void BandBoxActionPerformed(ActionEvent actionEvent) {
        int n = this.BandBox.getSelectedIndex();
        if (n > 0) {
            this.replaceList(this.UnitBox, this.calInfo[1][n - 1], "Select Unit");
            int n2 = this.bandListIndex[n - 1];
            this.selectedBand = this.bandList[n - 1];
            this.selectedBandIndex = n - 1;
            if (!this.useDefaults || !this.gotUserDefaults) {
                double d = this.ad[this.areaIndex][n2].getCenterLatitude();
                double d2 = this.ad[this.areaIndex][n2].getCenterLongitude();
                if (!Double.isNaN(d) && !Double.isNaN(d2)) {
                    this.setCoordType("E");
                    this.setLocationString(d + " " + d2);
                }
                this.resLat = this.ad[this.areaIndex][n2].getCenterLatitudeResolution();
                this.resLon = this.ad[this.areaIndex][n2].getCenterLongitudeResolution();
                if (!Double.isNaN(this.resLat) && !Double.isNaN(this.resLon)) {
                    this.doingRes = true;
                }
                this.setLineMag(1);
                this.setEleMag(1);
                int n3 = this.ad[this.areaIndex][n2].getLines();
                int n4 = this.ad[this.areaIndex][n2].getElements();
                this.setNumLinesEles(n3 + " " + n4);
                if (this.useDefaults) {
                    this.gotUserDefaults = true;
                }
            }
        }
    }

    private void UnitBoxActionPerformed(ActionEvent actionEvent) {
        int n = this.UnitBox.getSelectedIndex();
        if (n > 0 && this.selectedBandIndex >= 0) {
            this.selectedUnit = this.calInfo[0][this.selectedBandIndex][n - 1];
        }
    }

    private void DateTimeListValueChanged(ListSelectionEvent listSelectionEvent) {
        String[][] stringArray;
        this.selectedDateTime = (String)this.DateTimeList.getSelectedValue();
        if (this.selectedDateTime == null) {
            return;
        }
        this.areaIndex = this.DateTimeList.getSelectedIndex();
        double d = this.ad[this.areaIndex][0].getCenterLatitude();
        double d2 = this.ad[this.areaIndex][0].getCenterLongitude();
        if (!this.useDefaults || !this.gotUserDefaults) {
            if (!Double.isNaN(d) && !Double.isNaN(d2)) {
                this.setCoordType("E");
                this.setLocationString(d + " " + d2);
            }
            this.resLat = this.ad[this.areaIndex][0].getCenterLatitudeResolution();
            this.resLon = this.ad[this.areaIndex][0].getCenterLongitudeResolution();
            if (!Double.isNaN(this.resLat) && !Double.isNaN(this.resLon)) {
                this.doingRes = true;
            }
            this.setLineMag(1);
            this.setEleMag(1);
            int n = this.ad[this.areaIndex][0].getLines();
            int n2 = this.ad[this.areaIndex][0].getElements();
            this.setNumLinesEles(n + " " + n2);
            if (this.useDefaults) {
                this.gotUserDefaults = true;
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<String[][]> arrayList3 = new ArrayList<String[][]>();
        this.asb = new AddeSatBands(this.asi.getBandNames());
        String[] stringArray2 = null;
        int n = 0;
        while (n < this.ad[this.areaIndex].length) {
            int n3 = this.ad[this.areaIndex][n].getNumberOfBands();
            int[] nArray = this.ad[this.areaIndex][n].getBands();
            String[] stringArray3 = new String[n3];
            Vector[] vectorArray = this.ad[this.areaIndex][n].getCalInfo();
            int n4 = this.ad[this.areaIndex][n].getSensorID();
            String string = this.ad[this.areaIndex][n].getSourceType();
            stringArray2 = this.asb.getBandDescr(n4, string);
            int n5 = 0;
            while (n5 < n3) {
                int n6;
                stringArray3[n5] = Integer.toString(nArray[n5]);
                arrayList.add(stringArray3[n5]);
                arrayList2.add(new Integer(n));
                stringArray = new String[2][1];
                stringArray[0][0] = "RAW";
                stringArray[1][0] = "Raw values";
                if (vectorArray[n5] != null && (n6 = vectorArray[n5].size() / 2) > 0) {
                    stringArray = new String[2][n6];
                    int n7 = 0;
                    while (n7 < n6) {
                        stringArray[0][n7] = (String)vectorArray[n5].elementAt(2 * n7);
                        stringArray[1][n7] = (String)vectorArray[n5].elementAt(2 * n7 + 1);
                        ++n7;
                    }
                }
                arrayList3.add(stringArray);
                ++n5;
            }
            ++n;
        }
        n = arrayList.size();
        if (n != 0) {
            this.bandList = new String[n];
            this.bandListIndex = new int[n];
            String[] stringArray4 = new String[n];
            this.calInfo = new String[2][n][];
            int n8 = 0;
            while (n8 < n) {
                int n9;
                this.bandList[n8] = (String)arrayList.get(n8);
                stringArray4[n8] = this.bandList[n8];
                if (stringArray2 != null && (n9 = Integer.valueOf(this.bandList[n8]).intValue()) > 0 && n9 < stringArray2.length) {
                    stringArray4[n8] = this.bandList[n8] + " - " + stringArray2[n9];
                }
                this.bandListIndex[n8] = (Integer)arrayList2.get(n8);
                stringArray = (String[][])arrayList3.get(n8);
                int n10 = stringArray[0].length;
                this.calInfo[0][n8] = stringArray[0];
                this.calInfo[1][n8] = stringArray[1];
                ++n8;
            }
            if (this.bandList.length == 1) {
                this.replaceList(this.BandBox, stringArray4, null);
                this.replaceList(this.UnitBox, this.calInfo[1][0], "Select Unit");
                this.selectedBand = this.bandList[0];
                this.selectedBandIndex = 0;
            } else {
                this.replaceList(this.BandBox, stringArray4, "Select band");
                this.replaceList(this.UnitBox, null, " ");
                this.selectedBand = this.bandList[0];
                this.selectedBandIndex = 1;
            }
        }
        this.status("Set the other parameters you want");
    }

    public synchronized void status(String string) {
        this.statusLabel.setText(string);
        this.statusLabel.validate();
    }

    public void addActionListener(Object object) {
        this.al = (ActionListener)object;
    }

    private void userActionButtonActionPerformed(ActionEvent actionEvent) {
        Object object;
        this.status("Processing...please wait...");
        String string = this.getServer() + "|" + this.getGroup() + "|" + this.getDescr();
        ((Hashtable)this.dataProp).put(string + "|CoordType", this.getCoordType());
        ((Hashtable)this.dataProp).put(string + "|Location", this.getLocationString());
        ((Hashtable)this.dataProp).put(string + "|Size", this.getNumLinesEles());
        ((Hashtable)this.dataProp).put(string + "|Mag", this.getMag());
        if (this.serverList != null) {
            ((Hashtable)this.dataProp).put("user|server|list", this.serverList.toString());
        }
        try {
            object = new FileOutputStream("GetAreaGUI.properties");
            this.dataProp.save((OutputStream)object, "GetAreaGUI");
            ((FileOutputStream)object).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = " ";
        if (this.coordType.equals("E")) {
            object = "&latlon=";
        } else if (this.coordType.equals("I")) {
            object = "&linele=";
        } else if (this.coordType.equals("S")) {
            object = "&id=";
        }
        String string2 = this.getUserName();
        string2 = string2 == null || string2.length() < 2 ? " " : "&user=" + this.getUserName() + "&proj=" + this.getProjectNumber();
        String string3 = this.getUnit();
        if (string3 == null || string3.length() < 3) {
            string3 = "BRIT";
        }
        String string4 = "adde://" + this.getServer() + "/imagedata?group=" + this.getGroup() + "&descr=" + this.getDescr() + (String)object + this.getLocationString() + "&size=" + this.getNumLinesEles() + "&day=" + this.getDay() + "&time=" + this.getTime() + " " + this.getTime() + " I " + "&band=" + this.getBand() + "&unit=" + string3 + "&mag=" + this.getMag() + string2 + "&version=1";
        System.out.println("cmdout = " + string4);
        if (this.al != null) {
            this.al.actionPerformed(new ActionEvent(this, 1001, string4));
        }
        if (this.closeOnAction) {
            this.dispose();
        }
    }

    private synchronized void setLocButtonLabel() {
        if (this.LatLonButton.isSelected()) {
            this.LatLineLabel.setText("Latitude");
            this.LonEleLabel.setText("Longitude");
            this.coordType = "E";
        } else if (this.LinEleButton.isSelected()) {
            this.LatLineLabel.setText("Image Line");
            this.LonEleLabel.setText("Image Element");
            this.coordType = "I";
        } else if (this.IDButton.isSelected()) {
            this.LatLineLabel.setText("Radar Station ID");
            this.LonEleLabel.setText(" ");
            this.coordType = "S";
        }
    }

    private void IDButtonStateChanged(ChangeEvent changeEvent) {
        this.setLocButtonLabel();
    }

    private void LinEleButtonStateChanged(ChangeEvent changeEvent) {
        this.setLocButtonLabel();
    }

    private void LatLonButtonStateChanged(ChangeEvent changeEvent) {
        this.setLocButtonLabel();
    }

    private void EMagSliderStateChanged(ChangeEvent changeEvent) {
        int n = this.EMagSlider.getValue();
        this.setEleMag(n - 50);
        if (this.baseNumEles < 1) {
            return;
        }
        int n2 = this.baseNumEles * this.EMagValue;
        if (this.EMagValue < 0) {
            n2 = this.baseNumEles / -this.EMagValue;
        }
        this.NumElesText.setText(Integer.toString(n2));
    }

    private void LMagSliderStateChanged(ChangeEvent changeEvent) {
        int n = this.LMagSlider.getValue();
        this.setLineMag(n - 50);
        this.setEleMag(n - 50);
        if (this.baseNumLines < 1) {
            return;
        }
        int n2 = this.baseNumLines * this.LMagValue;
        if (this.LMagValue < 0) {
            n2 = this.baseNumLines / -this.LMagValue;
        }
        this.NumLinesText.setText(Integer.toString(n2));
    }

    private void DescrSelectorActionPerformed(ActionEvent actionEvent) {
        if (this.serverUpdated) {
            return;
        }
        if (this.groupUpdated) {
            return;
        }
        this.areaIndex = -1;
        Thread thread = new Thread(this){
            private final /* synthetic */ GetAreaGUI this$0;

            public void run() {
                int n = GetAreaGUI.access$14(this.this$0).getSelectedIndex();
                String[] stringArray = this.this$0.asi.getDatasetList();
                if (n > 0 && stringArray != null) {
                    this.this$0.selectedDescr = stringArray[n - 1];
                    this.this$0.status("Getting dates and times from server...may take a while!!");
                    this.this$0.asi.setSelectedDataset(this.this$0.selectedDescr);
                    String[] stringArray2 = this.this$0.asi.getDateTimeList();
                    this.this$0.ad = this.this$0.asi.getAreaDirectories();
                    GetAreaGUI.access$15(this.this$0).setListData(stringArray2);
                    GetAreaGUI.access$15(this.this$0).revalidate();
                    this.this$0.status("Now pick a day & time from the list, or set a Position number");
                    String string = this.this$0.getServer() + "|" + this.this$0.getGroup() + "|" + this.this$0.getDescr();
                    String string2 = (String)((Hashtable)this.this$0.dataProp).get(string + "|CoordType");
                    this.this$0.gotUserDefaults = false;
                    if (string2 != null) {
                        this.this$0.setCoordType(string2);
                        this.this$0.gotUserDefaults = true;
                    }
                    if ((string2 = (String)((Hashtable)this.this$0.dataProp).get(string + "|Location")) != null) {
                        this.this$0.setLocationString(string2);
                        this.this$0.gotUserDefaults = true;
                    }
                    if ((string2 = (String)((Hashtable)this.this$0.dataProp).get(string + "|Size")) != null) {
                        this.this$0.setNumLinesEles(string2);
                        this.this$0.gotUserDefaults = true;
                    }
                    if ((string2 = (String)((Hashtable)this.this$0.dataProp).get(string + "|Mag")) != null) {
                        this.this$0.setMag(string2);
                        this.this$0.gotUserDefaults = true;
                    }
                }
            }
            {
                this.this$0 = getAreaGUI;
                this.constructor$0(getAreaGUI);
            }

            private final void constructor$0(GetAreaGUI getAreaGUI) {
            }
        };
        thread.start();
        this.doingRes = false;
        this.setLineMag(1);
        this.setEleMag(1);
        this.setCoordType("E");
        this.setLocationString(null);
        this.setNumLinesEles(null);
        String[] stringArray = new String[]{"Day and times for", "selected dataset will", "appear here"};
        this.DateTimeList.setListData(stringArray);
        this.DateTimeList.revalidate();
    }

    private void GroupSelectorActionPerformed(ActionEvent actionEvent) {
        if (this.serverUpdated) {
            return;
        }
        this.areaIndex = -1;
        Thread thread = new Thread(this){
            private final /* synthetic */ GetAreaGUI this$0;

            public void run() {
                this.this$0.selectedGroup = (String)GetAreaGUI.access$16(this.this$0).getSelectedItem();
                this.this$0.asi.setSelectedGroup(this.this$0.selectedGroup);
                this.this$0.bandNames = this.this$0.asi.getBandNames();
                String[] stringArray = this.this$0.asi.getDatasetListDescriptions();
                this.this$0.groupUpdated = true;
                GetAreaGUI.access$17(this.this$0, GetAreaGUI.access$14(this.this$0), stringArray, "Select Dataset");
                this.this$0.groupUpdated = false;
                this.this$0.status("Now choose a Dataset from the list");
                GetAreaGUI.access$17(this.this$0, GetAreaGUI.access$18(this.this$0), null, "        ");
                GetAreaGUI.access$17(this.this$0, GetAreaGUI.access$19(this.this$0), null, "        ");
            }
            {
                this.this$0 = getAreaGUI;
                this.constructor$0(getAreaGUI);
            }

            private final void constructor$0(GetAreaGUI getAreaGUI) {
            }
        };
        thread.start();
        this.DateTimeList.removeAll();
        String[] stringArray = new String[]{"Day and times for", "selected dataset will", "appear here"};
        this.DateTimeList.setListData(stringArray);
        this.DateTimeList.revalidate();
    }

    private void ServerSelectorActionPerformed(ActionEvent actionEvent) {
        Thread thread = new Thread(this){
            private final /* synthetic */ GetAreaGUI this$0;

            public void run() {
                String string;
                String[] stringArray;
                this.this$0.serverUpdated = true;
                GetAreaGUI.access$17(this.this$0, GetAreaGUI.access$16(this.this$0), null, "Please wait...");
                this.this$0.status("Reading information from server...");
                this.this$0.selectedServer = (String)GetAreaGUI.access$20(this.this$0).getSelectedItem();
                int n = -1;
                while (n == -1) {
                    stringArray = this.this$0.getUserName();
                    if (stringArray != null && stringArray.length() >= 2) {
                        string = "user=" + (String)stringArray + "&proj=" + this.this$0.getProjectNumber();
                        this.this$0.asi.setUserIDandProjString(string);
                    }
                    n = this.this$0.asi.setSelectedServer(this.this$0.selectedServer, "image");
                    if (n != -1) continue;
                    string = JOptionPane.showInputDialog("User ID and project number required by this server!\nPlease enter them here (eg., jack 1234)");
                    if (string != null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                        if (stringTokenizer.countTokens() != 2) continue;
                        this.this$0.setUserName(stringTokenizer.nextToken());
                        this.this$0.setProjectNumber(stringTokenizer.nextToken());
                        continue;
                    }
                    n = -5;
                }
                if (n >= 0) {
                    if (GetAreaGUI.access$20(this.this$0).getSelectedIndex() == -1) {
                        GetAreaGUI.access$20(this.this$0).addItem(this.this$0.selectedServer);
                        this.this$0.serverList.append("," + this.this$0.selectedServer);
                    }
                    if ((stringArray = this.this$0.asi.getGroupList()) == null) {
                        GetAreaGUI.access$16(this.this$0).setEditable(true);
                        string = "Enter the group name";
                    } else {
                        GetAreaGUI.access$16(this.this$0).setEditable(false);
                        string = "Select group";
                    }
                    GetAreaGUI.access$17(this.this$0, GetAreaGUI.access$16(this.this$0), stringArray, string);
                    this.this$0.serverUpdated = false;
                    this.this$0.status("Now - " + string + " to use...");
                } else {
                    this.this$0.status("Pick a different server!");
                    this.this$0.serverUpdated = false;
                }
            }
            {
                this.this$0 = getAreaGUI;
                this.constructor$0(getAreaGUI);
            }

            private final void constructor$0(GetAreaGUI getAreaGUI) {
            }
        };
        thread.start();
        this.areaIndex = -1;
        this.DescrSelector.removeAllItems();
        this.DateTimeList.removeAll();
        String[] stringArray = new String[]{"Day and times for", "selected dataset will", "appear here"};
        this.DateTimeList.setListData(stringArray);
        this.DateTimeList.revalidate();
        this.DescrSelector.revalidate();
    }

    private void replaceList(JComboBox jComboBox, String[] stringArray, String string) {
        if (jComboBox.getItemCount() > 0) {
            jComboBox.removeAllItems();
        }
        if (string != null) {
            jComboBox.addItem(string);
        }
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                jComboBox.addItem(stringArray[n].trim());
                ++n;
            }
        }
        jComboBox.setSelectedIndex(0);
        jComboBox.revalidate();
    }

    private void exitForm(WindowEvent windowEvent) {
        this.dispose();
    }

    public static void main(String[] stringArray) {
        GetAreaGUI getAreaGUI = new GetAreaGUI("avoid pain", false, false);
        getAreaGUI.show();
        getAreaGUI.setUserName("tomw");
        getAreaGUI.setProjectNumber("1234");
    }

    static /* synthetic */ void access$0(GetAreaGUI getAreaGUI, WindowEvent windowEvent) {
        getAreaGUI.exitForm(windowEvent);
    }

    static /* synthetic */ void access$1(GetAreaGUI getAreaGUI, ActionEvent actionEvent) {
        getAreaGUI.ServerSelectorActionPerformed(actionEvent);
    }

    static /* synthetic */ void access$2(GetAreaGUI getAreaGUI, ActionEvent actionEvent) {
        getAreaGUI.GroupSelectorActionPerformed(actionEvent);
    }

    static /* synthetic */ void access$3(GetAreaGUI getAreaGUI, ActionEvent actionEvent) {
        getAreaGUI.DescrSelectorActionPerformed(actionEvent);
    }

    static /* synthetic */ void access$4(GetAreaGUI getAreaGUI, ChangeEvent changeEvent) {
        getAreaGUI.LMagSliderStateChanged(changeEvent);
    }

    static /* synthetic */ void access$5(GetAreaGUI getAreaGUI, ChangeEvent changeEvent) {
        getAreaGUI.EMagSliderStateChanged(changeEvent);
    }

    static /* synthetic */ void access$6(GetAreaGUI getAreaGUI, ListSelectionEvent listSelectionEvent) {
        getAreaGUI.DateTimeListValueChanged(listSelectionEvent);
    }

    static /* synthetic */ void access$7(GetAreaGUI getAreaGUI, ActionEvent actionEvent) {
        getAreaGUI.userDefaultsCheckBoxActionPerformed(actionEvent);
    }

    static /* synthetic */ void access$8(GetAreaGUI getAreaGUI, ActionEvent actionEvent) {
        getAreaGUI.BandBoxActionPerformed(actionEvent);
    }

    static /* synthetic */ void access$9(GetAreaGUI getAreaGUI, ActionEvent actionEvent) {
        getAreaGUI.UnitBoxActionPerformed(actionEvent);
    }

    static /* synthetic */ void access$10(GetAreaGUI getAreaGUI, ActionEvent actionEvent) {
        getAreaGUI.userActionButtonActionPerformed(actionEvent);
    }

    static /* synthetic */ void access$11(GetAreaGUI getAreaGUI, ChangeEvent changeEvent) {
        getAreaGUI.LatLonButtonStateChanged(changeEvent);
    }

    static /* synthetic */ void access$12(GetAreaGUI getAreaGUI, ChangeEvent changeEvent) {
        getAreaGUI.LinEleButtonStateChanged(changeEvent);
    }

    static /* synthetic */ void access$13(GetAreaGUI getAreaGUI, ChangeEvent changeEvent) {
        getAreaGUI.IDButtonStateChanged(changeEvent);
    }

    static /* synthetic */ JComboBox access$14(GetAreaGUI getAreaGUI) {
        return getAreaGUI.DescrSelector;
    }

    static /* synthetic */ JList access$15(GetAreaGUI getAreaGUI) {
        return getAreaGUI.DateTimeList;
    }

    static /* synthetic */ JComboBox access$16(GetAreaGUI getAreaGUI) {
        return getAreaGUI.GroupSelector;
    }

    static /* synthetic */ void access$17(GetAreaGUI getAreaGUI, JComboBox jComboBox, String[] stringArray, String string) {
        getAreaGUI.replaceList(jComboBox, stringArray, string);
    }

    static /* synthetic */ JComboBox access$18(GetAreaGUI getAreaGUI) {
        return getAreaGUI.UnitBox;
    }

    static /* synthetic */ JComboBox access$19(GetAreaGUI getAreaGUI) {
        return getAreaGUI.BandBox;
    }

    static /* synthetic */ JComboBox access$20(GetAreaGUI getAreaGUI) {
        return getAreaGUI.ServerSelector;
    }

    public GetAreaGUI(String string) {
        this((Frame)null, false, string, false, true);
    }

    public GetAreaGUI(String string, boolean bl) {
        this((Frame)null, false, string, bl, true);
    }

    public GetAreaGUI(String string, boolean bl, boolean bl2) {
        this((Frame)null, false, string, bl, bl2);
    }

    public GetAreaGUI(Dialog dialog, boolean bl, String string, boolean bl2, boolean bl3) {
        super(dialog, "ADDE image data picker", bl);
        this.setupGUI(string, bl2, bl3);
    }

    public GetAreaGUI(Frame frame, boolean bl, String string, boolean bl2, boolean bl3) {
        super(frame, "ADDE image data picker", bl);
        this.setupGUI(string, bl2, bl3);
    }
}

